/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.api.item.IItemOrderablePageProvider;
import com.xcompwiz.mystcraft.api.item.IItemPageProvider;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.inventory.ContainerBase;
import com.xcompwiz.mystcraft.inventory.FluidTankProvider;
import com.xcompwiz.mystcraft.inventory.IBookContainer;
import com.xcompwiz.mystcraft.inventory.IFluidTankProvider;
import com.xcompwiz.mystcraft.inventory.PageCollectionPageReceiver;
import com.xcompwiz.mystcraft.inventory.SlotCollection;
import com.xcompwiz.mystcraft.inventory.SlotFiltered;
import com.xcompwiz.mystcraft.item.ItemAgebook;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.item.LinkItemUtils;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.linking.LinkListenerManager;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketGuiMessage;
import com.xcompwiz.mystcraft.tileentity.IOInventory;
import com.xcompwiz.mystcraft.tileentity.TileEntityDesk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerWritingDesk
extends ContainerBase
implements IGuiMessageHandler,
IBookContainer,
PageCollectionPageReceiver.IItemProvider {
    private static final int xShift = 233;
    private static final int yShift = 20;
    private static final int tabslots = 4;
    private byte activeslot;
    private byte firstslot;
    private TileEntityDesk tileentity;
    private FluidStack fluid;
    @Nonnull
    private ItemStack currentpage = ItemStack.field_190927_a;
    private int currentpageIndex;
    private int pagecount;
    private ILinkInfo cached_linkinfo;
    private boolean cached_permitted;
    @Nonnull
    private String cached_title = "";
    private EntityPlayer player;
    private FluidTankProvider fluidDataContainer = new FluidTankProvider();

    public ContainerWritingDesk(InventoryPlayer inventoryplayer, TileEntityDesk te) {
        this.tileentity = te;
        this.activeslot = 0;
        this.firstslot = 0;
        this.currentpageIndex = 0;
        this.pagecount = 0;
        this.player = inventoryplayer.field_70458_d;
        this.fluidDataContainer.setTank(te.getInkwell());
        IOInventory inventory = te.getContainerItemHandler();
        for (int i = 0; i < 4; ++i) {
            SlotFiltered slot = new SlotFiltered(inventory, this.tileentity, i + this.tileentity.getMainInventorySize(), 37, 14 + i * 37 + 20);
            slot.setSlotStackLimit(1);
            this.func_75146_a((Slot)slot);
        }
        SlotFiltered slot = new SlotFiltered(inventory, this.tileentity, 0, 241, 80);
        slot.setSlotStackLimit(1);
        this.func_75146_a((Slot)slot);
        this.func_75146_a((Slot)new SlotFiltered(inventory, this.tileentity, 1, 241, 28));
        this.func_75146_a((Slot)new SlotFiltered(inventory, this.tileentity, 2, 385, 28));
        this.func_75146_a((Slot)new SlotFiltered(inventory, this.tileentity, 3, 385, 80));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18 + 233, 84 + i * 18 + 20));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, j, 8 + j * 18 + 233, 162));
        }
        SlotCollection internal = new SlotCollection(this, 0, 8);
        SlotCollection maininv = new SlotCollection(this, 8, 35);
        SlotCollection hotbar = new SlotCollection(this, 35, 44);
        PageCollectionPageReceiver pagecollectionreceiver = new PageCollectionPageReceiver(this, this.player);
        internal.pushTargetFront(maininv);
        internal.pushTargetFront(hotbar);
        maininv.pushTargetFront(hotbar);
        maininv.pushTargetFront(internal);
        maininv.pushTargetFront(pagecollectionreceiver);
        hotbar.pushTargetFront(maininv);
        hotbar.pushTargetFront(internal);
        hotbar.pushTargetFront(pagecollectionreceiver);
        this.collections.add(internal);
        this.collections.add(maininv);
        this.collections.add(hotbar);
    }

    @Override
    public ItemStack getPageCollection() {
        return this.getTabSlot(this.activeslot);
    }

    private void updateSurfaceTabSlots() {
        for (int i = 0; i < 4; ++i) {
            ((SlotFiltered)((Object)this.field_75151_b.get(i))).setSlotIndex(i + this.tileentity.getMainInventorySize() + this.firstslot);
        }
    }

    public void func_75142_b() {
        String temp_title;
        super.func_75142_b();
        ArrayList<MPacketGuiMessage> packets = new ArrayList<MPacketGuiMessage>();
        ItemStack actual = ((Slot)this.field_75151_b.get(4)).func_75211_c();
        ItemStack stored = (ItemStack)this.field_75153_a.get(4);
        if (!ItemStack.func_77989_b((ItemStack)actual, (ItemStack)stored)) {
            this.cached_linkinfo = null;
            this.cached_permitted = false;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("SetCurrentPage", this.currentpageIndex);
            packets.add(new MPacketGuiMessage(this.field_75152_c, nbttagcompound));
        }
        for (int slotId = 0; slotId < this.field_75151_b.size(); ++slotId) {
            actual = ((Slot)this.field_75151_b.get(slotId)).func_75211_c();
            stored = (ItemStack)this.field_75153_a.get(slotId);
            if (ItemStack.func_77989_b((ItemStack)stored, (ItemStack)actual)) continue;
            stored = actual.func_190926_b() ? ItemStack.field_190927_a : actual.func_77946_l();
            this.field_75153_a.set(slotId, (Object)stored);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((Container)this, slotId, stored);
            }
        }
        boolean perm = this.checkLinkPermitted();
        if (this.cached_permitted != perm) {
            this.cached_permitted = perm;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74757_a("LinkPermitted", this.cached_permitted);
            packets.add(new MPacketGuiMessage(this.field_75152_c, nbttagcompound));
        }
        if (!this.cached_title.equals(temp_title = this.tileentity.getTargetString(this.player))) {
            this.cached_title = temp_title;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74778_a("SetTitle", this.cached_title);
            packets.add(new MPacketGuiMessage(this.field_75152_c, nbttagcompound));
        }
        if (packets.size() > 0) {
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                for (IMessage iMessage : packets) {
                    MystcraftPacketHandler.CHANNEL.sendTo(iMessage, (EntityPlayerMP)listener);
                }
            }
        }
    }

    private boolean hasFluidChanged(FluidStack fluid, FluidStack temp) {
        if (fluid == null && temp == null) {
            return false;
        }
        if (fluid == null && temp != null) {
            return true;
        }
        if (fluid != null && temp == null) {
            return true;
        }
        return !fluid.isFluidStackIdentical(temp);
    }

    @Override
    public void processMessage(@Nonnull EntityPlayer player, @Nonnull NBTTagCompound data) {
        ItemStack target;
        if (data.func_74764_b("LinkPermitted")) {
            this.cached_permitted = data.func_74767_n("LinkPermitted");
        }
        if (data.func_74764_b("SetTitle")) {
            this.cached_title = data.func_74779_i("SetTitle");
            this.tileentity.setBookTitle(player, this.cached_title);
        }
        if (data.func_74764_b("Link") && this.tileentity != null) {
            this.tileentity.link((Entity)player);
        }
        if (data.func_74764_b("RemoveFromCollection")) {
            if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                return;
            }
            ItemStack page = new ItemStack(data.func_74775_l("RemoveFromCollection"));
            ItemStack itemstack = this.tileentity.removePageFromSurface(player, this.getTabSlot(this.activeslot), page);
            player.field_71071_by.func_70437_b(itemstack);
        }
        if (data.func_74764_b("RemoveFromOrderedCollection")) {
            if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                return;
            }
            int index = data.func_74762_e("RemoveFromOrderedCollection");
            player.field_71071_by.func_70437_b(this.tileentity.removePageFromSurface(player, this.getTabSlot(this.activeslot), index));
        }
        if (data.func_74764_b("AddToCollection")) {
            if (player.field_71071_by.func_70445_o().func_190926_b()) {
                return;
            }
            byte slot = data.func_74771_c("AddToCollection");
            if (this.tileentity.getTabItem(slot).func_190926_b()) {
                return;
            }
            boolean single = data.func_74767_n("Single");
            if (single) {
                ItemStack stack = player.field_71071_by.func_70445_o();
                ItemStack one = stack.func_77946_l();
                one.func_190920_e(1);
                ItemStack ret = this.tileentity.addPageToTab(player, this.tileentity.getTabItem(slot), one.func_77946_l());
                if (ItemStack.func_77970_a((ItemStack)ret, (ItemStack)one) && ItemStack.func_77989_b((ItemStack)ret, (ItemStack)one)) {
                    return;
                }
                stack.func_190918_g(1);
                if (stack.func_190916_E() <= 0) {
                    stack = ItemStack.field_190927_a;
                }
                player.field_71071_by.func_70437_b(stack);
                if (ret.func_190926_b()) {
                    return;
                }
                if (stack.func_190926_b()) {
                    player.field_71071_by.func_70437_b(ret);
                    return;
                }
                if (ItemStack.func_77970_a((ItemStack)ret, (ItemStack)stack)) {
                    stack.func_190917_f(ret.func_190916_E());
                    return;
                }
            } else {
                player.field_71071_by.func_70437_b(this.tileentity.addPageToTab(player, this.tileentity.getTabItem(slot), player.field_71071_by.func_70445_o()));
            }
        }
        if (data.func_74764_b("AddToSurface")) {
            if (player.field_71071_by.func_70445_o().func_190926_b()) {
                return;
            }
            if (!data.func_74764_b("Index")) {
                return;
            }
            byte slot = data.func_74771_c("AddToSurface");
            if (this.tileentity.getTabItem(slot).func_190926_b()) {
                return;
            }
            boolean single = data.func_74767_n("Single");
            int index = data.func_74762_e("Index");
            if (single) {
                ItemStack stack = player.field_71071_by.func_70445_o();
                ItemStack clone = stack.func_77946_l();
                clone.func_190920_e(1);
                ItemStack returned = this.tileentity.placePageOnSurface(player, this.tileentity.getTabItem(slot), clone, index);
                if (returned.func_190926_b() || stack.func_190916_E() == 1) {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() <= 0) {
                        stack = returned;
                    }
                    player.field_71071_by.func_70437_b(stack);
                } else {
                    this.tileentity.placePageOnSurface(player, this.tileentity.getTabItem(slot), returned, index);
                }
            } else {
                player.field_71071_by.func_70437_b(this.tileentity.placePageOnSurface(player, this.tileentity.getTabItem(slot), player.field_71071_by.func_70445_o(), index));
            }
        }
        if (data.func_74764_b("WriteSymbol")) {
            this.tileentity.writeSymbol(player, data.func_74779_i("WriteSymbol"));
        }
        if (data.func_74764_b("SetActiveNotebook")) {
            this.activeslot = data.func_74771_c("SetActiveNotebook");
        }
        if (data.func_74764_b("SetFirstNotebook")) {
            this.firstslot = data.func_74771_c("SetFirstNotebook");
            if (this.firstslot < 0) {
                this.firstslot = 0;
            }
            if (this.firstslot >= this.tileentity.getMaxSurfaceTabCount()) {
                this.firstslot = 0;
            }
            this.updateSurfaceTabSlots();
        }
        if (data.func_74764_b("SetCurrentPage") && this.tileentity.func_145831_w().field_72995_K) {
            this.setCurrentPageIndex(data.func_74762_e("SetCurrentPage"));
            this.cached_linkinfo = null;
        }
        if (data.func_74764_b("TakeFromSlider")) {
            target = this.tileentity.getTarget();
            if (target.func_190926_b()) {
                return;
            }
            if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                return;
            }
            if (!(target.func_77973_b() instanceof IItemOrderablePageProvider)) {
                return;
            }
            IItemOrderablePageProvider itemdat = (IItemOrderablePageProvider)target.func_77973_b();
            int index = data.func_74762_e("TakeFromSlider");
            player.field_71071_by.func_70437_b(itemdat.removePage(player, target, index));
        }
        if (data.func_74764_b("InsertHeldAt")) {
            target = this.tileentity.getTarget();
            if (target.func_190926_b()) {
                return;
            }
            ItemStack stack = player.field_71071_by.func_70445_o();
            if (stack.func_190926_b()) {
                return;
            }
            if (stack.func_190916_E() > 1) {
                return;
            }
            if (!(target.func_77973_b() instanceof IItemOrderablePageProvider)) {
                return;
            }
            IItemOrderablePageProvider itemdat = (IItemOrderablePageProvider)target.func_77973_b();
            int index = data.func_74762_e("InsertHeldAt");
            player.field_71071_by.func_70437_b(itemdat.setPage(player, target, stack, index));
        }
    }

    @Nonnull
    public ItemStack getTabSlot(byte slot) {
        return this.tileentity.getTabItem(slot);
    }

    public byte getActiveTabSlot() {
        return this.activeslot;
    }

    public byte getFirstTabSlot() {
        return this.firstslot;
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return !this.tileentity.func_145837_r();
    }

    private List<ItemStack> getPageList() {
        ItemStack book = this.getBook();
        if (book.func_190926_b()) {
            return null;
        }
        if (book.func_77973_b() instanceof IItemPageProvider) {
            return ((IItemPageProvider)book.func_77973_b()).getPageList(this.player, book);
        }
        return null;
    }

    @Override
    public void setCurrentPageIndex(int index) {
        List<ItemStack> pagelist;
        this.currentpage = ItemStack.field_190927_a;
        this.currentpageIndex = 0;
        if (index < 0) {
            index = 0;
        }
        if ((pagelist = this.getPageList()) == null) {
            index = 0;
            this.pagecount = 0;
        } else {
            this.pagecount = pagelist.size();
            if (index >= this.pagecount) {
                index = this.pagecount;
            } else {
                this.currentpage = pagelist.get(index);
            }
        }
        this.currentpageIndex = index;
    }

    @Override
    @Nonnull
    public ItemStack getCurrentPage() {
        if (this.currentpage.func_190926_b()) {
            this.setCurrentPageIndex(this.currentpageIndex);
        }
        return this.currentpage;
    }

    @Override
    public int getCurrentPageIndex() {
        return this.currentpageIndex;
    }

    @Override
    public int getPageCount() {
        return this.pagecount;
    }

    @Override
    public boolean hasBookSlot() {
        return false;
    }

    @Override
    public boolean isTargetWorldVisited() {
        Integer dim = LinkItemUtils.getTargetDimension(this.getBook());
        return dim != null && DimensionUtils.isDimensionVisited(dim);
    }

    @Override
    @Nonnull
    public ItemStack getBook() {
        if (this.tileentity != null) {
            ItemStack itemstack = this.tileentity.getTarget();
            if (itemstack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (itemstack.func_77973_b() instanceof ItemLinking) {
                return itemstack;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack getTarget() {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (this.tileentity != null) {
            itemstack = this.tileentity.getTarget();
        }
        return itemstack;
    }

    @Override
    public ILinkInfo getLinkInfo() {
        ItemStack book = this.getBook();
        if (book.func_190926_b() || !(book.func_77973_b() instanceof ItemLinking)) {
            return null;
        }
        if (this.cached_linkinfo == null) {
            this.cached_linkinfo = ((ItemLinking)book.func_77973_b()).getLinkInfo(book);
        }
        return this.cached_linkinfo;
    }

    @Override
    public boolean isLinkPermitted() {
        ILinkInfo linkinfo = this.getLinkInfo();
        if (linkinfo == null) {
            this.cached_permitted = false;
        }
        return this.cached_permitted;
    }

    private boolean checkLinkPermitted() {
        ILinkInfo linkinfo = this.getLinkInfo();
        if (linkinfo == null) {
            return false;
        }
        if (ItemAgebook.isNewAgebook(this.getBook())) {
            return true;
        }
        return LinkListenerManager.isLinkPermitted(this.tileentity.func_145831_w(), (Entity)this.player, linkinfo);
    }

    @Override
    public String getBookTitle() {
        ItemStack book = this.getBook();
        if (book.func_190926_b() || !(book.func_77973_b() instanceof ItemLinking)) {
            return "";
        }
        return ((ItemLinking)book.func_77973_b()).getTitle(book);
    }

    @Override
    public Collection<String> getBookAuthors() {
        ItemStack book = this.getBook();
        if (book.func_190926_b()) {
            return Collections.emptySet();
        }
        return ((ItemLinking)book.func_77973_b()).getAuthors(book);
    }

    public IFluidTankProvider getInkTankProvider() {
        return this.fluidDataContainer;
    }

    public String getTargetName() {
        return this.cached_title;
    }

    public List<ItemStack> getBookPageList() {
        if (this.tileentity != null) {
            return this.tileentity.getBookPageList(this.player);
        }
        return null;
    }

    public static class Messages {
        public static final String LinkPermitted = "LinkPermitted";
        public static final String SetCurrentPage = "SetCurrentPage";
        public static final String SetTitle = "SetTitle";
        public static final String Link = "Link";
        public static final String RemoveFromCollection = "RemoveFromCollection";
        public static final String RemoveFromOrderedCollection = "RemoveFromOrderedCollection";
        public static final String AddToTab = "AddToCollection";
        public static final String AddToSurface = "AddToSurface";
        public static final String WriteSymbol = "WriteSymbol";
        public static final String SetActiveNotebook = "SetActiveNotebook";
        public static final String SetFirstNotebook = "SetFirstNotebook";
        public static final String TakeFromSlider = "TakeFromSlider";
        public static final String InsertHeldAt = "InsertHeldAt";
    }
}

