/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability.bonus;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EventManager {
    private static EventManager instance;
    private static ConcurrentMap<IOnEntityDeath, Boolean> entitydeathlisteners;
    private static ConcurrentMap<IOnPlayerChangedDimension, Boolean> dimchangelisteners;
    private static ConcurrentMap<IOnPlayerLoggedIn, Boolean> loggedinlisteners;
    private static ConcurrentMap<IOnPlayerLoggedOut, Boolean> loggedoutlisteners;

    public static EventManager get() {
        if (instance == null) {
            throw new RuntimeException("Event Listener Manager for Instability Bonus System not registered.");
        }
        return instance;
    }

    public static void set(EventManager newinstance) {
        if (instance != null) {
            throw new RuntimeException("Event Listener Manager for Instability Bonus System registered multiple times.");
        }
        instance = newinstance;
    }

    public void register(IOnEntityDeath listener) {
        entitydeathlisteners.put(listener, true);
    }

    public void register(IOnPlayerChangedDimension listener) {
        dimchangelisteners.put(listener, true);
    }

    public void register(IOnPlayerLoggedIn listener) {
        loggedinlisteners.put(listener, true);
    }

    public void register(IOnPlayerLoggedOut listener) {
        loggedoutlisteners.put(listener, true);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        for (IOnPlayerChangedDimension listener : dimchangelisteners.keySet()) {
            listener.onPlayerChangedDimension(event);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        for (IOnPlayerLoggedIn listener : loggedinlisteners.keySet()) {
            listener.onPlayerLoggedIn(event);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        for (IOnPlayerLoggedOut listener : loggedoutlisteners.keySet()) {
            listener.onPlayerLoggedOut(event);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        for (IOnEntityDeath listener : entitydeathlisteners.keySet()) {
            listener.onEntityDeath(event);
        }
    }

    static {
        entitydeathlisteners = new MapMaker().weakKeys().weakValues().makeMap();
        dimchangelisteners = new MapMaker().weakKeys().weakValues().makeMap();
        loggedinlisteners = new MapMaker().weakKeys().weakValues().makeMap();
        loggedoutlisteners = new MapMaker().weakKeys().weakValues().makeMap();
    }

    public static interface IOnPlayerLoggedOut {
        public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent var1);
    }

    public static interface IOnPlayerLoggedIn {
        public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent var1);
    }

    public static interface IOnPlayerChangedDimension {
        public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent var1);
    }

    public static interface IOnEntityDeath {
        public void onEntityDeath(LivingDeathEvent var1);
    }
}

