/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.imc;

import com.xcompwiz.mystcraft.data.ModSymbolsFluids;
import com.xcompwiz.mystcraft.imc.IMCHandler;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCBlacklistFluid
implements IMCHandler.IMCProcessor {
    @Override
    public void process(FMLInterModComms.IMCMessage message) {
        Fluid fluid = null;
        IBlockState blockstate = null;
        if (message.isStringMessage()) {
            LoggerUtils.info(String.format("Receiving fluid symbol blacklist request from [%s] for fluid %s", message.getSender(), message.getStringValue()), new Object[0]);
            String fluidname = message.getStringValue();
            if (fluidname != null) {
                fluid = FluidRegistry.getFluid((String)fluidname);
            }
            if (fluid == null) {
                return;
            }
            if (fluid.getBlock() == null) {
                return;
            }
            Block block = fluid.getBlock();
            int meta = 0;
            if (block instanceof BlockFluidBase) {
                meta = (byte)((BlockFluidBase)block).getMaxRenderHeightMeta();
            }
            blockstate = block.func_176203_a(meta);
        }
        if (blockstate == null) {
            return;
        }
        String identifier = SymbolBlock.getSymbolIdentifier(blockstate);
        SymbolManager.blackListSymbol(identifier);
        ModSymbolsFluids.blacklist(fluid);
        LoggerUtils.info("Fluid blacklist request successful.", new Object[0]);
    }
}

