/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.core;

import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.debug.DebugHierarchy;
import com.xcompwiz.mystcraft.debug.DebugUtils;
import com.xcompwiz.mystcraft.effects.EffectCrumble;
import com.xcompwiz.mystcraft.entity.EntityUtils;
import com.xcompwiz.mystcraft.villager.VillagerTradeSystem;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class MystcraftEventHandler {
    @SubscribeEvent
    public void registerOre(OreDictionary.OreRegisterEvent event) {
        if ((event.getName().startsWith("ore") || event.getName().startsWith("gem") || event.getName().startsWith("dust")) && event.getOre().func_77973_b() instanceof ItemBlock) {
            ItemBlock itemblock = (ItemBlock)event.getOre().func_77973_b();
            EffectCrumble.registerMapping(itemblock.field_150939_a, Blocks.field_150348_b.func_176223_P());
        }
    }

    @SubscribeEvent
    public void bucketFix(FillBucketEvent event) {
        RayTraceResult rtr = event.getTarget();
        if (rtr == null || rtr.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos hit = rtr.func_178782_a();
        if (event.getWorld().func_180495_p(hit).func_177230_c().equals(ModBlocks.black_ink)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void entityInteract(PlayerInteractEvent.EntityInteract event) {
        if (VillagerTradeSystem.onVillagerInteraction(event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void bottleFix(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemstack = event.getItemStack();
        if (itemstack.func_190926_b()) {
            return;
        }
        if (!(itemstack.func_77973_b() instanceof ItemGlassBottle)) {
            return;
        }
        RayTraceResult rtr = EntityUtils.getMovingObjectPositionFromPlayer(event.getWorld(), event.getEntityPlayer(), true);
        if (rtr == null || rtr.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos hit = rtr.func_178782_a();
        if (event.getWorld().func_180495_p(hit).func_177230_c().equals(ModBlocks.black_ink)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.FAIL);
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        WorldProvider provider = event.getEntity().field_70170_p.field_73011_w;
        if (provider instanceof WorldProviderMyst && event.getSource().func_76364_f() instanceof EntityPlayer && event.getEntity() instanceof EntityPlayer && !((WorldProviderMyst)provider).isPvPEnabled()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleWorldLoadEvent(WorldEvent.Load event) {
        WorldProvider provider = event.getWorld().field_73011_w;
        if (provider instanceof WorldProviderMyst) {
            ((WorldProviderMyst)provider).setWorldInfo();
            if (event.getWorld().field_72995_K) {
                return;
            }
            DebugHierarchy.DebugNode node = DebugUtils.getDebugNodeForAge(((WorldProviderMyst)provider).agedata);
            ((WorldProviderMyst)provider).getAgeController().registerDebugInfo(node);
        }
    }

    @SubscribeEvent
    public void handleWorldUnloadEvent(WorldEvent.Unload event) {
        WorldProvider provider = event.getWorld().field_73011_w;
        if (provider instanceof WorldProviderMyst) {
            if (event.getWorld().field_72995_K) {
                return;
            }
            DebugHierarchy.DebugNode node = DebugUtils.getDebugNodeForAge(((WorldProviderMyst)provider).agedata);
            node.parent.removeChild(node);
        }
    }
}

