/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.command;

import com.xcompwiz.mystcraft.command.CommandBaseAdv;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class CommandRegenerateChunk
extends CommandBaseAdv {
    public String func_71517_b() {
        return "myst-regenchunk";
    }

    public int func_82362_a() {
        return 4;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "commands.myst.chunkregen.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int x;
        WorldServer worldObj;
        int range = 3;
        Integer dimension = null;
        Integer chunkX = null;
        Integer chunkZ = null;
        if (args.length > 0) {
            range = CommandRegenerateChunk.func_175755_a((String)args[0]);
        }
        if (args.length > 1) {
            dimension = CommandRegenerateChunk.func_175755_a((String)args[1]);
        }
        if (args.length > 2) {
            chunkX = CommandRegenerateChunk.func_175755_a((String)args[2]);
        }
        if (args.length > 3) {
            chunkZ = CommandRegenerateChunk.func_175755_a((String)args[3]);
        }
        EntityPlayerMP caller = CommandRegenerateChunk.func_71521_c((ICommandSender)sender);
        if (dimension == null) {
            dimension = caller.field_71093_bK;
        }
        if (chunkX == null || chunkZ == null) {
            chunkX = (int)caller.field_70165_t >> 4;
            chunkZ = (int)caller.field_70161_v >> 4;
        }
        if ((worldObj = DimensionManager.getWorld((int)dimension)) == null) {
            throw new CommandException("The target world is not loaded", new Object[0]);
        }
        ChunkProviderServer chunkprovider = worldObj.func_72863_F();
        ArrayList players = new ArrayList();
        players.addAll(worldObj.field_73010_i);
        for (int x2 = chunkX - range; x2 <= chunkX + range; ++x2) {
            for (int z = chunkZ - range; z <= chunkZ + range; ++z) {
                for (EntityPlayer player : players) {
                    if (!worldObj.func_184164_w().func_72694_a((EntityPlayerMP)player, x2, z)) continue;
                    player.func_70012_b((double)(chunkX - range - 2 << 4), player.field_70163_u, (double)(chunkZ - range - 2 << 4), 0.0f, 0.0f);
                    worldObj.func_72866_a((Entity)player, false);
                }
                Chunk c = chunkprovider.func_186026_b(x2, z);
                if (c == null) continue;
                chunkprovider.func_189549_a(c);
            }
        }
        int lastloaded = 0;
        while (chunkprovider.func_73152_e() != lastloaded) {
            lastloaded = chunkprovider.func_73152_e();
            chunkprovider.func_73156_b();
        }
        System.out.println(chunkprovider.func_73148_d());
        for (x = chunkX - range; x <= chunkX + range; ++x) {
            for (int z = chunkZ - range; z <= chunkZ + range; ++z) {
                Chunk chunk;
                long i = ChunkPos.func_77272_a((int)x, (int)z);
                try {
                    chunk = chunkprovider.field_186029_c.func_185932_a(x, z);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception generating new chunk");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Chunk to be generated");
                    crashreportcategory.func_71507_a("Location", (Object)String.format("%d,%d", x, z));
                    crashreportcategory.func_71507_a("Position hash", (Object)i);
                    crashreportcategory.func_71507_a("Generator", (Object)chunkprovider.field_186029_c);
                    throw new ReportedException(crashreport);
                }
                chunkprovider.field_73244_f.put(i, (Object)chunk);
                chunk.func_76631_c();
                chunk.func_186030_a((IChunkProvider)chunkprovider, chunkprovider.field_186029_c);
                chunkprovider.func_186028_c(x, z);
            }
        }
        this.sendToAdmins(sender, String.format("%s regenerated chunks (%d, %d)+-%d in Dimension %d", sender.func_70005_c_(), chunkX, chunkZ, range, caller.field_71093_bK), new Object[0]);
        for (x = chunkX - range; x <= chunkX + range; ++x) {
            for (int z = chunkZ - range; z <= chunkZ + range; ++z) {
                Chunk chunk = worldObj.func_72964_e(x, z);
                SPacketChunkData pkt = new SPacketChunkData(chunk, -1);
                this.sendToAllPlayersWatchingChunk(worldObj, chunk.func_76632_l(), (Packet)pkt);
            }
        }
    }

    private void sendToAllPlayersWatchingChunk(WorldServer worldObj, ChunkPos chunkLocation, Packet pkt) {
        List players = worldObj.field_73010_i;
        PlayerChunkMapEntry entry = worldObj.func_184164_w().func_187301_b(chunkLocation.field_77276_a, chunkLocation.field_77275_b);
        if (entry != null) {
            entry.func_187267_a(pkt);
        }
    }
}

