/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.model;

import com.xcompwiz.mystcraft.client.model.ModelBox;
import com.xcompwiz.mystcraft.client.model.ModelElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ModelRendererAdvanced {
    protected float textureWidth = 64.0f;
    protected float textureHeight = 32.0f;
    protected int textureOffsetX;
    protected int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled = false;
    private int displayList = 0;
    public boolean mirror = false;
    public boolean showModel = true;
    public boolean isHidden = false;
    public List<ModelElement> elementList = new ArrayList<ModelElement>();
    public List<ModelRendererAdvanced> childModels;
    public final String modelName;
    protected ModelBase baseModel;

    public ModelRendererAdvanced(ModelBase par1ModelBase, String par2Str) {
        this.baseModel = par1ModelBase;
        this.modelName = par2Str;
        this.setTextureSize(par1ModelBase.field_78090_t, par1ModelBase.field_78089_u);
    }

    public ModelRendererAdvanced(ModelBase par1ModelBase) {
        this(par1ModelBase, null);
    }

    public ModelRendererAdvanced(ModelBase par1ModelBase, int par2, int par3) {
        this(par1ModelBase);
        this.setTextureOffset(par2, par3);
    }

    public void addChild(ModelRendererAdvanced par1ModelRenderer) {
        if (this.childModels == null) {
            this.childModels = new ArrayList<ModelRendererAdvanced>();
        }
        this.childModels.add(par1ModelRenderer);
    }

    public ModelRendererAdvanced setTextureOffset(int par1, int par2) {
        this.textureOffsetX = par1;
        this.textureOffsetY = par2;
        return this;
    }

    public ModelRendererAdvanced addElement(ModelElement element) {
        this.elementList.add(element);
        return this;
    }

    public ModelRendererAdvanced addBox(String name, float x, float y, float z, int width, int height, int depth) {
        name = this.modelName + "." + name;
        TextureOffset textureOffset = this.baseModel.func_78084_a(name);
        this.elementList.add(new ModelBox(this, textureOffset.field_78783_a, textureOffset.field_78782_b, x, y, z, width, height, depth, 0.0f).setName(name));
        return this;
    }

    public ModelRendererAdvanced addBox(float x, float y, float z, int width, int height, int depth) {
        this.elementList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, 0.0f));
        return this;
    }

    public void addBox(float x, float y, float z, int width, int height, int depth, float scalar) {
        this.elementList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, scalar));
    }

    public void setRotationPoint(float par1, float par2, float par3) {
        this.rotationPointX = par1;
        this.rotationPointY = par2;
        this.rotationPointZ = par3;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float par1) {
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(par1);
            }
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                if (this.rotationPointX == 0.0f && this.rotationPointY == 0.0f && this.rotationPointZ == 0.0f) {
                    GL11.glCallList((int)this.displayList);
                    if (this.childModels != null) {
                        for (ModelRendererAdvanced var3 : this.childModels) {
                            var3.render(par1);
                        }
                    }
                } else {
                    GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
                    GL11.glCallList((int)this.displayList);
                    if (this.childModels != null) {
                        for (ModelRendererAdvanced var3 : this.childModels) {
                            var3.render(par1);
                        }
                    }
                    GL11.glTranslatef((float)(-this.rotationPointX * par1), (float)(-this.rotationPointY * par1), (float)(-this.rotationPointZ * par1));
                }
            } else {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GL11.glCallList((int)this.displayList);
                if (this.childModels != null) {
                    for (ModelRendererAdvanced var3 : this.childModels) {
                        var3.render(par1);
                    }
                }
                GL11.glPopMatrix();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderWithRotation(float par1) {
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(par1);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glCallList((int)this.displayList);
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void postRender(float par1) {
        if (!this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(par1);
            }
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
                    GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
                }
            } else {
                GL11.glTranslatef((float)(this.rotationPointX * par1), (float)(this.rotationPointY * par1), (float)(this.rotationPointZ * par1));
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void compileDisplayList(float par1) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator tesselator = Tessellator.func_178181_a();
        VertexBuffer vb = tesselator.func_178180_c();
        for (ModelElement element : this.elementList) {
            element.render(vb, par1);
        }
        GL11.glEndList();
        this.compiled = true;
    }

    public ModelRendererAdvanced setTextureSize(int par1, int par2) {
        this.textureWidth = par1;
        this.textureHeight = par2;
        return this;
    }
}

