/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;

public class GuiElementTextField
extends GuiElement {
    private final FontRenderer fontRenderer;
    private IGuiOnTextChange textchangehandler;
    private IGuiTextProvider textprovider;
    private String id;
    private int cursorCounter;
    private int maxLength = 256;
    private boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private boolean isFocused = false;
    private boolean readonly = false;
    private int lineScrollOffset;
    private int cursorPosition;
    private String override;
    private long lasttyped;
    private int selectionEnd;
    private int enabledColor = -2039584;
    private int disabledColor = -9408400;
    private int borderColor = -6250336;
    private int backgroundColor = -16777216;

    public GuiElementTextField(IGuiTextProvider textprovider, IGuiOnTextChange changehandler, String id, int guiLeft, int guiTop, int xSize, int ySize) {
        super(guiLeft, guiTop, xSize, ySize);
        this.id = id;
        this.fontRenderer = this.mc.field_71466_p;
        this.textprovider = textprovider;
        this.textchangehandler = changehandler;
    }

    public String getId() {
        return this.id;
    }

    public void setCanLoseFocus(boolean b) {
        this.canLoseFocus = b;
    }

    public void setReadOnly(boolean b) {
        this.readonly = b;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setMaxLength(int v) {
        this.maxLength = v;
    }

    @Override
    public void _onTick() {
        ++this.cursorCounter;
    }

    private void setText(String text) {
        if (this.isReadOnly()) {
            return;
        }
        if (text.length() > this.maxLength) {
            text = text.substring(0, this.maxLength);
        }
        this.override = text;
        this.lasttyped = Minecraft.func_71386_F();
        if (this.textchangehandler != null) {
            this.textchangehandler.onTextChange(this, text);
        }
    }

    public String getText() {
        String text = null;
        if (this.override != null) {
            if (this.lasttyped + 1000L > Minecraft.func_71386_F()) {
                text = this.override;
            } else {
                this.override = null;
            }
        }
        if (text == null && this.textprovider != null) {
            text = this.textprovider.getText(this);
        }
        if (text == null) {
            text = "";
        }
        if (this.cursorPosition > text.length()) {
            this.setCursorPosition(text.length());
        }
        return text;
    }

    public String getSelectedtext() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.getText().substring(i, j);
    }

    public void writeText(String par1Str) {
        int l;
        if (this.isReadOnly()) {
            return;
        }
        String s1 = "";
        String s2 = ChatAllowedCharacters.func_71565_a((String)par1Str);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxLength - Math.min(this.getText().length(), this.maxLength) - (i - this.selectionEnd);
        if (this.getText().length() > 0) {
            s1 = s1 + this.getText().substring(0, i);
        }
        if (k < s2.length()) {
            s1 = s1 + s2.substring(0, k);
            l = k;
        } else {
            s1 = s1 + s2;
            l = s2.length();
        }
        if (this.getText().length() > 0 && j < this.getText().length()) {
            s1 = s1 + this.getText().substring(j);
        }
        this.setText(s1);
        this.moveCursorBy(i - this.selectionEnd + l);
    }

    public void deleteWords(int par1) {
        if (this.getText().length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(par1) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int par1) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.getText().length() != 0) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = par1 < 0;
                int j = flag ? this.cursorPosition + par1 : this.cursorPosition;
                int k = flag ? this.cursorPosition : this.cursorPosition + par1;
                String s = "";
                if (j >= 0) {
                    s = this.getText().substring(0, j);
                }
                if (k < this.getText().length()) {
                    s = s + this.getText().substring(k);
                }
                this.setText(s);
                if (flag) {
                    this.moveCursorBy(par1);
                }
            }
        }
    }

    public int getNthWordFromCursor(int par1) {
        return this.getNthWordFromPos(par1, this.getCursorPosition());
    }

    public int getNthWordFromPos(int par1, int par2) {
        return this.func_73798_a(par1, this.getCursorPosition(), true);
    }

    public int func_73798_a(int par1, int par2, boolean par3) {
        int k = par2;
        boolean flag1 = par1 < 0;
        int l = Math.abs(par1);
        for (int i1 = 0; i1 < l; ++i1) {
            if (flag1) {
                while (par3 && k > 0 && this.getText().charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.getText().charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int j1 = this.getText().length();
            k = this.getText().indexOf(32, k);
            if (k == -1) {
                k = j1;
                continue;
            }
            while (par3 && k < j1 && this.getText().charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    public void moveCursorBy(int par1) {
        this.setCursorPosition(this.selectionEnd + par1);
    }

    public void setCursorPosition(int par1) {
        this.cursorPosition = par1;
        int j = this.getText().length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition > j) {
            this.cursorPosition = j;
        }
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.getText().length());
    }

    @Override
    public boolean _onKeyPress(char c, int i) {
        if (this.isEnabled() && this.isFocused) {
            switch (c) {
                case '\u0001': {
                    this.setCursorPositionEnd();
                    this.setSelectionPos(0);
                    return true;
                }
                case '\u0003': {
                    GuiScreen.func_146275_d((String)this.getSelectedtext());
                    return true;
                }
                case '\u0016': {
                    this.writeText(GuiScreen.func_146277_j());
                    return true;
                }
                case '\u0018': {
                    GuiScreen.func_146275_d((String)this.getSelectedtext());
                    this.writeText("");
                    return true;
                }
            }
            switch (i) {
                case 14: {
                    if (GuiScreen.func_146271_m()) {
                        this.deleteWords(-1);
                    } else {
                        this.deleteFromCursor(-1);
                    }
                    return true;
                }
                case 199: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(0);
                    } else {
                        this.setCursorPositionZero();
                    }
                    return true;
                }
                case 203: {
                    if (GuiScreen.func_146272_n()) {
                        if (GuiScreen.func_146271_m()) {
                            this.setSelectionPos(this.getNthWordFromPos(-1, this.getSelectionEnd()));
                        } else {
                            this.setSelectionPos(this.getSelectionEnd() - 1);
                        }
                    } else if (GuiScreen.func_146271_m()) {
                        this.setCursorPosition(this.getNthWordFromCursor(-1));
                    } else {
                        this.moveCursorBy(-1);
                    }
                    return true;
                }
                case 205: {
                    if (GuiScreen.func_146272_n()) {
                        if (GuiScreen.func_146271_m()) {
                            this.setSelectionPos(this.getNthWordFromPos(1, this.getSelectionEnd()));
                        } else {
                            this.setSelectionPos(this.getSelectionEnd() + 1);
                        }
                    } else if (GuiScreen.func_146271_m()) {
                        this.setCursorPosition(this.getNthWordFromCursor(1));
                    } else {
                        this.moveCursorBy(1);
                    }
                    return true;
                }
                case 207: {
                    if (GuiScreen.func_146272_n()) {
                        this.setSelectionPos(this.getText().length());
                    } else {
                        this.setCursorPositionEnd();
                    }
                    return true;
                }
                case 211: {
                    if (GuiScreen.func_146271_m()) {
                        this.deleteWords(1);
                    } else {
                        this.deleteFromCursor(1);
                    }
                    return true;
                }
            }
            if (ChatAllowedCharacters.func_71566_a((char)c)) {
                this.writeText(Character.toString(c));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean _onMouseDown(int mouseX, int mouseY, int button) {
        boolean flag = this.contains(mouseX, mouseY);
        if (this.canLoseFocus) {
            this.setFocused(this.isEnabled() && flag);
        }
        if (this.isFocused && button == 0) {
            int l = mouseX - this.getLeft();
            if (this.getEnableBackgroundDrawing()) {
                l -= 4;
            }
            String s = this.fontRenderer.func_78269_a(this.getText().substring(this.lineScrollOffset), this.getInnerWidth());
            this.setCursorPosition(this.fontRenderer.func_78269_a(s, l).length() + this.lineScrollOffset);
        }
        if (this.isFocused && button == 1) {
            this.setText("");
        }
        return flag;
    }

    @Override
    public void _renderBackground(float f, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        if (this.getEnableBackgroundDrawing()) {
            GuiElementTextField.func_73734_a((int)guiLeft, (int)guiTop, (int)(guiLeft + this.xSize), (int)(guiTop + this.ySize), (int)this.borderColor);
            GuiElementTextField.func_73734_a((int)(guiLeft + 1), (int)(guiTop + 1), (int)(guiLeft + this.xSize - 1), (int)(guiTop + this.ySize - 1), (int)this.backgroundColor);
        }
        int i = this.isEnabled() && !this.isReadOnly() ? this.enabledColor : this.disabledColor;
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = this.fontRenderer.func_78269_a(this.getText().substring(this.lineScrollOffset), this.getInnerWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.isFocused && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = this.getEnableBackgroundDrawing() ? guiLeft + 4 : guiLeft;
        int i1 = this.getEnableBackgroundDrawing() ? guiTop + (this.ySize - 8) / 2 : guiTop;
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        if (s.length() > 0) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = this.fontRenderer.func_175063_a(s1, (float)l, (float)i1, i);
        }
        boolean flag2 = this.cursorPosition < this.getText().length();
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.xSize : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (s.length() > 0 && flag && j < s.length()) {
            this.fontRenderer.func_175063_a(s.substring(j), (float)j1, (float)i1, i);
        }
        if (flag1) {
            if (flag2) {
                Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + this.fontRenderer.field_78288_b), (int)-3092272);
            } else {
                this.fontRenderer.func_175063_a("_", (float)k1, (float)i1, i);
            }
        }
        if (k != j) {
            int l1 = l + this.fontRenderer.func_78256_a(s.substring(0, k));
            this.drawCursorVertical(k1, i1 - 1, l1 - 1, i1 + 1 + this.fontRenderer.field_78288_b);
        }
    }

    private void drawCursorVertical(int par1, int par2, int par3, int par4) {
        int i1;
        if (par1 < par3) {
            i1 = par1;
            par1 = par3;
            par3 = i1;
        }
        if (par2 < par4) {
            i1 = par2;
            par2 = par4;
            par4 = i1;
        }
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        vb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vb.func_181662_b((double)par1, (double)par4, 0.0).func_181675_d();
        vb.func_181662_b((double)par3, (double)par4, 0.0).func_181675_d();
        vb.func_181662_b((double)par3, (double)par2, 0.0).func_181675_d();
        vb.func_181662_b((double)par1, (double)par2, 0.0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public void setEnableBackgroundDrawing(boolean flag) {
        this.enableBackgroundDrawing = flag;
    }

    public void setTextColor(int color) {
        this.enabledColor = color;
    }

    public void setDisabledTextColor(int color) {
        this.disabledColor = color;
    }

    public void setBorderColor(int color) {
        this.borderColor = color;
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
    }

    public void setFocused(boolean par1) {
        if (par1 && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = par1;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getInnerWidth() {
        return this.getEnableBackgroundDrawing() ? this.xSize - 8 : this.xSize;
    }

    public void setSelectionPos(int par1) {
        int j = this.getText().length();
        if (par1 > j) {
            par1 = j;
        }
        if (par1 < 0) {
            par1 = 0;
        }
        this.selectionEnd = par1;
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > j) {
                this.lineScrollOffset = j;
            }
            int k = this.getInnerWidth();
            String s = this.fontRenderer.func_78269_a(this.getText().substring(this.lineScrollOffset), k);
            int l = s.length() + this.lineScrollOffset;
            if (par1 == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.func_78262_a(this.getText(), k, true).length();
            }
            if (par1 > l) {
                this.lineScrollOffset += par1 - l;
            } else if (par1 <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - par1;
            }
            if (this.lineScrollOffset < 0) {
                this.lineScrollOffset = 0;
            }
            if (this.lineScrollOffset > j) {
                this.lineScrollOffset = j;
            }
        }
    }

    public static interface IGuiTextProvider {
        @Nullable
        public String getText(GuiElementTextField var1);
    }

    public static interface IGuiOnTextChange {
        public void onTextChange(GuiElementTextField var1, String var2);
    }
}

