/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.api.client.ILinkPanelEffect;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.client.linkeffects.LinkPanelEffectManager;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.inventory.IBookContainer;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElementBook
extends GuiElement {
    private IBookContainer bookcontainer;
    private IGuiOnLinkHandler linkhandler;
    private List<String> hovertext = new ArrayList<String>();
    private float xScale;
    private float yScale;

    public GuiElementBook(IBookContainer container, IGuiOnLinkHandler linkhandler, int left, int top, int width, int height) {
        super(left, top, width, height);
        this.bookcontainer = container;
        this.linkhandler = linkhandler;
        this.xScale = (float)this.xSize / 327.0f;
        this.yScale = (float)this.ySize / 199.0f;
        this.bookcontainer.setCurrentPageIndex(0);
        Collection<ILinkPanelEffect> effects = LinkPanelEffectManager.getEffects();
        for (ILinkPanelEffect effect : effects) {
            effect.onOpen();
        }
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.isBook();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.isBook();
    }

    @Override
    public boolean _onMouseDown(int i, int j, int k) {
        if (!this.isEnabled()) {
            return false;
        }
        if (k == 0) {
            int guiLeft = this.getLeft();
            int guiTop = this.getTop();
            if (this.getCurrentPageIndex() == 0 && (float)i >= 173.0f * this.xScale + (float)guiLeft && (float)i <= 305.0f * this.xScale + (float)guiLeft && (float)j >= 20.0f * this.yScale + (float)guiTop && (float)j <= 103.0f * this.yScale + (float)guiTop) {
                this.linkhandler.onLink(this);
                return true;
            }
            if (i >= guiLeft && (float)i <= 156.0f * this.xScale + (float)guiLeft && j >= guiTop && (float)j <= 195.0f * this.yScale + (float)guiTop) {
                this.pageLeft();
                return true;
            }
            if ((float)i >= 158.0f * this.xScale + (float)guiLeft && (float)i <= 312.0f * this.xScale + (float)guiLeft && j >= guiTop && (float)j <= 195.0f * this.yScale + (float)guiTop) {
                this.pageRight();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean _onKeyPress(char c, int i) {
        if (!this.isEnabled()) {
            return false;
        }
        if (i == 203 || i == this.mc.field_71474_y.field_74370_x.func_151463_i()) {
            this.pageLeft();
            return true;
        }
        if (i == 205 || i == this.mc.field_71474_y.field_74366_z.func_151463_i()) {
            this.pageRight();
            return true;
        }
        return false;
    }

    @Override
    public List<String> _getTooltipInfo() {
        if (this.hovertext.size() > 0) {
            return this.hovertext;
        }
        return null;
    }

    @Override
    public void _renderBackground(float f, int mouseX, int mouseY) {
        int y;
        ItemStack page;
        if (!this.isVisible()) {
            return;
        }
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)guiLeft, (float)guiTop, (float)0.0f);
        GlStateManager.func_179152_a((float)this.xScale, (float)this.yScale, (float)1.0f);
        this.hovertext.clear();
        this.mc.field_71446_o.func_110577_a(Assets.GUIs.book_cover);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(0, 7, 152, 0, 34, 192);
        this.func_73729_b(34, 7, 49, 0, 103, 192);
        this.func_73729_b(137, 7, 45, 0, 4, 192);
        this.func_73729_b(141, 7, 0, 0, 186, 192);
        if (this.isAgebook()) {
            this.func_73729_b(0, 7, 186, 0, 34, 192);
            this.func_73729_b(293, 7, 186, 0, 34, 192);
        }
        if (this.getCurrentPageIndex() > 0) {
            this.mc.field_71446_o.func_110577_a(Assets.GUIs.book_page_left);
            this.func_73729_b(7, 0, 0, 0, 156, 195);
        }
        if (!(page = this.bookcontainer.getCurrentPage()).func_190926_b() && Page.isLinkPanel(page)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)173.0f, (float)20.0f, (float)0.0f);
            this.drawLinkPanel(0, 0, 132, 83);
            this.drawLinkPanelOverlays(132, 83);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(Assets.GUIs.book_page_right);
            this.func_73729_b(163, 0, 0, 0, 156, 195);
        } else if (!page.func_190926_b()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(Assets.GUIs.book_page_right_solid);
            this.func_73729_b(163, 0, 0, 0, 156, 195);
            if (Page.getSymbol(page) != null) {
                int x = 171;
                y = 25;
                int scale = 140;
                IAgeSymbol symbol2 = SymbolManager.getAgeSymbol(Page.getSymbol(page));
                GuiUtils.drawSymbol(this.mc.field_71446_o, this.getZLevel(), symbol2, scale, x, y);
                if (GuiUtils.contains(mouseX, mouseY, (int)((float)x * this.xScale) + guiLeft, (int)((float)y * this.yScale) + guiTop, (int)((float)scale * this.xScale), (int)((float)scale * this.yScale))) {
                    this.hovertext.add(GuiUtils.getHoverText(symbol2));
                }
            }
        }
        GlStateManager.func_179097_i();
        if (this.getCurrentPageIndex() == 0) {
            if (this.isSlotVisible()) {
                this.func_73729_b(40, 20, 156, 0, 18, 18);
            }
            Collection<String> authors = this.bookcontainer.getBookAuthors();
            this.mc.field_71466_p.func_78276_b(this.bookcontainer.getBookTitle(), 40, 40, 0);
            y = 50;
            if (authors != null) {
                for (String author : authors) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)50.0f, (float)y, (float)0.0f);
                    GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
                    this.mc.field_71466_p.func_78276_b(author, 0, 0, 0);
                    GlStateManager.func_179121_F();
                    y += 5;
                }
            }
        }
        String s = "" + this.getCurrentPageIndex() + "/" + this.bookcontainer.getPageCount();
        int j = this.mc.field_71466_p.func_78256_a(s) / 2;
        this.mc.field_71466_p.func_78276_b(s, 165 - j, 185, 0);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    private void drawLinkPanel(int x, int y, int width, int height) {
        if (this.bookcontainer.isTargetWorldVisited()) {
            this.func_73733_a(x, y, width, height, -16777148, -16751002);
        } else {
            this.func_73733_a(x, y, width, height, -16777216, -16777216);
        }
    }

    private void drawLinkPanelOverlays(int width, int height) {
        ILinkInfo linkinfo = this.bookcontainer.getLinkInfo();
        ItemStack bookclone = this.bookcontainer.getBook();
        bookclone = bookclone.func_77946_l();
        if (linkinfo != null) {
            Collection<ILinkPanelEffect> effects = LinkPanelEffectManager.getEffects();
            for (ILinkPanelEffect effect : effects) {
                effect.render(0, 0, width, height, linkinfo, bookclone);
            }
        }
        if (!this.bookcontainer.isLinkPermitted()) {
            this.func_73733_a(0, 0, width, height, -1148680056, -1148680056);
        }
    }

    private void pageLeft() {
        int currentpage = this.getCurrentPageIndex() - 1;
        if (currentpage < 0) {
            currentpage = 0;
        }
        this.bookcontainer.setCurrentPageIndex(currentpage);
    }

    private void pageRight() {
        int currentpage = this.getCurrentPageIndex() + 1;
        if (currentpage > this.bookcontainer.getPageCount()) {
            currentpage = this.bookcontainer.getPageCount();
        }
        this.bookcontainer.setCurrentPageIndex(currentpage);
    }

    private int getCurrentPageIndex() {
        return this.bookcontainer.getCurrentPageIndex();
    }

    private boolean isSlotVisible() {
        return this.bookcontainer.hasBookSlot();
    }

    private boolean isBook() {
        return !this.bookcontainer.getBook().func_190926_b();
    }

    private boolean isAgebook() {
        ItemStack book = this.bookcontainer.getBook();
        if (book.func_190926_b()) {
            return false;
        }
        if (!book.func_77942_o()) {
            return false;
        }
        return book.func_77973_b() == ModItems.agebook;
    }

    public static interface IGuiOnLinkHandler {
        public void onLink(GuiElement var1);
    }
}

