/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui;

import com.xcompwiz.mystcraft.client.gui.GuiContainerElements;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementButton;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementButtonToggle;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementTextField;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.inventory.ContainerLinkModifier;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketGuiMessage;
import com.xcompwiz.mystcraft.tileentity.TileEntityLinkModifier;
import com.xcompwiz.util.CollectionUtils;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiLinkModifier
extends GuiContainerElements {
    private ContainerLinkModifier container;
    private GuiElementTextField txt_seed;

    public GuiLinkModifier(InventoryPlayer inventoryplayer, TileEntityLinkModifier tileentity) {
        super(new ContainerLinkModifier(inventoryplayer, tileentity));
        this.container = (ContainerLinkModifier)this.field_147002_h;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.txt_seed != null) {
            this.txt_seed.setVisible(this.container.hasItemSeed());
        }
    }

    @Override
    public void validate() {
        TextBoxHandler txtbxhdnlr = new TextBoxHandler();
        this.txt_seed = new GuiElementTextField(txtbxhdnlr, txtbxhdnlr, "Seed", 80, 15, this.field_146999_f - 80 - 9, 14);
        this.txt_seed.setMaxLength(21);
        this.addElement(this.txt_seed);
        GuiElementTextField txt_box = new GuiElementTextField(txtbxhdnlr, txtbxhdnlr, "ItemName", 80, 56, this.field_146999_f - 80 - 9, 14);
        txt_box.setMaxLength(21);
        this.addElement(txt_box);
        ButtonHandler buttonhandler = new ButtonHandler();
        int x = 5;
        int y = 10;
        int scale = 18;
        for (String prop : InkEffects.getProperties()) {
            this.addElement(this.createButton(buttonhandler, prop, CollectionUtils.buildList(InkEffects.getLocalizedName(prop)), x, y, scale));
            if ((y += scale + 2) < 60) continue;
            y = 10;
            x += scale + 2;
        }
    }

    private <T extends GuiElementButton.IGuiOnClickHandler & GuiElementButtonToggle.IGuiStateProvider> GuiElement createButton(T buttonhandler, String id, List<String> tooltip, int x, int y, int size) {
        GuiElementButtonToggle button = new GuiElementButtonToggle(buttonhandler, buttonhandler, id, x, y, size, size);
        button.setTooltip(tooltip);
        return button;
    }

    @Override
    protected void _drawBackgroundLayer(int mouseX, int mouseY, float f) {
        this.field_146297_k.field_71446_o.func_110577_a(Assets.GUIs.single_slot);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146289_q.func_175063_a(this.container.getLinkDimensionUID(), (float)(this.field_147003_i + 100), (float)(this.field_147009_r + 40), 0xFFFFFF);
    }

    public class TextBoxHandler
    implements GuiElementTextField.IGuiTextProvider,
    GuiElementTextField.IGuiOnTextChange {
        @Override
        public String getText(GuiElementTextField caller) {
            if (caller.getId().equals("ItemName")) {
                return GuiLinkModifier.this.container.getBookTitle();
            }
            if (caller.getId().equals("Seed")) {
                return GuiLinkModifier.this.container.getItemSeed();
            }
            return "Huh?";
        }

        @Override
        public void onTextChange(GuiElementTextField caller, String text) {
            NBTTagCompound nbttagcompound;
            if (caller.getId().equals("ItemName")) {
                nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74778_a("SetTitle", text);
                MystcraftPacketHandler.CHANNEL.sendToServer((IMessage)new MPacketGuiMessage(((GuiLinkModifier)GuiLinkModifier.this).container.field_75152_c, nbttagcompound));
                GuiLinkModifier.this.container.processMessage((EntityPlayer)GuiLinkModifier.this.field_146297_k.field_71439_g, nbttagcompound);
            }
            if (caller.getId().equals("Seed")) {
                nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74778_a("SetSeed", text);
                MystcraftPacketHandler.CHANNEL.sendToServer((IMessage)new MPacketGuiMessage(((GuiLinkModifier)GuiLinkModifier.this).container.field_75152_c, nbttagcompound));
                GuiLinkModifier.this.container.processMessage((EntityPlayer)GuiLinkModifier.this.field_146297_k.field_71439_g, nbttagcompound);
            }
        }
    }

    private class ButtonHandler
    implements GuiElementButton.IGuiOnClickHandler,
    GuiElementButtonToggle.IGuiStateProvider {
        private ButtonHandler() {
        }

        @Override
        public boolean getState(String id) {
            return GuiLinkModifier.this.container.getLinkFlag(id);
        }

        @Override
        public void onClick(GuiElementButton guiElementButton) {
            String id = guiElementButton.getId();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74778_a("SetFlag", id);
            nbttagcompound.func_74757_a("Value", !this.getState(id));
            MystcraftPacketHandler.CHANNEL.sendToServer((IMessage)new MPacketGuiMessage(GuiLinkModifier.this.field_146297_k.field_71439_g.field_71070_bA.field_75152_c, nbttagcompound));
            GuiLinkModifier.this.container.processMessage((EntityPlayer)GuiLinkModifier.this.field_146297_k.field_71439_g, nbttagcompound);
        }
    }
}

