/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client;

import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.client.entityfx.ParticleProviderLink;
import com.xcompwiz.mystcraft.client.entityfx.ParticleUtils;
import com.xcompwiz.mystcraft.client.gui.overlay.GuiNotification;
import com.xcompwiz.mystcraft.client.linkeffects.LinkRendererDisarm;
import com.xcompwiz.mystcraft.client.model.ModelInkMixer;
import com.xcompwiz.mystcraft.client.render.PageBuilder;
import com.xcompwiz.mystcraft.client.render.RenderBookReceptacle;
import com.xcompwiz.mystcraft.client.render.RenderBookstand;
import com.xcompwiz.mystcraft.client.render.RenderFallingBlock;
import com.xcompwiz.mystcraft.client.render.RenderLectern;
import com.xcompwiz.mystcraft.client.render.RenderLightningBoltAdv;
import com.xcompwiz.mystcraft.client.render.RenderLinkbook;
import com.xcompwiz.mystcraft.client.render.RenderMeteor;
import com.xcompwiz.mystcraft.client.render.RenderModel;
import com.xcompwiz.mystcraft.client.render.RenderStarFissure;
import com.xcompwiz.mystcraft.client.render.RenderWritingDesk;
import com.xcompwiz.mystcraft.client.shaders.ShaderUtils;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.data.ModFluids;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.data.ModLinkEffects;
import com.xcompwiz.mystcraft.data.ModPageCollections;
import com.xcompwiz.mystcraft.entity.EntityFallingBlock;
import com.xcompwiz.mystcraft.entity.EntityLightningBoltAdv;
import com.xcompwiz.mystcraft.entity.EntityLinkbook;
import com.xcompwiz.mystcraft.entity.EntityMeteor;
import com.xcompwiz.mystcraft.error.MystcraftStartupChecker;
import com.xcompwiz.mystcraft.inventory.CreativeTabMyst;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookReceptacle;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookstand;
import com.xcompwiz.mystcraft.tileentity.TileEntityDesk;
import com.xcompwiz.mystcraft.tileentity.TileEntityInkMixer;
import com.xcompwiz.mystcraft.tileentity.TileEntityLectern;
import com.xcompwiz.mystcraft.tileentity.TileEntityStarFissure;
import com.xcompwiz.mystcraft.world.profiling.InstabilityDataCalculator;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MystcraftClientProxy
extends MystcraftCommonProxy {
    private MystcraftStartupChecker startupchecker;

    @Override
    public boolean isClientSideAvailable() {
        return true;
    }

    @Override
    public Entity getEntityByID(World worldObj, int id) {
        if (worldObj instanceof WorldClient) {
            return worldObj.func_73045_a(id);
        }
        return super.getEntityByID(worldObj, id);
    }

    public GuiNotification getNotificationGui() {
        return this.startupchecker.getNotificationGui();
    }

    @Override
    public void preinit() {
        OBJLoader.INSTANCE.addDomain("mystcraft");
        this.startupchecker = new MystcraftStartupChecker();
        MinecraftForge.EVENT_BUS.register((Object)this.startupchecker);
        ModFluids.registerModels();
        this.registerEntityRenderers();
    }

    @Override
    public void init() {
        ModBlocks.registerModels();
        ModItems.registerModels();
        this.registerTileEntityRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new PageBuilder());
        InternalAPI.render.registerRenderEffect(new LinkRendererDisarm());
        ParticleUtils.registerParticle("link", new ParticleProviderLink());
    }

    private void registerEntityRenderers() {
        LoggerUtils.info("Adding Entity Renderers", new Object[0]);
        RenderingRegistry.registerEntityRenderingHandler(EntityFallingBlock.class, (IRenderFactory)new RenderFallingBlock.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningBoltAdv.class, (IRenderFactory)new RenderLightningBoltAdv.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityLinkbook.class, (IRenderFactory)new RenderLinkbook.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityMeteor.class, (IRenderFactory)new RenderMeteor.Factory());
    }

    private void registerTileEntityRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDesk.class, (TileEntitySpecialRenderer)new RenderWritingDesk());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStarFissure.class, (TileEntitySpecialRenderer)new RenderStarFissure());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBookReceptacle.class, (TileEntitySpecialRenderer)new RenderBookReceptacle());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityInkMixer.class, new RenderModel(new ModelInkMixer(), Assets.Entities.inkmixer));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBookstand.class, (TileEntitySpecialRenderer)new RenderBookstand());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLectern.class, (TileEntitySpecialRenderer)new RenderLectern());
    }

    @Override
    public void initShaders() {
        ShaderUtils.registerShaders();
    }

    @Override
    public void spawnParticle(String particle, double x, double y, double z, double motionX, double motionY, double motionZ) {
        ParticleUtils.spawnParticle(particle, x, y, z, motionX, motionY, motionZ);
    }

    @Override
    public void createCreativeTabs() {
        CreativeTabMyst creativeTab = new CreativeTabMyst("mystcraft.common", true);
        creativeTab.registerItemStack(new ItemStack((Item)ModItems.agebook, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.unlinked, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.folder, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.portfolio, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.booster, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.desk, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.desk, 1, 1));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.bookstand, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.lectern, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.crystal, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.receptacle, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.inkmixer, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.bookbinder, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.linkmodifier, 1, 0));
        creativeTab.registerItemStack(new ItemStack((Item)ModItems.inkvial, 1, 0));
        CreativeTabMyst pageTab = new CreativeTabMyst("mystcraft.pages");
        pageTab.setHasSearchBar(true);
        pageTab.registerItemStack(Page.createLinkPage());
        ArrayList<String> linkproperties = new ArrayList<String>();
        linkproperties.addAll(InkEffects.getProperties());
        Collections.sort(linkproperties);
        for (String property : linkproperties) {
            if (property.equals("Relative")) continue;
            ModLinkEffects.isPropertyAllowed(property);
            pageTab.registerItemStack(Page.createLinkPage(property));
        }
        ModPageCollections.addSymbolPages(pageTab);
    }

    @Override
    public void startBaselineProfiling(MinecraftServer mcserver) {
        if (InstabilityDataCalculator.isPerSave()) {
            super.startBaselineProfiling(mcserver);
        }
    }

    @Override
    public void stopBaselineProfiling() {
        if (InstabilityDataCalculator.isPerSave()) {
            super.stopBaselineProfiling();
        }
    }
}

