/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.api.impl.item;

import com.xcompwiz.mystcraft.api.item.IItemPageCollection;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.page.SortingUtils;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class ItemFactoryImpl {
    public ItemStack buildPage() {
        return Page.createPage();
    }

    public ItemStack buildSymbolPage(String identifier) {
        return Page.createSymbolPage(identifier);
    }

    public ItemStack buildLinkPage(String ... properties) {
        ItemStack page = Page.createPage();
        Page.makeLinkPanel(page);
        for (String property : properties) {
            Page.addLinkProperty(page, property);
        }
        return page;
    }

    @Nonnull
    public ItemStack buildCollectionItem(String name, String ... tokens) {
        HashSet<GrammarGenerator.Rule> rules = new HashSet<GrammarGenerator.Rule>();
        for (String token : tokens) {
            List<GrammarGenerator.Rule> tokenrules;
            if (token == null || (tokenrules = GrammarGenerator.getAllRules(token)) == null) continue;
            rules.addAll(tokenrules);
        }
        HashSet<IAgeSymbol> symbolsset = new HashSet<IAgeSymbol>();
        for (GrammarGenerator.Rule rule : rules) {
            for (String token : rule.getValues()) {
                IAgeSymbol symbol2;
                if (!SymbolManager.hasBinding(token) || (symbol2 = SymbolManager.getAgeSymbol(token)) == null) continue;
                symbolsset.add(symbol2);
            }
        }
        ArrayList<IAgeSymbol> symbols = new ArrayList<IAgeSymbol>();
        symbols.addAll(symbolsset);
        Collections.sort(symbols, SortingUtils.ComparatorSymbolAlphabetical.instance);
        ItemStack itemstack = new ItemStack(ModItems.portfolio, 1, 0);
        IItemPageCollection item = (IItemPageCollection)itemstack.func_77973_b();
        item.setDisplayName(null, itemstack, name);
        for (IAgeSymbol symbol2 : symbols) {
            item.addPage(null, itemstack, Page.createSymbolPage(symbol2.identifier()));
        }
        return itemstack;
    }

    public ItemStack buildCollectionItem(String name, ItemStack ... pages) {
        ItemStack itemstack = new ItemStack(ModItems.portfolio, 1, 0);
        IItemPageCollection item = (IItemPageCollection)itemstack.func_77973_b();
        item.setDisplayName(null, itemstack, name);
        for (ItemStack page : pages) {
            if (page.func_190926_b() || !(page.func_77973_b() instanceof ItemPage)) continue;
            item.addPage(null, itemstack, page.func_77946_l());
        }
        return itemstack;
    }
}

