/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.profiling;

import com.mojang.authlib.GameProfile;
import com.xcompwiz.mystcraft.api.event.LinkEvent;
import com.xcompwiz.mystcraft.config.MystConfig;
import com.xcompwiz.mystcraft.debug.DebugHierarchy;
import com.xcompwiz.mystcraft.debug.DefaultValueCallback;
import com.xcompwiz.mystcraft.instability.InstabilityBlockManager;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketProfilingState;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfiler;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfilerManager;
import com.xcompwiz.mystcraft.world.profiling.IMystcraftProfilingCallback;
import com.xcompwiz.mystcraft.world.profiling.WorldProviderMystDummy;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InstabilityDataCalculator {
    private static final String StorageID = "myst_baseline";
    private static MystConfig balanceconfig;
    private static boolean persave;
    private static boolean disconnectclients;
    private static boolean useconfigs;
    private static int tickrate;
    private static int minimumchunks;
    private static float tolerance;
    private MinecraftServer mcserver;
    private MapStorage storage;
    private HashMap<String, Number> freevals;
    private static Map<String, Number> defaults;
    private Integer providerId = null;
    private DimensionType dimensionType = null;
    private Integer dimId = null;
    private World world = null;
    private boolean running = false;
    private int tickAccumulator;
    private IMystcraftProfilingCallback callback;

    public static void loadConfigs(Configuration config) {
        minimumchunks = 0;
        tolerance = 1.05f;
        persave = config.get("baselining", "client.persave", persave, "If false, the profiling will run on game startup with the loading bar. If true, it will run in the background when playing. Setting this to false disables tickrate checking, even on the server.").getBoolean(persave);
        useconfigs = config.get("baselining", "useconfigs", useconfigs, "If true, the baseline calculations won't run and instead a config file will be read.").getBoolean(useconfigs);
        disconnectclients = config.get("baselining", "server.disconnectclients", disconnectclients, "If set to true this will prevent clients from connecting while baseline profiling is ongoing (Only works on dedicated servers)").getBoolean(disconnectclients);
        tickrate = config.get("baselining", "tickrate.minimum", tickrate, "This controls the minimum number of ticks to wait before a new chunk will be generated when doing the baseline profiling in the background.").getInt(tickrate);
        if (!persave) {
            tickrate = 1;
        }
    }

    public static void loadBalanceData() {
        if (useconfigs) {
            InstabilityDataCalculator.setBaselineDefaults();
            InstabilityDataCalculator.loadBaselineFromConfig(balanceconfig);
        }
    }

    private static void setBaselineDefaults() {
        defaults = new HashMap<String, Number>();
        defaults.put("tile.lightgem", 0);
        defaults.put("tile.netherquartz", 0);
        defaults.put("tile.oreCoal", 300);
        defaults.put("tile.oreIron", 500);
        defaults.put("tile.oreGold", 500);
        defaults.put("tile.oreLapis", 100);
        defaults.put("tile.oreEmerald", 100);
        defaults.put("tile.oreRedstone", 600);
        defaults.put("tile.oreDiamond", 1000);
        defaults.put("tile.myst_crystal", 0);
        defaults.put("tile.myst_fluid_myst_ink_black", 0);
    }

    private static void loadBaselineFromConfig(Configuration config) {
        Collection<String> keyset = InstabilityBlockManager.getWatchedBlocks();
        HashMap<String, Float> freevals = new HashMap<String, Float>();
        for (String key : keyset) {
            int def = InstabilityDataCalculator.getBaselineVanillaDefault(key);
            float val = config.get("baselining", key, def).getInt(def);
            freevals.put(key, Float.valueOf(val));
        }
        InstabilityBlockManager.setBaselineStability(freevals);
        if (config != null && config.hasChanged()) {
            config.save();
        }
    }

    private static int getBaselineVanillaDefault(String key) {
        Number def = defaults.get(key);
        if (def == null) {
            return 0;
        }
        return def.intValue();
    }

    public static boolean isPerSave() {
        return persave;
    }

    public static boolean isDisabled() {
        return useconfigs;
    }

    public static DebugHierarchy.DebugNode getDebugNode() {
        DebugHierarchy.DebugNode current = DebugHierarchy.root;
        current = current.getOrCreateNode("data");
        current = current.getOrCreateNode("instability_calc");
        return current;
    }

    public InstabilityDataCalculator(MinecraftServer mcserver, MapStorage storage) {
        this.mcserver = mcserver;
        this.storage = storage;
        final ChunkProfiler profiler = InstabilityDataCalculator.getChunkProfiler(storage);
        DebugHierarchy.DebugNode node = InstabilityDataCalculator.getDebugNode();
        node.addChild("profiled_chunks", new DefaultValueCallback(){

            @Override
            public String get(ICommandSender agent) {
                return "" + profiler.getCount();
            }
        });
        this.registerDebugInfo(node.getOrCreateNode("freevals"));
        profiler.registerDebugInfo(node.getOrCreateNode("profiled"));
    }

    private void registerDebugInfo(DebugHierarchy.DebugNode node) {
        for (String blockkey : InstabilityBlockManager.getWatchedBlocks()) {
            node.addChild(blockkey.replaceAll("\\.", "_"), (new DefaultValueCallback(){
                private InstabilityDataCalculator calculator;
                private String blockkey;

                @Override
                public String get(ICommandSender agent) {
                    HashMap split = this.calculator.freevals;
                    if (split == null) {
                        return "N/A";
                    }
                    Number val = (Number)split.get(this.blockkey);
                    if (val == null) {
                        return "None";
                    }
                    return "" + val;
                }

                private DefaultValueCallback init(InstabilityDataCalculator calculator, String blockkey) {
                    this.calculator = calculator;
                    this.blockkey = blockkey;
                    return this;
                }
            }).init(this, blockkey));
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (this.mcserver == null) {
            return;
        }
        ChunkProfiler profiler = InstabilityDataCalculator.getChunkProfiler(this.storage);
        int chunksremaining = InstabilityDataCalculator.getChunksRemaining(profiler);
        if (this.callback != null) {
            this.callback.setCompleted(profiler.getCount());
        }
        if (this.callback != null) {
            this.callback.setRemaining(chunksremaining);
        }
        if (this.callback != null) {
            this.callback.setQueued(ChunkProfilerManager.getSize());
        }
        if (++this.tickAccumulator < tickrate) {
            return;
        }
        this.tickAccumulator = 0;
        if (chunksremaining > 0) {
            if (ChunkProfilerManager.getSize() < chunksremaining) {
                this.stepChunkGeneration(profiler);
            }
        } else {
            if (this.world != null) {
                LoggerUtils.info("Baseline Profiling for Instability completed.", new Object[0]);
            }
            this.cleanup();
            this.freevals = InstabilityDataCalculator.updateInstabilityData(profiler);
            this.mcserver = null;
            if (this.callback != null) {
                this.callback.onFinished();
            }
        }
    }

    public static HashMap<String, Number> updateInstabilityData(ChunkProfiler profiler) {
        HashMap<String, Float> generated = profiler.calculateSplitInstability();
        HashMap<String, Number> freevals = new HashMap<String, Number>();
        for (String key : generated.keySet()) {
            float val = generated.get(key).floatValue();
            val *= tolerance;
            val = (float)(Math.ceil(val / 100.0f) * 100.0);
            freevals.put(key, Float.valueOf(val));
        }
        InstabilityBlockManager.setBaselineStability(freevals);
        return freevals;
    }

    public static int getChunksRemaining(ChunkProfiler profiler) {
        if (minimumchunks == 0) {
            int factor = (int)Math.ceil(500.0 / (double)WorldProviderMystDummy.getAndPrepareBiomeList().size());
            if (factor < 10) {
                factor = 10;
            }
            minimumchunks = WorldProviderMystDummy.getAndPrepareBiomeList().size() * factor;
        }
        return minimumchunks - profiler.getCount();
    }

    public void shutdown() {
        this.cleanup();
        this.mcserver = null;
        if (persave) {
            InstabilityBlockManager.clearBaselineStability();
        }
        DebugHierarchy.DebugNode node = InstabilityDataCalculator.getDebugNode();
        node.parent.removeChild(node);
    }

    public static ChunkProfiler getChunkProfiler(MapStorage storage) {
        ChunkProfiler chunkprofiler = (ChunkProfiler)storage.func_75742_a(ChunkProfiler.class, StorageID);
        if (chunkprofiler == null) {
            chunkprofiler = new ChunkProfiler(StorageID);
            storage.func_75745_a(StorageID, (WorldSavedData)chunkprofiler);
        }
        return chunkprofiler;
    }

    private void cleanup() {
        if (this.world != null) {
            LoggerUtils.info("Baseline Profiling cleaning up.", new Object[0]);
            this.running = false;
            DimensionManager.unloadWorld((int)this.dimId);
            this.world = null;
            MystcraftPacketHandler.CHANNEL.sendToAll((IMessage)new MPacketProfilingState(false));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (this.dimId == null || event.getWorld().field_73011_w.getDimension() != this.dimId.intValue()) {
            return;
        }
        if (event.getWorld() != this.world) {
            LoggerUtils.error("World with matching dim id to profiling dim unloaded!", new Object[0]);
            return;
        }
        if (this.running) {
            LoggerUtils.info("Baseline Profiling world unloaded before time!", new Object[0]);
            this.world = null;
            return;
        }
        LoggerUtils.info("Baseline Profiling world unloading.", new Object[0]);
        if (this.dimId != null) {
            DimensionManager.unregisterDimension((int)this.dimId);
        }
        this.dimId = null;
        File dir = event.getWorld().func_72860_G().func_75765_b();
        dir = new File(dir, event.getWorld().field_73011_w.getSaveFolder());
        dir.deleteOnExit();
    }

    @SubscribeEvent
    public void isLinkPermitted(LinkEvent.LinkEventAllow event) {
        if (this.dimId != null && this.dimId.equals(event.info.getDimensionUID())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.running) {
            MystcraftPacketHandler.CHANNEL.sendTo((IMessage)new MPacketProfilingState(this.running), (EntityPlayerMP)event.player);
        }
        if (this.dimId != null && event.player.field_71093_bK == this.dimId) {
            DimensionUtils.ejectPlayerFromDimension(event.player);
        }
    }

    @SubscribeEvent
    public void connectionOpened(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        if (this.mcserver != null && disconnectclients && this.mcserver.func_71262_S()) {
            String denymessage = "Mystcraft still needs to finish profiling. Please try again later.";
            try {
                ((NetHandlerPlayServer)event.getHandler()).func_147360_c(denymessage);
                GameProfile gameprofile = ((NetHandlerPlayServer)event.getHandler()).field_147369_b.func_146103_bH();
                LoggerUtils.info("Disconnecting " + this.getIDString(event.getManager(), gameprofile) + ": " + denymessage, new Object[0]);
            }
            catch (Exception exception) {
                LoggerUtils.error("Error whilst disconnecting player", exception);
            }
        }
    }

    public String getIDString(NetworkManager networkmanager, GameProfile gameprofile) {
        return gameprofile != null ? gameprofile.toString() + " (" + networkmanager.func_74430_c().toString() + ")" : String.valueOf(networkmanager.func_74430_c());
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (this.dimId != null && event.toDim == this.dimId) {
            DimensionUtils.ejectPlayerFromDimension(event.player);
        }
    }

    private void stepChunkGeneration(ChunkProfiler profiler) {
        if (this.providerId == null) {
            this.providerId = Integer.MIN_VALUE;
            while (true) {
                try {
                    this.dimensionType = DimensionType.register((String)"Mystcraft_ProfilerDummy", (String)"_mystprof", (int)this.providerId, WorldProviderMystDummy.class, (boolean)false);
                }
                catch (Exception e) {
                    this.providerId = this.providerId + 1;
                    continue;
                }
                break;
            }
            LoggerUtils.info("Baseline Profiling provider registered at %d", this.providerId);
        }
        if (this.dimId == null) {
            this.dimId = Integer.MIN_VALUE;
            while (true) {
                try {
                    DimensionManager.registerDimension((int)this.dimId, (DimensionType)this.dimensionType);
                }
                catch (Exception e) {
                    this.dimId = this.dimId + 1;
                    continue;
                }
                break;
            }
            LoggerUtils.info("Baseline Profiling dimension registered at %d", this.dimId);
        }
        if (this.world == null) {
            this.running = true;
            LoggerUtils.info("Baseline Profiling for Instability started. Expect some lag.", new Object[0]);
            WorldProviderMystDummy.setChunkProfiler(profiler);
            WorldProviderMystDummy.setBounds(profiler.getCount() - 1, minimumchunks + 2, -1, 2);
            this.world = this.mcserver.func_71218_a(this.dimId.intValue());
            if (this.world == null) {
                throw new RuntimeException("Could not create Instability Comparison Dimension");
            }
        }
        ((WorldProviderMystDummy)this.world.field_73011_w).generateNextChunk();
    }

    public void setCallback(IMystcraftProfilingCallback callback) {
        this.callback = callback;
    }

    public static void setBalanceConfig(MystConfig config) {
        balanceconfig = config;
    }

    static {
        persave = true;
        disconnectclients = false;
        useconfigs = false;
        tickrate = 5;
    }
}

