/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.profiling;

import com.xcompwiz.mystcraft.debug.DebugHierarchy;
import com.xcompwiz.mystcraft.debug.DebugUtils;
import com.xcompwiz.mystcraft.debug.DefaultValueCallback;
import com.xcompwiz.mystcraft.instability.InstabilityBlockManager;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfilerManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class ChunkProfiler
extends WorldSavedData {
    public static final String ID = "MystChunkProfile";
    private static final int MAP_LENGTH = 65536;
    private int count = 0;
    private ChunkProfileData solidmap;
    private Map<String, ChunkProfileData> blockmaps;
    private static boolean outputfiles = false;
    private HashMap<String, Float> lastsplitcalc;
    private float[] accessibility = null;
    private float[] averages = null;
    private float[] filtered = null;
    private boolean[] nonzero = null;
    private boolean[] solid = null;
    private float[] rounded = null;
    private float maximum = 0.0f;
    private float minimum = 1.0f;
    private float groundsum = 0.0f;
    private int groundcount = 0;
    private Semaphore semaphore = new Semaphore(1, true);

    public ChunkProfiler(String id) {
        super(id);
        this.solidmap = new ChunkProfileData();
        this.blockmaps = new HashMap<String, ChunkProfileData>();
        for (String blockkey : InstabilityBlockManager.getWatchedBlocks()) {
            this.blockmaps.put(blockkey, new ChunkProfileData());
        }
    }

    public int calculateInstability() {
        if (outputfiles) {
            this.outputFiles();
        }
        if (!InstabilityBlockManager.isBaselineConstructed()) {
            return 0;
        }
        HashMap<String, Float> split = this.calculateSplitInstability();
        float instability = 0.0f;
        for (Map.Entry<String, Float> entry : split.entrySet()) {
            float val = entry.getValue().floatValue();
            if (val > 0.0f) {
                val = Math.max(0.0f, val - (float)InstabilityBlockManager.getBaseline(entry.getKey()));
            }
            instability += val;
        }
        return Math.round(instability);
    }

    public HashMap<String, Float> calculateSplitInstability() {
        int y;
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to acquire semaphore to profile chunk (interrupted)!");
        }
        int layers = this.solidmap.data.length / 256;
        this.maximum = 0.0f;
        this.minimum = 1.0f;
        this.groundsum = 0.0f;
        this.groundcount = 0;
        if (this.accessibility == null || this.accessibility.length < layers) {
            this.accessibility = new float[layers];
        }
        if (this.averages == null || this.averages.length < layers) {
            this.averages = new float[layers];
        }
        if (this.filtered == null || this.filtered.length < layers) {
            this.filtered = new float[layers];
        }
        if (this.rounded == null || this.rounded.length < layers) {
            this.rounded = new float[layers];
        }
        if (this.nonzero == null || this.nonzero.length < layers) {
            this.nonzero = new boolean[layers];
        }
        if (this.solid == null || this.solid.length < layers) {
            this.solid = new boolean[layers];
        }
        for (y = 0; y < layers; ++y) {
            this.averages[y] = 0.0f;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int coords = y << 8 | z << 4 | x;
                    int n = y;
                    this.averages[n] = this.averages[n] + (float)this.solidmap.data[coords] / (float)this.solidmap.count;
                }
            }
            int n = y;
            this.averages[n] = this.averages[n] / 256.0f;
            if (this.minimum > this.averages[y]) {
                this.minimum = this.averages[y];
            }
            if (!(this.maximum < this.averages[y])) continue;
            this.maximum = this.averages[y];
        }
        for (y = 0; y < layers; ++y) {
            this.filtered[y] = this.averages[y] - this.minimum;
            if (this.filtered[y] < 0.0f) {
                this.filtered[y] = 0.0f;
            }
            this.nonzero[y] = this.filtered[y] > 0.0f;
            this.rounded[y] = (float)Math.round(100.0f * this.filtered[y]) / 100.0f;
            if (!(this.rounded[y] > 0.0f)) continue;
            this.groundsum += this.rounded[y];
            ++this.groundcount;
        }
        float ground = this.groundsum / (float)this.groundcount;
        for (int y2 = 0; y2 < layers; ++y2) {
            this.solid[y2] = this.rounded[y2] > ground;
            this.accessibility[y2] = this.solid[y2] ? 1.0f - this.rounded[y2] : 1.0f;
        }
        HashMap<String, Float> split = new HashMap<String, Float>();
        for (int y3 = 0; y3 < layers; ++y3) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int coords = y3 << 8 | z << 4 | x;
                    float availability = this.accessibility[y3];
                    for (String blockkey : InstabilityBlockManager.getWatchedBlocks()) {
                        ChunkProfileData map = this.blockmaps.get(blockkey);
                        if (map.count < 100) continue;
                        float factor1 = InstabilityBlockManager.ro_factor1s.get(blockkey).floatValue();
                        float factor2 = InstabilityBlockManager.ro_factor2s.get(blockkey).floatValue();
                        float val = (float)map.data[coords] / (float)map.count;
                        val = val * availability * factor1 + val * factor2;
                        if (!split.containsKey(blockkey)) {
                            split.put(blockkey, Float.valueOf(0.0f));
                        }
                        split.put(blockkey, Float.valueOf(split.get(blockkey).floatValue() + val));
                    }
                }
            }
        }
        this.lastsplitcalc = split;
        this.semaphore.release();
        return split;
    }

    public void profile(Chunk chunk) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to acquire semaphore to profile chunk (interrupted)!");
        }
        this.profileChunk(chunk, this.solidmap, this.blockmaps);
        ++this.count;
        this.func_76185_a();
        this.semaphore.release();
    }

    private void profileChunk(Chunk chunk, ChunkProfileData soliddata, Map<String, ChunkProfileData> maps) {
        int chunkX = chunk.field_76635_g << 4;
        int chunkZ = chunk.field_76647_h << 4;
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        int[] solidmap = soliddata.data;
        int layers = solidmap.length / 256;
        for (int y = 0; y < layers; ++y) {
            int storagei = y >> 4;
            if (storageArrays[storagei] == null) continue;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    ChunkProfileData map;
                    int accessibility;
                    int coords = y << 8 | z << 4 | x;
                    IBlockState blockstate = storageArrays[storagei].func_177485_a(x, y & 0xF, z);
                    int n = accessibility = blockstate.func_177230_c() != Blocks.field_150350_a ? 2 : 0;
                    if (maps != null && (map = maps.get(InstabilityBlockManager.getStateKey(blockstate))) != null) {
                        int n2 = coords;
                        map.data[n2] = map.data[n2] + 1;
                        accessibility = 1;
                    }
                    BlockPos pos = new BlockPos(chunkX + x, y, chunkZ + z);
                    try {
                        if (blockstate.func_177230_c().func_176205_b((IBlockAccess)chunk.func_177412_p(), pos)) {
                            accessibility = 1;
                        }
                        if (blockstate.func_177230_c().isAir(blockstate, (IBlockAccess)chunk.func_177412_p(), pos)) {
                            accessibility = 0;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int n3 = coords;
                    solidmap[n3] = solidmap[n3] + accessibility;
                }
            }
        }
        soliddata.count += 2;
        if (maps != null) {
            for (Map.Entry<String, ChunkProfileData> entry : maps.entrySet()) {
                ChunkProfileData map = entry.getValue();
                ++map.count;
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        ChunkProfilerManager.ensureSafeSave();
        nbt.func_74782_a("solid", (NBTBase)this.solidmap.writeToNBT(new NBTTagCompound()));
        if (this.blockmaps == null) {
            return nbt;
        }
        for (Map.Entry<String, ChunkProfileData> entry : this.blockmaps.entrySet()) {
            String blockkey = entry.getKey();
            ChunkProfileData map = entry.getValue();
            nbt.func_74782_a(blockkey, (NBTBase)map.writeToNBT(new NBTTagCompound()));
        }
        ChunkProfilerManager.releaseSaveSafe();
        return nbt;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.solidmap.readFromNBT(nbt.func_74775_l("solid"));
        this.count = this.solidmap.count;
        if (nbt.func_74764_b("tile.myst.fluid")) {
            nbt.func_74782_a("tile.myst.fluid.myst.ink.black", nbt.func_74781_a("tile.myst.fluid"));
        }
        if (this.blockmaps == null) {
            return;
        }
        for (String blockkey : this.blockmaps.keySet()) {
            ChunkProfileData map = new ChunkProfileData();
            map.readFromNBT(nbt.func_74775_l(blockkey));
            this.blockmaps.put(blockkey, map);
            if (map.count >= this.count) continue;
            this.count = map.count;
        }
    }

    private void outputFiles() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to acquire semaphore to profile chunk (interrupted)!");
        }
        ChunkProfiler.outputDebug(this.solidmap.data, this.solidmap.count, "logs/profiling/solid2.txt");
        if (this.blockmaps != null) {
            for (Map.Entry<String, ChunkProfileData> entry : this.blockmaps.entrySet()) {
                ChunkProfileData map = entry.getValue();
                String blockkey = entry.getKey();
                ChunkProfiler.outputDebug(map.data, map.count, "logs/profiling/" + blockkey + ".txt");
            }
        }
        this.semaphore.release();
    }

    private static void outputDebug(int[] solidmap, int chunkcount, String filename) {
        File file = new File(Minecraft.func_71410_x().field_71412_D, filename);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdir();
        }
        try {
            String NEW_LINE = System.getProperty("line.separator");
            FileOutputStream fos = new FileOutputStream(file);
            BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            buffer.write(chunkcount + NEW_LINE);
            int layers = solidmap.length / 256;
            for (int y = 0; y < layers; ++y) {
                for (int z = 0; z < 16; ++z) {
                    String line = "";
                    for (int x = 0; x < 16; ++x) {
                        int coords = y << 8 | z << 4 | x;
                        if (line.length() > 0) {
                            line = line + "\t";
                        }
                        line = line + solidmap[coords];
                    }
                    buffer.write(line + NEW_LINE);
                }
                buffer.write(NEW_LINE);
            }
            buffer.write("FIN");
            buffer.write(NEW_LINE);
            buffer.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getCount() {
        return this.count;
    }

    public void clear() {
        try {
            this.semaphore.acquire();
            this.count = 0;
            this.solidmap = new ChunkProfileData();
            this.blockmaps = new HashMap<String, ChunkProfileData>();
            for (String blockkey : InstabilityBlockManager.getWatchedBlocks()) {
                this.blockmaps.put(blockkey, new ChunkProfileData());
            }
            this.func_76185_a();
            this.semaphore.release();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to aquire semaphore to profile chunk!");
        }
    }

    public void registerDebugInfo(DebugHierarchy.DebugNode node) {
        for (String blockkey : InstabilityBlockManager.getWatchedBlocks()) {
            node.addChild(blockkey.replaceAll("\\.", "_"), (new DefaultValueCallback(){
                private ChunkProfiler profiler;
                private String blockkey;

                @Override
                public String get(ICommandSender agent) {
                    HashMap split = this.profiler.lastsplitcalc;
                    if (split == null) {
                        return "N/A";
                    }
                    Float val = (Float)split.get(this.blockkey);
                    if (val == null) {
                        return "None";
                    }
                    return "" + val;
                }

                private DefaultValueCallback init(ChunkProfiler profiler, String blockkey) {
                    this.profiler = profiler;
                    this.blockkey = blockkey;
                    return this;
                }
            }).init(this, blockkey));
        }
    }

    static {
        DebugUtils.register("global.profiler.file_output", new DebugHierarchy.DebugValueCallback(){

            @Override
            public void set(ICommandSender agent, String state) {
                try {
                    if (state.compareToIgnoreCase("0") == 0 || state.compareToIgnoreCase("false") == 0) {
                        outputfiles = false;
                    } else {
                        outputfiles = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public String get(ICommandSender agent) {
                return Boolean.toString(outputfiles);
            }
        });
    }

    public static class ChunkProfileData {
        public int[] data = new int[65536];
        public int count = 0;

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("count", this.count);
            nbt.func_74783_a("data", this.data);
            return nbt;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.count = nbt.func_74762_e("count");
            this.data = nbt.func_74759_k("data");
            if (this.data == null || this.data.length < 65536) {
                this.data = new int[65536];
                this.count = 0;
            }
        }
    }
}

