/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen.structure;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.block.BlockLectern;
import com.xcompwiz.mystcraft.block.BlockWritingDesk;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.tileentity.TileEntityLectern;
import com.xcompwiz.mystcraft.treasure.LootTableHandler;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class ComponentVillageArchivistHouse
extends StructureVillagePieces.Village {
    private int averageGroundLevel = -1;
    private boolean[] lecternGenned = new boolean[2];
    private static final int[][] lecternCoords = new int[][]{{1, 2, 1}, {1, 2, 2}};
    private static final int[][] lecternTargs = new int[][]{{2, 1}, {2, 2}};

    public ComponentVillageArchivistHouse() {
    }

    public ComponentVillageArchivistHouse(StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox box, EnumFacing face) {
        super(start, type);
        this.func_186164_a(face);
        this.field_74887_e = box;
    }

    public static ComponentVillageArchivistHouse buildComponent(StructureVillagePieces.Start start, List<StructureComponent> par1List, Random rand, int x, int y, int z, EnumFacing facing, int par7) {
        StructureBoundingBox var8 = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)12, (int)7, (EnumFacing)facing);
        return ComponentVillageArchivistHouse.func_74895_a((StructureBoundingBox)var8) && StructureComponent.func_74883_a(par1List, (StructureBoundingBox)var8) == null ? new ComponentVillageArchivistHouse(start, par7, rand, var8, facing) : null;
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        for (int i = 0; i < this.lecternGenned.length; ++i) {
            tagCompound.func_74757_a("hasPlacedLectern" + i, this.lecternGenned[i]);
        }
        tagCompound.func_74768_a("YPos", this.averageGroundLevel);
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        super.func_143011_b(tagCompound, p_143011_2_);
        for (int i = 0; i < this.lecternGenned.length; ++i) {
            if (!tagCompound.func_74764_b("hasPlacedLectern" + i)) continue;
            this.lecternGenned[i] = tagCompound.func_74767_n("hasPlacedLectern" + i);
        }
        this.averageGroundLevel = tagCompound.func_74762_e("YPos");
    }

    public boolean func_74875_a(World worldObj, Random rand, StructureBoundingBox boundingbox) {
        int j;
        int i;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(worldObj, boundingbox);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 10, 0);
        }
        this.func_175804_a(worldObj, boundingbox, 1, 1, 1, 8, 6, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 1, 0, 1, 7, 0, 5, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 0, 0, 0, 0, 3, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 0, 0, 0, 7, 3, 0, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 1, 2, 0, 7, 2, 0, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 8, 0, 0, 8, 3, 5, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 8, 2, 1, 8, 2, 5, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 8, 3, 2, 8, 3, 4, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 0, 0, 6, 8, 3, 6, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 0, 6, 3, 8, 6, 3, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 0, 5, 2, 8, 5, 4, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 0, 4, 1, 8, 4, 5, Blocks.field_150344_f.func_176223_P(), Blocks.field_150344_f.func_176223_P(), false);
        this.func_175804_a(worldObj, boundingbox, 2, 4, 2, 6, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        for (i = -1; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_175811_a(worldObj, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), j, 4 + i, i, boundingbox);
                this.func_175811_a(worldObj, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH), j, 4 + i, 6 - i, boundingbox);
            }
        }
        this.func_175811_a(worldObj, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 0, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150410_aZ.func_176223_P(), 3, 2, 0, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 4, boundingbox);
        this.func_189915_a(worldObj, boundingbox, rand, 6, 1, 0, EnumFacing.WEST, Blocks.field_180413_ao);
        if (this.func_175807_a(worldObj, 6, 0, -1, boundingbox).func_177230_c() == Blocks.field_150350_a && this.func_175807_a(worldObj, 6, -1, -1, boundingbox).func_177230_c() != Blocks.field_150350_a) {
            this.func_175811_a(worldObj, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST), 6, 0, -1, boundingbox);
        }
        this.func_189926_a(worldObj, EnumFacing.NORTH, 1, 3, 1, boundingbox);
        this.func_189926_a(worldObj, EnumFacing.NORTH, 6, 4, 2, boundingbox);
        this.func_189926_a(worldObj, EnumFacing.SOUTH, 5, 3, 5, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_180407_aO.func_176223_P(), 6, 1, 4, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150452_aw.func_176223_P(), 6, 2, 4, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 6, 1, 5, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 7, 1, 5, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST), 7, 1, 4, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150344_f.func_176223_P(), 1, 1, 1, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150344_f.func_176223_P(), 1, 1, 2, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150342_X.func_176223_P(), 1, 1, 3, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150342_X.func_176223_P(), 1, 2, 3, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150342_X.func_176223_P(), 1, 1, 4, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150342_X.func_176223_P(), 1, 2, 4, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150344_f.func_176223_P(), 1, 1, 5, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150344_f.func_176223_P(), 1, 2, 5, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150342_X.func_176223_P(), 2, 1, 5, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150342_X.func_176223_P(), 2, 2, 5, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150342_X.func_176223_P(), 3, 1, 5, boundingbox);
        this.func_175811_a(worldObj, Blocks.field_150342_X.func_176223_P(), 3, 2, 5, boundingbox);
        if (Mystcraft.villageDeskGen) {
            this.placeDeskAt(worldObj, 4, 1, 1, 4, 2, boundingbox);
        }
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_74871_b(worldObj, j, 7, i, boundingbox);
                this.func_175808_b(worldObj, Blocks.field_150347_e.func_176223_P(), j, -1, i, boundingbox);
            }
        }
        for (i = 0; i < this.lecternGenned.length; ++i) {
            if (this.lecternGenned[i]) continue;
            this.lecternGenned[i] = this.generateStructureLectern(worldObj, boundingbox, rand, lecternCoords[i][0], lecternCoords[i][1], lecternCoords[i][2], lecternTargs[i][0], lecternTargs[i][1]);
        }
        if (Mystcraft.archivistEnabled()) {
            this.func_74893_a(worldObj, boundingbox, 4, 2, 4, 1);
        }
        return true;
    }

    private EnumFacing getStairRotation(EnumFacing original) {
        if (this.func_186165_e() == null) {
            return original;
        }
        switch (this.func_186165_e()) {
            case NORTH: {
                if (original == EnumFacing.SOUTH) {
                    return EnumFacing.EAST;
                }
                if (original != EnumFacing.EAST) break;
                return EnumFacing.SOUTH;
            }
            case WEST: {
                if (original == EnumFacing.NORTH) {
                    return EnumFacing.SOUTH;
                }
                if (original == EnumFacing.WEST) {
                    return EnumFacing.EAST;
                }
                if (original == EnumFacing.SOUTH) {
                    return EnumFacing.NORTH;
                }
                if (original != EnumFacing.EAST) break;
                return EnumFacing.WEST;
            }
            case EAST: {
                if (original == EnumFacing.NORTH) {
                    return EnumFacing.SOUTH;
                }
                if (original == EnumFacing.WEST) {
                    return EnumFacing.EAST;
                }
                if (original == EnumFacing.SOUTH) {
                    return EnumFacing.WEST;
                }
                if (original != EnumFacing.EAST) break;
                return EnumFacing.NORTH;
            }
        }
        return original;
    }

    protected boolean generateStructureLectern(World worldObj, StructureBoundingBox boundingbox, Random rand, int i, int j, int k, int i2, int k2) {
        int ti = this.func_74865_a(i, k);
        int tj = this.func_74862_a(j);
        int tk = this.func_74873_b(i, k);
        int ti2 = this.func_74865_a(i2, k2);
        int tk2 = this.func_74873_b(i2, k2);
        BlockPos at = new BlockPos(ti, tj, tk);
        if (boundingbox.func_175898_b((Vec3i)at)) {
            EnumFacing horizontal = EnumFacing.func_176733_a((double)(360 - ComponentVillageArchivistHouse.getRotation(ti, tk, ti2, tk2) + 90));
            worldObj.func_175656_a(at, ModBlocks.lectern.func_176223_P().func_177226_a(BlockLectern.ROTATION, (Comparable)horizontal));
            TileEntityLectern lectern = (TileEntityLectern)worldObj.func_175625_s(at);
            if (lectern != null) {
                lectern.setYaw(360 - ComponentVillageArchivistHouse.getRotation(ti, tk, ti2, tk2) + 90);
                if (rand.nextFloat() < 0.6f) {
                    LootTable lootTable = worldObj.func_184146_ak().func_186521_a(LootTableHandler.MYST_TREASURE);
                    LootContext lootContext = new LootContext.Builder((WorldServer)worldObj).func_186471_a();
                    List result = lootTable.func_186462_a(rand, lootContext);
                    Collections.shuffle(result, rand);
                    for (ItemStack stack : result) {
                        if (!lectern.canAcceptItem(0, stack)) continue;
                        lectern.setBook(stack);
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static int getRotation(int i, int k, int i2, int k2) {
        int deltaX = i2 - i;
        int deltaZ = -(k2 - k);
        if (deltaZ == 0) {
            return deltaX < 0 ? 180 : 0;
        }
        if (deltaX == 0) {
            return deltaZ < 0 ? 270 : 90;
        }
        float f = (float)deltaZ / (float)deltaX;
        return (int)(Math.atan(f) * 180.0 / Math.PI);
    }

    private void placeDeskAt(World worldObj, int i, int j, int k, int i2, int k2, StructureBoundingBox boundingbox) {
        Block block = ModBlocks.writingdesk;
        int ti = this.func_74865_a(i, k);
        int tk = this.func_74873_b(i, k);
        int ti2 = this.func_74865_a(i2, k2);
        int tk2 = this.func_74873_b(i2, k2);
        EnumFacing facing = BlockWritingDesk.getMetadataFromDirection(ti2 - ti, tk2 - tk);
        this.func_175811_a(worldObj, block.func_176223_P().func_177226_a(BlockWritingDesk.ROTATION, (Comparable)facing), i, j, k, boundingbox);
        this.func_175811_a(worldObj, block.func_176223_P().func_177226_a(BlockWritingDesk.ROTATION, (Comparable)facing).func_177226_a((IProperty)BlockWritingDesk.IS_FOOT, (Comparable)Boolean.valueOf(true)), i2, j, k2, boundingbox);
    }

    protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
        return Mystcraft.instance.archivist;
    }
}

