/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen.structure;

import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

abstract class ComponentScatteredFeatureMyst
extends StructureComponent {
    protected int scatteredFeaturePosX;
    protected int scatteredFeaturePosY;
    protected int scatteredFeaturePosZ;
    protected int horizontalPos = -1;

    public ComponentScatteredFeatureMyst() {
    }

    protected ComponentScatteredFeatureMyst(Random par1Random, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        super(0);
        this.scatteredFeaturePosX = x;
        this.scatteredFeaturePosY = y;
        this.scatteredFeaturePosZ = z;
        this.func_186164_a(EnumFacing.field_176754_o[par1Random.nextInt(EnumFacing.field_176754_o.length)]);
        switch (this.func_186165_e()) {
            case NORTH: 
            case SOUTH: {
                this.field_74887_e = new StructureBoundingBox(x, y, z, x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1);
                break;
            }
            default: {
                this.field_74887_e = new StructureBoundingBox(x, y, z, x + sizeZ - 1, y + sizeY - 1, z + sizeX - 1);
            }
        }
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Width", this.scatteredFeaturePosX);
        tagCompound.func_74768_a("Height", this.scatteredFeaturePosY);
        tagCompound.func_74768_a("Depth", this.scatteredFeaturePosZ);
        tagCompound.func_74768_a("HPos", this.horizontalPos);
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
        this.scatteredFeaturePosX = tagCompound.func_74762_e("Width");
        this.scatteredFeaturePosY = tagCompound.func_74762_e("Height");
        this.scatteredFeaturePosZ = tagCompound.func_74762_e("Depth");
        this.horizontalPos = tagCompound.func_74762_e("HPos");
    }

    protected int getAverageGroundLevel(World worldObj, StructureBoundingBox boundingbox) {
        int i = 0;
        int j = 0;
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                if (!boundingbox.func_175898_b(new Vec3i(l, 64, k))) continue;
                i += Math.max(worldObj.func_175672_r(new BlockPos(l, 0, k)).func_177956_o(), worldObj.field_73011_w.func_76557_i());
                ++j;
            }
        }
        if (j == 0) {
            return -1;
        }
        return i / j;
    }

    protected boolean shouldBuildHere(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3) {
        if (this.horizontalPos >= 0) {
            return true;
        }
        int var4 = 0;
        int var5 = 0;
        for (int var6 = this.field_74887_e.field_78896_c; var6 <= this.field_74887_e.field_78892_f; ++var6) {
            for (int var7 = this.field_74887_e.field_78897_a; var7 <= this.field_74887_e.field_78893_d; ++var7) {
                if (!par2StructureBoundingBox.func_175898_b(new Vec3i(var7, 64, var6))) continue;
                var4 += Math.max(par1World.func_175672_r(new BlockPos(var7, 0, var6)).func_177956_o(), par1World.field_73011_w.func_76557_i());
                ++var5;
            }
        }
        if (var5 == 0) {
            return false;
        }
        this.horizontalPos = var4 / var5;
        this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + par3, 0);
        return true;
    }
}

