/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen;

import com.xcompwiz.mystcraft.world.gen.MapGenAdvanced;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class MapGenFloatingIslands
extends MapGenAdvanced {
    private int rate = 192;
    private NoiseGeneratorOctaves noiseGen4;
    private double[] stoneNoise;
    private Biome biome;
    private IModifiedHandler callback;

    public MapGenFloatingIslands(long seed, Biome biome, IModifiedHandler callback, IBlockState state) {
        super(seed, state);
        this.range = 5;
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.biome = biome;
        this.callback = callback;
    }

    protected void generateCaveNode(long seed, int chunkX, int chunkZ, ChunkPrimer primer, boolean[] modified, double baseX, double baseY, double baseZ, float scalar, float angleB, float angleC, int loopc, int maxLoops, double squash) {
        boolean flag1;
        double chunkXmid = chunkX * 16 + 8;
        double chunkZmid = chunkZ * 16 + 8;
        int layers = 256;
        float f = 0.0f;
        float f1 = 0.0f;
        Random random = new Random(seed);
        if (maxLoops <= 0) {
            int i = this.range * 16 - 16;
            maxLoops = i - random.nextInt(i / 4);
        }
        boolean flag = false;
        if (loopc == -1) {
            loopc = maxLoops / 2;
            flag = true;
        }
        int j = random.nextInt(maxLoops / 2) + maxLoops / 4;
        boolean bl = flag1 = random.nextInt(6) == 0;
        while (loopc < maxLoops) {
            double d2 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)loopc * (float)Math.PI / (float)maxLoops)) * scalar * 1.0f);
            double d3 = d2 * squash;
            float f2 = MathHelper.func_76134_b((float)angleC);
            float f3 = MathHelper.func_76126_a((float)angleC);
            baseX += (double)(MathHelper.func_76134_b((float)angleB) * f2);
            baseY += (double)f3;
            baseZ += (double)(MathHelper.func_76126_a((float)angleB) * f2);
            angleC = flag1 ? (angleC *= 0.92f) : (angleC *= 0.7f);
            angleC += f1 * 0.1f;
            angleB += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 1.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag && loopc == j && scalar > 1.0f && maxLoops > 0) {
                this.generateCaveNode(random.nextLong(), chunkX, chunkZ, primer, modified, baseX, baseY, baseZ, random.nextFloat() * 0.5f + 0.5f, angleB - 1.5707964f, angleC / 3.0f, loopc, maxLoops, squash);
                this.generateCaveNode(random.nextLong(), chunkX, chunkZ, primer, modified, baseX, baseY, baseZ, random.nextFloat() * 0.5f + 0.5f, angleB + 1.5707964f, angleC / 3.0f, loopc, maxLoops, squash);
                return;
            }
            if (flag || random.nextInt(4) != 0) {
                double xoffset = baseX - chunkXmid;
                double yoffset = baseZ - chunkZmid;
                double zoffset = maxLoops - loopc;
                double d7 = scalar + 2.0f + 16.0f;
                if (xoffset * xoffset + yoffset * yoffset - zoffset * zoffset > d7 * d7) {
                    return;
                }
                if (!(baseX < chunkXmid - 16.0 - d2 * 2.0 || baseZ < chunkZmid - 16.0 - d2 * 2.0 || baseX > chunkXmid + 16.0 + d2 * 2.0 || baseZ > chunkZmid + 16.0 + d2 * 2.0)) {
                    int minX = MathHelper.func_76128_c((double)(baseX - d2)) - chunkX * 16 - 1;
                    int maxX = MathHelper.func_76128_c((double)(baseX + d2)) - chunkX * 16 + 1;
                    int minY = MathHelper.func_76128_c((double)(baseY - d3)) - 1;
                    int maxY = MathHelper.func_76128_c((double)(baseY + d3)) + 1;
                    int minZ = MathHelper.func_76128_c((double)(baseZ - d2)) - chunkZ * 16 - 1;
                    int maxZ = MathHelper.func_76128_c((double)(baseZ + d2)) - chunkZ * 16 + 1;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (maxX > 16) {
                        maxX = 16;
                    }
                    if (minY < 1) {
                        minY = 1;
                    }
                    if (maxY > layers) {
                        maxY = layers;
                    }
                    if (minZ < 0) {
                        minZ = 0;
                    }
                    if (maxZ > 16) {
                        maxZ = 16;
                    }
                    for (int localY = minY; localY < maxY; ++localY) {
                        double yfactor = ((double)localY + 0.5 - baseY) / d3;
                        double yfactorSq = yfactor * yfactor;
                        for (int localZ = minZ; localZ < maxZ; ++localZ) {
                            double zfactor = ((double)(localZ + chunkZ * 16) + 0.5 - baseZ) / d2;
                            double zfactorSq = zfactor * zfactor;
                            for (int localX = minX; localX < maxX; ++localX) {
                                double xfactor = ((double)(localX + chunkX * 16) + 0.5 - baseX) / d2;
                                double xfactorSq = xfactor * xfactor;
                                int coords = localY << 8 | localZ << 4 | localX;
                                double total = xfactorSq + yfactorSq + zfactorSq;
                                if (!(total < 1.0)) continue;
                                this.placeBlock(primer, modified, coords, localX, localY, localZ);
                            }
                        }
                    }
                    if (flag) break;
                }
            }
            ++loopc;
        }
    }

    protected void placeBlock(ChunkPrimer primer, boolean[] modified, int coords, int x, int y, int z) {
        if (super.placeBlock(primer, x, y, z)) {
            modified[coords & 0xFF] = true;
        }
    }

    private void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer primer, boolean[] modified, Biome biome) {
        int layers = 256;
        double noisefactor = 0.03125;
        this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, noisefactor * 2.0, noisefactor * 2.0, noisefactor * 2.0);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                if (!modified[x + z * 16]) continue;
                int stone_noise_val = (int)(this.stoneNoise[z + x * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int counter = -1;
                IBlockState filler = biome.field_76753_B;
                for (int y = layers - 1; y >= 0; --y) {
                    IBlockState blockId = primer.func_177856_a(x, y, z);
                    if (blockId != Blocks.field_150348_b) continue;
                    if (counter == -1) {
                        IBlockState surface = biome.field_76752_A;
                        filler = biome.field_76753_B;
                        counter = stone_noise_val;
                        primer.func_177855_a(x, y, z, surface);
                        continue;
                    }
                    if (counter <= 0) continue;
                    primer.func_177855_a(x, y, z, filler);
                    if (--counter != 0 || filler != Blocks.field_150354_m) continue;
                    counter = this.rand.nextInt(4);
                    filler = Blocks.field_150322_A.func_176223_P();
                }
            }
        }
    }

    @Override
    protected void recursiveGenerate(World worldObj, int x, int z, int chunkX, int chunkZ, ChunkPrimer primer) {
        if (this.rand.nextInt(this.rate) != 0) {
            return;
        }
        boolean[] modified = new boolean[256];
        double dx = x * 16 + this.rand.nextInt(16);
        double dy = this.rand.nextInt(this.rand.nextInt(50) + 50) + 150;
        double dz = z * 16 + this.rand.nextInt(16);
        this.generateCaveNode(this.rand.nextLong(), chunkX, chunkZ, primer, modified, dx, dy, dz, 12.0f, 0.0f, 0.0f, -1, -1, 0.2);
        int subelements = this.rand.nextInt(12) + 40;
        for (int i = 0; i < subelements; ++i) {
            double subx = dx + (this.rand.nextDouble() - this.rand.nextDouble()) * 20.0;
            double suby = dy + (this.rand.nextDouble() - this.rand.nextDouble()) * 10.0;
            double subz = dz + (this.rand.nextDouble() - this.rand.nextDouble()) * 20.0;
            float scale = this.rand.nextFloat() * 3.0f + 1.0f;
            this.generateCaveNode(this.rand.nextLong(), chunkX, chunkZ, primer, modified, subx, suby, subz, scale, 0.0f, 0.0f, -1, -1, 0.4);
        }
        this.replaceBlocksForBiome(chunkX, chunkZ, primer, modified, this.biome);
        this.callback.passModified(chunkX, chunkZ, modified, this.biome);
    }

    public static interface IModifiedHandler {
        public void passModified(int var1, int var2, boolean[] var3, Biome var4);
    }
}

