/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;

public class MapGenAdvanced {
    protected int range = 8;
    protected Random rand = new Random();
    private long seed;
    private IBlockState state;
    private boolean profiling = false;
    private int blockcount;
    private int blockcounttotal = 0;
    private int callcount = 0;
    private int fillcount = 0;

    public MapGenAdvanced(long seed, IBlockState state) {
        this.seed = seed;
        this.state = state;
    }

    public void generate(IChunkProvider chunkprovider, World worldObj, int chunkX, int chunkZ, ChunkPrimer primer) {
        int range = this.range;
        this.rand.setSeed(this.seed);
        long xseed = this.rand.nextLong();
        long zseed = this.rand.nextLong();
        this.blockcount = 0;
        ++this.callcount;
        for (int x = chunkX - range; x <= chunkX + range; ++x) {
            for (int z = chunkZ - range; z <= chunkZ + range; ++z) {
                long xseed2 = (long)x * xseed;
                long zseed2 = (long)z * zseed;
                this.rand.setSeed(xseed2 ^ zseed2 ^ this.seed);
                this.recursiveGenerate(worldObj, x, z, chunkX, chunkZ, primer);
            }
        }
        if (this.profiling) {
            if (this.blockcount > 0) {
                ++this.fillcount;
            }
            System.out.println(String.format("Using %s. AVG: [%f] / %d / %d TOT: [%d] GENFRQ: [%f:%f]", this.toString(), Float.valueOf((float)this.blockcounttotal / (float)this.fillcount), this.fillcount, this.callcount, this.blockcounttotal, Float.valueOf((float)this.fillcount / (float)this.callcount), Float.valueOf((float)this.blockcounttotal / (float)this.callcount)));
        }
    }

    protected void recursiveGenerate(World worldObj, int x, int z, int chunkX, int chunkZ, ChunkPrimer primer) {
    }

    protected boolean placeBlock(ChunkPrimer primer, int x, int y, int z) {
        IBlockState state = primer.func_177856_a(x, y, z);
        if (this.state == null || state.func_185904_a().func_76224_d()) {
            return false;
        }
        if (state.func_177230_c().equals(Blocks.field_150357_h)) {
            return false;
        }
        ++this.blockcounttotal;
        ++this.blockcount;
        primer.func_177855_a(x, y, z, this.state);
        return true;
    }

    public void setProfiling(boolean profiling) {
        this.profiling = profiling;
    }
}

