/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.agedata;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBiome;
import com.xcompwiz.mystcraft.world.agedata.AgeDataLoaderManager;
import com.xcompwiz.mystcraft.world.agedata.AgeDataLoaderV4;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class AgeDataLegacy
extends AgeDataLoaderManager.AgeDataLoader {
    @Override
    public AgeDataData load(NBTTagCompound nbttagcompound) {
        String symbolid;
        int i;
        int i2;
        AgeDataData data = new AgeDataData();
        data.version = "legacy";
        data.agename = nbttagcompound.func_74779_i("AgeName");
        data.seed = nbttagcompound.func_74763_f("Seed");
        data.visited = nbttagcompound.func_74767_n("Visited");
        data.worldtime = nbttagcompound.func_74763_f("WorldTime");
        data.instability = nbttagcompound.func_74764_b("BaseIns") ? nbttagcompound.func_74765_d("BaseIns") : (nbttagcompound.func_74764_b("Instability") ? nbttagcompound.func_74765_d("Instability") : nbttagcompound.func_74765_d("Decay"));
        data.instabilityEnabled = nbttagcompound.func_74764_b("InstabilityEnabled") ? nbttagcompound.func_74767_n("InstabilityEnabled") : true;
        data.spawn = nbttagcompound.func_74764_b("SpawnX") && nbttagcompound.func_74764_b("SpawnY") && nbttagcompound.func_74764_b("SpawnZ") ? new BlockPos(nbttagcompound.func_74762_e("SpawnX"), nbttagcompound.func_74762_e("SpawnY"), nbttagcompound.func_74762_e("SpawnZ")) : null;
        if (nbttagcompound.func_74764_b("Pages")) {
            NBTTagList list = nbttagcompound.func_150295_c("Pages", 10);
            for (i2 = 0; i2 < list.func_74745_c(); ++i2) {
                NBTTagCompound pagedata = list.func_150305_b(i2);
                data.pages.add(Page.createPage(pagedata));
            }
        } else if (nbttagcompound.func_74764_b("SymbolCount")) {
            int symbolcount = nbttagcompound.func_74762_e("SymbolCount");
            for (i2 = 0; i2 < symbolcount; ++i2) {
                if (!nbttagcompound.func_74764_b("Symbol" + i2)) continue;
                data.pages.add(Page.createSymbolPage(nbttagcompound.func_74779_i("Symbol" + i2)));
            }
        }
        if (nbttagcompound.func_74764_b("Symbols")) {
            NBTUtils.readStringCollection(nbttagcompound.func_150295_c("Symbols", 8), data.symbols);
        } else if (data.visited) {
            for (ItemStack page : data.pages) {
                String symbol2 = Page.getSymbol(page);
                if (symbol2 == null) continue;
                data.symbols.add(symbol2);
            }
        }
        if (nbttagcompound.func_74764_b("Effects")) {
            NBTUtils.readStringCollection(nbttagcompound.func_150295_c("Effects", 8), data.effects);
        } else if (nbttagcompound.func_74764_b("EffectsCount")) {
            int effectscount = nbttagcompound.func_74762_e("EffectsCount");
            for (i2 = 0; i2 < effectscount; ++i2) {
                if (!nbttagcompound.func_74764_b("Effect" + i2)) continue;
                data.effects.add(nbttagcompound.func_74779_i("Effect" + i2));
            }
        } else {
            data.effects.add("decayblack");
        }
        if (nbttagcompound.func_74764_b("DataCompound")) {
            data.datacompound = nbttagcompound.func_74775_l("DataCompound");
        } else {
            data.datacompound = new NBTTagCompound();
            data.pages.add(Page.createSymbolPage("WeatherNorm"));
        }
        if (data.visited && (!nbttagcompound.func_74764_b("Version") || nbttagcompound.func_74779_i("Version").equals("3"))) {
            data.pages.add(Page.createSymbolPage("NormalStars"));
        }
        if (nbttagcompound.func_74764_b("BiomeCount")) {
            int biomecount = nbttagcompound.func_74762_e("BiomeCount");
            for (i2 = 0; i2 < biomecount; ++i2) {
                if (!nbttagcompound.func_74764_b("Biome" + i2)) continue;
                data.pages.add(Page.createSymbolPage(SymbolBiome.getBiomeSymbolId(Biome.func_150568_d((int)i2))));
            }
        }
        if (nbttagcompound.func_74764_b("AgeType")) {
            data.pages.add(Page.createSymbolPage("Single Biome"));
            data.pages.add(Page.createSymbolPage("LightingNormal"));
            data.pages.add(Page.createSymbolPage("TerrainNormal"));
            data.pages.add(Page.createSymbolPage("Villages"));
            data.pages.add(Page.createSymbolPage("Caves"));
            data.pages.add(Page.createSymbolPage("Ravines"));
            data.pages.add(Page.createSymbolPage("Lakes"));
            data.pages.add(Page.createSymbolPage("LavaLakes"));
            data.pages.add(Page.createSymbolPage("ModFull"));
            data.pages.add(Page.createSymbolPage("SunNormal"));
            data.pages.add(Page.createSymbolPage("ModFull"));
            data.pages.add(Page.createSymbolPage("MoonNormal"));
        }
        HashSet<String> biomenames = new HashSet<String>();
        Iterator iterator = Biome.field_185377_q.iterator();
        while (iterator.hasNext()) {
            biomenames.add(((Biome)iterator.next()).func_185359_l());
        }
        HashSet<IAgeSymbol> controllers = SymbolManager.findAgeSymbolsImplementing(IBiomeController.class);
        HashSet<String> controllernames = new HashSet<String>();
        for (IAgeSymbol symbol3 : controllers) {
            controllernames.add(symbol3.identifier());
        }
        int cpos = 0;
        for (i = 0; i < data.pages.size(); ++i) {
            symbolid = Page.getSymbol((ItemStack)data.pages.get(i));
            if (biomenames.contains(symbolid)) {
                data.pages.add(0, data.pages.remove(i));
                ++cpos;
                continue;
            }
            if (!controllernames.contains(symbolid)) continue;
            data.pages.add(cpos, data.pages.remove(i));
            ++cpos;
        }
        cpos = 0;
        for (i = 0; i < data.symbols.size(); ++i) {
            symbolid = (String)data.symbols.get(i);
            if (biomenames.contains(symbolid)) {
                data.symbols.add(0, data.symbols.remove(i));
                ++cpos;
                continue;
            }
            if (!controllernames.contains(symbolid)) continue;
            data.symbols.add(cpos, data.symbols.remove(i));
            ++cpos;
        }
        return data;
    }

    public static class AgeDataData
    extends AgeDataLoaderV4.AgeDataData {
    }
}

