/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.tileentity;

import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import com.xcompwiz.mystcraft.tileentity.IOInventory;
import com.xcompwiz.mystcraft.tileentity.InventoryFilter;
import com.xcompwiz.mystcraft.tileentity.InventoryUpdateListener;
import com.xcompwiz.mystcraft.tileentity.TileEntityBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityBook
extends TileEntityBase
implements InventoryUpdateListener,
InventoryFilter {
    private IOInventory inventory = this.buildInventory();

    protected IOInventory buildInventory() {
        return new IOInventory(this, new int[]{0}, new int[]{0}, EnumFacing.field_82609_l).setListener(this).applyFilter(this, 0).setStackLimit(1, 0);
    }

    public void setBook(@Nonnull ItemStack itemstack) {
        if (!itemstack.func_190926_b()) {
            this.ejectItem(this.inventory.getStackInSlot(0));
        }
        this.inventory.setStackInSlot(0, itemstack);
        this.func_70296_d();
        this.handleItemChange(0);
    }

    @Override
    public boolean canAcceptItem(int slot, @Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemLinking;
    }

    @Override
    public void onChange() {
        this.markForUpdate();
    }

    @Nonnull
    public ItemStack getBook() {
        return this.inventory.getStackInSlot(0);
    }

    public String getBookTitle() {
        String title = null;
        if (!this.getBook().func_190926_b() && this.getBook().func_77973_b() instanceof ItemLinking) {
            title = LinkOptions.getDisplayName(this.getBook().func_77978_p());
        }
        return title;
    }

    @Nonnull
    public ItemStack getDisplayItem() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.inventory.readNBT(compound.func_74775_l("inventory"));
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.handleItemChange(i);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.writeNBT());
    }

    public void handleItemChange(int slot) {
        if (!this.canAcceptItem(slot, this.inventory.getStackInSlot(slot))) {
            this.ejectItem(this.inventory.getStackInSlot(slot));
            this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.markForUpdate();
        }
    }

    private void ejectItem(@Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b() || this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        float f = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f1 = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f2 = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + f), (double)((float)this.field_174879_c.func_177956_o() + f1), (double)((float)this.field_174879_c.func_177952_p() + f2), itemstack);
        float f3 = 0.05f;
        entityitem.field_70159_w = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3;
        entityitem.field_70181_x = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3 + 0.2f;
        entityitem.field_70179_y = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3;
        this.field_145850_b.func_72838_d((Entity)entityitem);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory.hasCapability(facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getCapability(facing);
        }
        return null;
    }
}

