/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.TerrainGeneratorBase;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class SymbolTerrainGenNormal
extends SymbolBase {
    public SymbolTerrainGenNormal(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        TerrainGeneratorNormal gen = new TerrainGeneratorNormal(controller, false);
        BlockDescriptor block = ModifierUtils.popBlockMatching(controller, BlockCategory.SEA);
        if (block != null) {
            gen.setSeaBlock(block.blockstate);
        }
        if ((block = ModifierUtils.popBlockMatching(controller, BlockCategory.TERRAIN)) != null) {
            gen.setTerrainBlock(block.blockstate);
        }
        controller.registerInterface(gen);
    }

    public static class TerrainGeneratorNormal
    extends TerrainGeneratorBase {
        private final boolean amplified;
        private Random rand;
        private NoiseGeneratorOctaves noiseGen1;
        private NoiseGeneratorOctaves noiseGen2;
        private NoiseGeneratorOctaves noiseGen3;
        private NoiseGeneratorOctaves noiseGen4;
        private NoiseGeneratorOctaves noiseGen5;
        private double[] noiseData1;
        private double[] noiseData2;
        private double[] noiseData3;
        private double[] noiseData4;
        private double[] noiseData5;
        private float[] parabolicField;
        protected Biome[] biomesForGeneration;

        public TerrainGeneratorNormal(AgeDirector controller, boolean amplified) {
            super(controller);
            this.amplified = amplified;
            this.rand = new Random(controller.getSeed());
            this.bedrockGen = new Random(controller.getSeed());
            this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
            this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
            this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
            this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 10);
            this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 16);
        }

        @Override
        protected double[] initializeNoiseField(double[] noise_field, int subchunkX, int subchunkY, int subchunkZ, int sizeX, int sizeY, int sizeZ) {
            this.biomesForGeneration = this.controller.getBiomeProvider().func_76937_a(this.biomesForGeneration, subchunkX - 2, subchunkZ - 2, sizeX + 5, sizeZ + 5);
            if (noise_field == null) {
                noise_field = new double[sizeX * sizeY * sizeZ];
            }
            if (this.parabolicField == null) {
                this.parabolicField = new float[25];
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        this.parabolicField[(z + 2) * 5 + x + 2] = 10.0f / MathHelper.func_76129_c((float)((float)(x * x + z * z) + 0.2f));
                    }
                }
            }
            double cfactor1 = 684.412;
            double cfactor2 = 684.412;
            this.noiseData4 = this.noiseGen4.func_76304_a(this.noiseData4, subchunkX, 10, subchunkZ, sizeX, 1, sizeZ, 1.121, 1.0, 1.121);
            this.noiseData5 = this.noiseGen5.func_76304_a(this.noiseData5, subchunkX, 10, subchunkZ, sizeX, 1, sizeZ, 200.0, 1.0, 200.0);
            this.noiseData3 = this.noiseGen3.func_76304_a(this.noiseData3, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, cfactor1 / 80.0, cfactor2 / 160.0, cfactor1 / 80.0);
            this.noiseData1 = this.noiseGen1.func_76304_a(this.noiseData1, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, cfactor1, cfactor2, cfactor1);
            this.noiseData2 = this.noiseGen2.func_76304_a(this.noiseData2, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, cfactor1, cfactor2, cfactor1);
            int noise_index = 0;
            int noise5_index = 0;
            for (int x = 0; x < sizeX; ++x) {
                for (int z = 0; z < sizeZ; ++z) {
                    float avgMaxHeight = 0.0f;
                    float avgMinHeight = 0.0f;
                    float sumTotalWeight = 0.0f;
                    int sizec = 2;
                    Biome biome = this.biomesForGeneration[x + 2 + (z + 2) * (sizeX + 5)];
                    for (int xOffset = -sizec; xOffset <= sizec; ++xOffset) {
                        for (int zOffset = -sizec; zOffset <= sizec; ++zOffset) {
                            Biome secondary_biome = this.biomesForGeneration[x + xOffset + 2 + (z + zOffset + 2) * (sizeX + 5)];
                            float height = secondary_biome.func_185355_j();
                            float variation = secondary_biome.func_185360_m();
                            if (this.amplified && height > 0.0f) {
                                height = 1.0f + height * 2.0f;
                                variation = 1.0f + variation * 4.0f;
                            }
                            float weight = this.parabolicField[xOffset + 2 + (zOffset + 2) * 5] / (height + 2.0f);
                            if (height > biome.func_185355_j()) {
                                weight /= 2.0f;
                            }
                            avgMaxHeight += variation * weight;
                            avgMinHeight += height * weight;
                            sumTotalWeight += weight;
                        }
                    }
                    avgMaxHeight /= sumTotalWeight;
                    avgMinHeight /= sumTotalWeight;
                    avgMaxHeight = avgMaxHeight * 0.9f + 0.1f;
                    avgMinHeight = (avgMinHeight * 4.0f - 1.0f) / 8.0f;
                    int n = noise5_index++;
                    double noise5 = this.noiseData5[n] / 8000.0;
                    if (noise5 < 0.0) {
                        noise5 = -noise5 * 0.3;
                    }
                    if ((noise5 = noise5 * 3.0 - 2.0) < 0.0) {
                        if ((noise5 /= 2.0) < -1.0) {
                            noise5 = -1.0;
                        }
                        noise5 /= 1.4;
                        noise5 /= 2.0;
                    } else {
                        if (noise5 > 1.0) {
                            noise5 = 1.0;
                        }
                        noise5 /= 8.0;
                    }
                    for (int y = 0; y < sizeY; ++y) {
                        double minHeightD = avgMinHeight;
                        double maxHeightD = avgMaxHeight;
                        minHeightD += noise5 * 0.2;
                        minHeightD = minHeightD * (double)sizeY / 16.0;
                        double height = (double)sizeY / 2.0 + minHeightD * 4.0;
                        double density = 0.0;
                        double avgDensity = ((double)y - height) * 12.0 * 128.0 / 128.0 / maxHeightD;
                        if (avgDensity < 0.0) {
                            avgDensity *= 4.0;
                        }
                        double noise1 = this.noiseData1[noise_index] / 512.0;
                        double noise2 = this.noiseData2[noise_index] / 512.0;
                        double noise3 = (this.noiseData3[noise_index] / 10.0 + 1.0) / 2.0;
                        density = noise3 < 0.0 ? noise1 : (noise3 > 1.0 ? noise2 : noise1 + (noise2 - noise1) * noise3);
                        density -= avgDensity;
                        if (y > sizeY - 4) {
                            double d11 = (float)(y - (sizeY - 4)) / 3.0f;
                            density = density * (1.0 - d11) + -10.0 * d11;
                        }
                        noise_field[noise_index++] = density;
                    }
                }
            }
            return noise_field;
        }
    }
}

