/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.TerrainGeneratorBase;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class SymbolTerrainGenEnd
extends SymbolBase {
    public SymbolTerrainGenEnd(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        TerrainGenerator gen = new TerrainGenerator(controller);
        BlockDescriptor block = ModifierUtils.popBlockMatching(controller, BlockCategory.SEA);
        if (block != null) {
            gen.setSeaBlock(block.blockstate);
        } else {
            gen.setSeaBlock(Blocks.field_150350_a.func_176223_P());
        }
        block = ModifierUtils.popBlockMatching(controller, BlockCategory.TERRAIN);
        if (block != null) {
            gen.setTerrainBlock(block.blockstate);
        }
        controller.registerInterface(gen);
        controller.setHorizon(0.0);
        controller.setSeaLevel(49);
        controller.setDrawHorizon(false);
        controller.setDrawVoid(false);
    }

    private static class TerrainGenerator
    extends TerrainGeneratorBase {
        private Random rand;
        private NoiseGeneratorOctaves noiseGen1;
        private NoiseGeneratorOctaves noiseGen2;
        private NoiseGeneratorOctaves noiseGen3;
        private NoiseGeneratorOctaves noiseGen4;
        private NoiseGeneratorOctaves noiseGen5;
        private double[] noiseData1;
        private double[] noiseData2;
        private double[] noiseData3;
        private double[] noiseData4;
        private double[] noiseData5;

        public TerrainGenerator(AgeDirector controller) {
            super(controller);
            this.rand = new Random(controller.getSeed());
            this.bedrockGen = new Random(controller.getSeed());
            this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
            this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
            this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
            this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 10);
            this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 16);
            this.genBedrock = false;
        }

        @Override
        protected double[] initializeNoiseField(double[] noise_field, int subchunkX, int subchunkY, int subchunkZ, int sizeX, int sizeY, int sizeZ) {
            if (noise_field == null) {
                noise_field = new double[sizeX * sizeY * sizeZ];
            }
            double var8 = 684.412;
            double var10 = 684.412;
            this.noiseData4 = this.noiseGen4.func_76305_a(this.noiseData4, subchunkX, subchunkZ, sizeX, sizeZ, 1.121, 1.121, 0.5);
            this.noiseData5 = this.noiseGen5.func_76305_a(this.noiseData5, subchunkX, subchunkZ, sizeX, sizeZ, 200.0, 200.0, 0.5);
            this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, (var8 *= 2.0) / 80.0, var10 / 160.0, var8 / 80.0);
            this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, var8, var10, var8);
            this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, subchunkX, subchunkY, subchunkZ, sizeX, sizeY, sizeZ, var8, var10, var8);
            int noise_index = 0;
            int noise5_index = 0;
            for (int x = 0; x < sizeX; ++x) {
                for (int z = 0; z < sizeZ; ++z) {
                    double noise5;
                    double noise4 = (this.noiseData4[noise5_index] + 256.0) / 512.0;
                    if (noise4 > 1.0) {
                        noise4 = 1.0;
                    }
                    if ((noise5 = this.noiseData5[noise5_index] / 8000.0) < 0.0) {
                        noise5 = -noise5 * 0.3;
                    }
                    noise5 = noise5 * 3.0 - 2.0;
                    float xCoord = (float)(x + subchunkX - 0) / 1.0f;
                    float yCoord = (float)(z + subchunkZ - 0) / 1.0f;
                    float distFactor = 100.0f - MathHelper.func_76129_c((float)(xCoord * xCoord + yCoord * yCoord)) * 4.0f;
                    if (distFactor > 80.0f) {
                        distFactor = 80.0f;
                    }
                    if (distFactor < -100.0f) {
                        distFactor = -100.0f;
                    }
                    if (noise5 > 1.0) {
                        noise5 = 1.0;
                    }
                    noise5 /= 8.0;
                    noise5 = 0.0;
                    if (noise4 < 0.0) {
                        noise4 = 0.0;
                    }
                    noise4 += 0.5;
                    noise5 = noise5 * (double)sizeY / 16.0;
                    ++noise5_index;
                    double halfSizeY = (double)sizeY / 2.0;
                    for (int y = 0; y < sizeY; ++y) {
                        double factor;
                        double density = 0.0;
                        double terminal = ((double)y - halfSizeY) * 8.0 / noise4;
                        if (terminal < 0.0) {
                            terminal *= -1.0;
                        }
                        double noise2 = this.noiseData2[noise_index] / 512.0;
                        double noise3 = this.noiseData3[noise_index] / 512.0;
                        double noise1 = (this.noiseData1[noise_index] / 10.0 + 1.0) / 2.0;
                        density = noise1 < 0.0 ? noise2 : (noise1 > 1.0 ? noise3 : noise2 + (noise3 - noise2) * noise1);
                        density -= 8.0;
                        density += (double)distFactor;
                        int value = 2;
                        if (y > sizeY / 2 - value) {
                            factor = (float)(y - (sizeY / 2 - value)) / 64.0f;
                            if (factor < 0.0) {
                                factor = 0.0;
                            }
                            if (factor > 1.0) {
                                factor = 1.0;
                            }
                            density = density * (1.0 - factor) + -3000.0 * factor;
                        }
                        if (y < (value = 8)) {
                            factor = (float)(value - y) / ((float)value - 1.0f);
                            density = density * (1.0 - factor) + -30.0 * factor;
                        }
                        noise_field[noise_index] = density;
                        ++noise_index;
                    }
                }
            }
            return noise_field;
        }
    }
}

