/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.symbols.CelestialBase;
import java.util.Random;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SymbolStarsNormal
extends SymbolBase {
    public SymbolStarsNormal(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        Number period = controller.popModifier("wavelength").asNumber();
        Number angle = controller.popModifier("angle").asNumber();
        ColorGradient gradient = ModifierUtils.popGradient(controller, 1.0f, 1.0f, 1.0f);
        controller.registerInterface(new SkyBackground(controller, seed, period, angle, gradient));
    }

    private class SkyBackground
    extends CelestialBase {
        private Random rand;
        private int starGLCallList;
        private boolean initialized;
        private long period;
        private float angle;
        private float offset = 0.0f;
        private ColorGradient gradient;
        private AgeDirector controller;

        SkyBackground(AgeDirector controller, long seed, Number period, Number angle, ColorGradient gradient) {
            this.controller = controller;
            this.rand = new Random(seed);
            if (period == null) {
                period = 1.8 * this.rand.nextDouble() + 0.2;
            }
            this.period = (long)(period.doubleValue() * 240000.0);
            if (angle == null) {
                angle = this.rand.nextDouble() * 360.0;
            }
            this.angle = -angle.floatValue();
            this.gradient = gradient;
        }

        @Override
        public void render(TextureManager texturemanager, World world, float partial) {
            if (!this.initialized) {
                this.initialize();
            }
            float invertRain = 1.0f - world.func_72867_j(partial);
            GlStateManager.func_179090_x();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(this.getCelestialPeriod(world.func_72820_D(), partial) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            float starbrightness = world.func_72880_h(partial) * invertRain;
            if (starbrightness > 0.0f) {
                Color color = this.gradient.getColor((float)this.controller.getTime() / 12000.0f);
                GlStateManager.func_179131_c((float)color.r, (float)color.g, (float)color.b, (float)starbrightness);
                GlStateManager.func_179148_o((int)this.starGLCallList);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }

        public float getCelestialPeriod(long time, float partialTime) {
            if (this.period == 0L) {
                return this.offset;
            }
            int i = (int)(time % this.period);
            float f = ((float)i + partialTime) / (float)this.period + this.offset;
            if (f < 0.0f) {
                f += 1.0f;
            }
            if (f > 1.0f) {
                f -= 1.0f;
            }
            float f1 = f;
            f = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
            f = f1 + (f - f1) / 3.0f;
            return f;
        }

        @SideOnly(value=Side.CLIENT)
        private void initialize() {
            this.initialized = true;
            this.starGLCallList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_179094_E();
            GlStateManager.func_187423_f((int)this.starGLCallList, (int)4864);
            this.renderStars();
            GlStateManager.func_187415_K();
            GlStateManager.func_179121_F();
        }

        @SideOnly(value=Side.CLIENT)
        private void renderStars() {
            Tessellator tes = Tessellator.func_178181_a();
            VertexBuffer vb = tes.func_178180_c();
            Random random = new Random(10842L);
            vb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            for (int i = 0; i < 1500; ++i) {
                double d0 = random.nextFloat() * 2.0f - 1.0f;
                double d1 = random.nextFloat() * 2.0f - 1.0f;
                double d2 = random.nextFloat() * 2.0f - 1.0f;
                double d3 = 0.15f + random.nextFloat() * 0.1f;
                double d4 = d0 * d0 + d1 * d1 + d2 * d2;
                if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
                d4 = 1.0 / Math.sqrt(d4);
                double d5 = (d0 *= d4) * 100.0;
                double d6 = (d1 *= d4) * 100.0;
                double d7 = (d2 *= d4) * 100.0;
                double d8 = Math.atan2(d0, d2);
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
                double d12 = Math.sin(d11);
                double d13 = Math.cos(d11);
                double d14 = random.nextDouble() * Math.PI * 2.0;
                double d15 = Math.sin(d14);
                double d16 = Math.cos(d14);
                for (int j = 0; j < 4; ++j) {
                    double d17 = 0.0;
                    double d18 = (double)((j & 2) - 1) * d3;
                    double d19 = (double)((j + 1 & 2) - 1) * d3;
                    double d20 = 0.0;
                    double d21 = d18 * d16 - d19 * d15;
                    double d22 = d19 * d16 + d18 * d15;
                    double d23 = d21 * d12 + 0.0 * d13;
                    double d24 = 0.0 * d12 - d21 * d13;
                    double d25 = d24 * d9 - d22 * d10;
                    double d26 = d22 * d9 + d24 * d10;
                    vb.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
                }
            }
            tes.func_78381_a();
        }

        private void setStarColor(int var3, Tessellator var2) {
        }
    }
}

