/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SymbolObelisks
extends SymbolBase {
    public SymbolObelisks(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        BlockDescriptor block = ModifierUtils.popBlockMatching(controller, BlockCategory.STRUCTURE);
        controller.registerInterface(new Populator(block));
    }

    private class Populator
    implements IPopulate {
        private IBlockState state;

        public Populator(BlockDescriptor descriptor) {
            this.state = descriptor == null ? Blocks.field_150343_Z.func_176223_P() : descriptor.blockstate;
        }

        @Override
        public boolean populate(World worldObj, Random rand, int i, int j, boolean flag) {
            if (rand.nextInt(128) == 0) {
                int j6 = i + rand.nextInt(16);
                int k10 = j + rand.nextInt(16);
                this.generate(worldObj, rand, new BlockPos(j6, worldObj.func_189649_b(j6, k10), k10));
            }
            return false;
        }

        private void generate(World worldObj, Random random, BlockPos base) {
            int x;
            int z;
            int y;
            if (base.func_177956_o() == 0) {
                return;
            }
            int height = 12;
            int width = 4;
            int maxDeep = 5;
            base = base.func_177984_a();
            boolean foundBase = false;
            for (y = base.func_177956_o(); y > base.func_177956_o() - maxDeep && !foundBase; --y) {
                foundBase = true;
                for (z = 0; z < width; ++z) {
                    for (x = 0; x < width; ++x) {
                        BlockPos posAt = new BlockPos(base.func_177958_n() + x, y, base.func_177952_p() + z);
                        worldObj.func_180501_a(posAt, this.state, 2);
                        Material material = worldObj.func_180495_p(posAt.func_177977_b()).func_185904_a();
                        if (!worldObj.func_175623_d(posAt.func_177977_b()) && !worldObj.func_180495_p(posAt.func_177977_b()).func_177230_c().equals(Blocks.field_150433_aE) && material != Material.field_151586_h && material != Material.field_151587_i) continue;
                        foundBase = false;
                    }
                }
            }
            base = base.func_177982_a(1, 0, 1);
            width = 2;
            for (y = 0; y < height; ++y) {
                for (z = 0; z < width; ++z) {
                    for (x = 0; x < width; ++x) {
                        worldObj.func_180501_a(base.func_177982_a(x, y, z), this.state, 2);
                    }
                }
            }
        }
    }
}

