/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBiome;
import com.xcompwiz.mystcraft.world.gen.layer.GenLayerBiomeMyst;
import com.xcompwiz.mystcraft.world.gen.layer.GenLayerZoomMyst;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.IntCache;

public class SymbolBiomeControllerLarge
extends SymbolBase {
    public SymbolBiomeControllerLarge(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        Biome biome = ModifierUtils.popBiome(controller);
        while (biome != null) {
            biomes.add(biome);
            biome = ModifierUtils.popBiome(controller);
        }
        controller.registerInterface(new BiomeController(controller, 3, biomes));
    }

    static class BiomeController
    implements IBiomeController {
        private Biome[] allowedBiomes;
        private List<Biome> biomesToSpawnIn;
        private GenLayer genBiomes;
        private GenLayer biomeIndexLayer;
        private BiomeCache biomeCache;
        private int zoomscale;

        protected BiomeController(AgeDirector controller, int zoom, List<Biome> biomes) {
            this.zoomscale = zoom;
            this.biomeCache = new BiomeCache(controller.getBiomeProvider());
            this.biomesToSpawnIn = new ArrayList<Biome>();
            this.biomesToSpawnIn.add(Biomes.field_76767_f);
            this.biomesToSpawnIn.add(Biomes.field_76772_c);
            this.biomesToSpawnIn.add(Biomes.field_76768_g);
            this.biomesToSpawnIn.add(Biomes.field_76784_u);
            this.biomesToSpawnIn.add(Biomes.field_76785_t);
            this.biomesToSpawnIn.add(Biomes.field_76782_w);
            this.biomesToSpawnIn.add(Biomes.field_76792_x);
            Random rand = new Random(controller.getSeed());
            while (biomes.size() < 3) {
                biomes.add(SymbolBiome.getRandomBiome(rand));
            }
            this.allowedBiomes = new Biome[biomes.size()];
            this.allowedBiomes = biomes.toArray(this.allowedBiomes);
            GenLayer[] agenlayer = this.computeGenLayers(controller.getSeed(), WorldType.field_77137_b);
            this.genBiomes = agenlayer[0];
            this.biomeIndexLayer = agenlayer[1];
        }

        @Override
        public List<Biome> getValidSpawnBiomes() {
            return this.biomesToSpawnIn;
        }

        @Override
        public Biome getBiomeAtCoords(int par1, int par2) {
            return this.biomeCache.func_180284_a(par1, par2, null);
        }

        @Override
        public Biome[] getBiomesForGeneration(Biome[] par1ArrayOfBiome, int par2, int par3, int par4, int par5) {
            IntCache.func_76446_a();
            if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < par4 * par5) {
                par1ArrayOfBiome = new Biome[par4 * par5];
            }
            int[] ai = this.genBiomes.func_75904_a(par2, par3, par4, par5);
            for (int i = 0; i < par4 * par5; ++i) {
                par1ArrayOfBiome[i] = Biome.func_150568_d((int)ai[i]);
            }
            return par1ArrayOfBiome;
        }

        @Override
        public Biome[] getBiomesAtCoords(Biome[] par1ArrayOfBiome, int par2, int par3, int par4, int par5, boolean par6) {
            IntCache.func_76446_a();
            if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < par4 * par5) {
                par1ArrayOfBiome = new Biome[par4 * par5];
            }
            if (par6 && par4 == 16 && par5 == 16 && (par2 & 0xF) == 0 && (par3 & 0xF) == 0) {
                Biome[] aBiome = this.biomeCache.func_76839_e(par2, par3);
                System.arraycopy(aBiome, 0, par1ArrayOfBiome, 0, par4 * par5);
                return par1ArrayOfBiome;
            }
            int[] ai = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
            for (int i = 0; i < par4 * par5; ++i) {
                par1ArrayOfBiome[i] = Biome.func_150568_d((int)ai[i]);
            }
            return par1ArrayOfBiome;
        }

        @Override
        public void cleanupCache() {
            this.biomeCache.func_76838_a();
        }

        private GenLayer[] computeGenLayers(long par0, WorldType par2WorldType) {
            GenLayerIsland obj = new GenLayerIsland(1L);
            GenLayerIsland obj1 = obj = new GenLayerFuzzyZoom(2000L, (GenLayer)obj);
            obj1 = GenLayerZoomMyst.func_35515_a(1000L, (GenLayer)obj1, 0);
            obj1 = GenLayerZoomMyst.func_35515_a(1000L, (GenLayer)obj1, this.zoomscale + 1);
            obj1 = new GenLayerSmooth(1000L, (GenLayer)obj1);
            Object obj2 = obj;
            obj2 = GenLayerZoomMyst.func_35515_a(1000L, (GenLayer)obj2, 0);
            obj2 = new GenLayerBiomeMyst(200L, (GenLayer)obj2, par2WorldType, this.allowedBiomes);
            obj2 = GenLayerZoomMyst.func_35515_a(1000L, (GenLayer)obj2, 2);
            for (int i = 0; i < this.zoomscale; ++i) {
                obj2 = new GenLayerZoomMyst(1000 + i, (GenLayer)obj2);
            }
            obj2 = new GenLayerSmooth(1000L, (GenLayer)obj2);
            GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)obj2);
            obj2.func_75905_a(par0);
            genlayervoronoizoom.func_75905_a(par0);
            return new GenLayer[]{obj2, genlayervoronoizoom};
        }
    }
}

