/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.modifiers;

import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class SymbolBlock
extends SymbolBase {
    private BlockDescriptor blockDescriptor;
    private String unlocalizedBlockName;

    public SymbolBlock(BlockDescriptor block, String word) {
        super(SymbolBlock.getSymbolIdentifier(block.blockstate));
        this.blockDescriptor = block;
        this.setWords(new String[]{"Transform", "Constraint", word, this.identifier});
        this.unlocalizedBlockName = SymbolBlock.getUnlocalizedName(block.blockstate);
    }

    public static String getSymbolIdentifier(IBlockState blockstate) {
        return "ModMat_" + SymbolBlock.getBlockStateKey(blockstate);
    }

    public static String getBlockStateKey(IBlockState blockstate) {
        return blockstate.func_177230_c().getRegistryName().toString() + "_" + blockstate.func_177230_c().func_176201_c(blockstate);
    }

    private static String getUnlocalizedName(IBlockState blockstate) {
        Item i;
        ItemStack attempt = ItemStack.field_190927_a;
        try {
            attempt = blockstate.func_177230_c().getPickBlock(blockstate, null, null, BlockPos.field_177992_a, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (attempt.func_190926_b() && (i = Item.func_150898_a((Block)blockstate.func_177230_c())) != Items.field_190931_a) {
            int meta = blockstate.func_177230_c().func_176201_c(blockstate);
            attempt = new ItemStack(i, 1, meta);
        }
        String name = attempt.func_190926_b() ? blockstate.func_177230_c().func_149739_a() : attempt.func_77977_a();
        return name;
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        ModifierUtils.pushBlock(controller, this.blockDescriptor);
    }

    @Override
    public String generateLocalizedName() {
        String blockName = I18n.func_135052_a((String)(this.unlocalizedBlockName + ".name"), (Object[])new Object[0]);
        if (blockName.endsWith(" Block")) {
            blockName = blockName.substring(0, blockName.length() - " Block".length()).trim();
        }
        return I18n.func_135052_a((String)"myst.symbol.block.wrapper", (Object[])new Object[]{blockName});
    }
}

