/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.page;

import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public abstract class Page {
    public static void setQuality(@Nonnull ItemStack page, String trait, int quality) {
        Page.getQualityStruct(page).func_74768_a(trait, quality);
    }

    public static int getTotalQuality(@Nonnull ItemStack page) {
        NBTTagCompound compound = Page.getQualityStruct(page);
        int sum = 0;
        for (String tagname : compound.func_150296_c()) {
            sum += compound.func_74762_e(tagname);
        }
        return sum;
    }

    @Nullable
    public static Integer getQuality(@Nonnull ItemStack page, String trait) {
        NBTTagCompound data = Page.getQualityStruct(page);
        if (data.func_74764_b(trait)) {
            return data.func_74762_e(trait);
        }
        return null;
    }

    @Nonnull
    private static NBTTagCompound getData(@Nonnull ItemStack item) {
        if (item.func_190926_b()) {
            return new NBTTagCompound();
        }
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            item.func_77982_d(tag);
        }
        return tag;
    }

    @Nonnull
    private static NBTTagCompound getQualityStruct(@Nonnull ItemStack page) {
        NBTTagCompound data = Page.getData(page);
        if (!data.func_74764_b("Quality")) {
            data.func_74782_a("Quality", (NBTBase)new NBTTagCompound());
        }
        return data.func_74775_l("Quality");
    }

    public static boolean isBlank(@Nonnull ItemStack page) {
        return !Page.isLinkPanel(page) && Page.getSymbol(page) == null;
    }

    public static boolean isLinkPanel(@Nonnull ItemStack page) {
        return Page.getData(page).func_74764_b("linkpanel");
    }

    public static void makeLinkPanel(@Nonnull ItemStack page) {
        NBTTagCompound data;
        if (page.func_190926_b()) {
            return;
        }
        if (page.func_77978_p() == null) {
            page.func_77982_d(Page.createDefault());
        }
        if (!(data = Page.getData(page)).func_74764_b("linkpanel")) {
            data.func_74782_a("linkpanel", (NBTBase)new NBTTagCompound());
        }
    }

    public static void addLinkProperty(@Nonnull ItemStack page, String linkproperty) {
        NBTTagCompound data;
        if (page.func_190926_b()) {
            return;
        }
        if (page.func_77978_p() == null) {
            page.func_77982_d(Page.createDefault());
        }
        if (!(data = Page.getData(page)).func_74764_b("linkpanel")) {
            data.func_74782_a("linkpanel", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound linkpanel = data.func_74775_l("linkpanel");
        NBTTagList list = linkpanel.func_150295_c("properties", 8);
        list.func_74742_a((NBTBase)new NBTTagString(linkproperty));
        linkpanel.func_74782_a("properties", (NBTBase)list);
    }

    @Nullable
    public static Collection<String> getLinkProperties(@Nonnull ItemStack page) {
        if (page.func_190926_b() || page.func_77978_p() == null) {
            return null;
        }
        NBTTagCompound data = Page.getData(page);
        if (!data.func_74764_b("linkpanel")) {
            return null;
        }
        NBTTagCompound linkpanel = data.func_74775_l("linkpanel");
        return NBTUtils.readStringCollection(linkpanel.func_150295_c("properties", 8), new ArrayList());
    }

    public static void applyLinkPanel(@Nonnull ItemStack linkpanel, @Nonnull ItemStack linkingitem) {
        Collection<String> properties = Page.getLinkProperties(linkpanel);
        if (properties == null) {
            return;
        }
        for (String property : properties) {
            LinkOptions.setFlag(linkingitem.func_77978_p(), property, true);
        }
    }

    public static void setSymbol(@Nonnull ItemStack page, String symbol2) {
        if (page.func_190926_b() || page.func_77978_p() == null) {
            return;
        }
        NBTTagCompound data = Page.getData(page);
        if (symbol2 == null) {
            data.func_82580_o("symbol");
        } else {
            data.func_74778_a("symbol", symbol2);
        }
    }

    @Nullable
    public static String getSymbol(@Nonnull ItemStack page) {
        if (page.func_190926_b() || page.func_77978_p() == null) {
            return null;
        }
        NBTTagCompound data = Page.getData(page);
        String symbol2 = data.func_74779_i("symbol");
        if (symbol2.isEmpty()) {
            symbol2 = null;
        }
        return symbol2;
    }

    public static void getTooltip(ItemStack page, List<String> list) {
        Collection<String> properties;
        if (Page.isLinkPanel(page) && (properties = Page.getLinkProperties(page)) != null && properties.size() > 0) {
            for (String property : properties) {
                list.add(InkEffects.getLocalizedName(property));
            }
        }
    }

    @Nonnull
    public static NBTTagCompound createDefault() {
        return new NBTTagCompound();
    }

    @Nonnull
    public static ItemStack createPage() {
        ItemStack page = new ItemStack(ModItems.page, 1, 0);
        page.func_77982_d(Page.createDefault());
        return page;
    }

    @Nonnull
    public static ItemStack createLinkPage() {
        ItemStack page = new ItemStack(ModItems.page, 1, 0);
        page.func_77982_d(Page.createDefault());
        Page.makeLinkPanel(page);
        return page;
    }

    @Nonnull
    public static ItemStack createLinkPage(String property) {
        ItemStack page = new ItemStack(ModItems.page, 1, 0);
        page.func_77982_d(Page.createDefault());
        Page.addLinkProperty(page, property);
        return page;
    }

    @Nonnull
    public static ItemStack createSymbolPage(String symbol2) {
        ItemStack page = new ItemStack(ModItems.page, 1, 0);
        page.func_77982_d(Page.createDefault());
        Page.setSymbol(page, symbol2);
        return page;
    }

    @Nonnull
    public static ItemStack createPage(NBTTagCompound pagedata) {
        ItemStack page = new ItemStack(ModItems.page, 1, 0);
        page.func_77982_d(pagedata);
        return page;
    }
}

