/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.linking;

import com.xcompwiz.mystcraft.api.event.LinkEvent;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.data.ModAchievements;
import com.xcompwiz.mystcraft.entity.EntityLinkbook;
import com.xcompwiz.mystcraft.item.ItemLinkbook;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LinkListenerBasic {
    @SubscribeEvent
    public void isLinkPermitted(LinkEvent.LinkEventAllow event) {
        Entity entity = event.entity;
        World world = event.origin;
        ILinkInfo info = event.info;
        if (world.field_72995_K) {
            return;
        }
        Integer dimid = info.getDimensionUID();
        if (dimid == null) {
            event.setCanceled(true);
        } else if (entity.field_70128_L || entity.field_70170_p != world || entity.func_184207_aI()) {
            event.setCanceled(true);
        } else if (entity.field_70170_p.field_73011_w.getDimension() == dimid.intValue() && !info.getFlag("Intra Linking")) {
            event.setCanceled(true);
        } else if (DimensionUtils.isDimensionDead(dimid)) {
            event.setCanceled(true);
        } else if (!DimensionUtils.checkDimensionUUID(dimid, info.getTargetUUID())) {
            event.setCanceled(true);
        } else if (info.getFlag("Disarm")) {
            if (entity instanceof EntityItem) {
                event.setCanceled(true);
            } else if (entity instanceof EntityLinkbook) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleAlterEvent(LinkEvent.LinkEventAlter event) {
        Entity entity = event.entity;
        World world = event.origin;
        World newworld = event.destination;
        ILinkInfo info = event.info;
        if (info.getFlag("Relative")) {
            BlockPos origin = world.func_175694_M();
            float dx = (int)(entity.field_70165_t - (double)origin.func_177958_n());
            float dy = (int)(entity.field_70163_u - (double)origin.func_177956_o());
            float dz = (int)(entity.field_70161_v - (double)origin.func_177952_p());
            event.spawn = newworld.func_175694_M();
            event.spawn = event.spawn.func_177963_a((double)dx, (double)dy, (double)dz);
        }
    }

    @SubscribeEvent
    public void onLinkStart(LinkEvent.LinkEventStart event) {
        Entity entity = event.entity;
        ILinkInfo info = event.info;
        if (info.getFlag("Disarm")) {
            ContainerHorseChest chest;
            if (entity instanceof EntityPlayer) {
                LinkListenerBasic.ejectInventory(entity.field_70170_p, (IInventory)((EntityPlayer)entity).field_71071_by, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
            if (entity instanceof IInventory) {
                LinkListenerBasic.ejectInventory(entity.field_70170_p, (IInventory)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            }
            if (entity instanceof AbstractHorse && (chest = (ContainerHorseChest)ObfuscationReflectionHelper.getPrivateValue(AbstractHorse.class, (Object)((AbstractHorse)entity), (String[])new String[]{"horseChest", "field_110296_bG"})) != null) {
                for (int i = 0; i < chest.func_70302_i_(); ++i) {
                    ItemStack itemstack = chest.func_70301_a(i);
                    if (itemstack.func_190926_b()) continue;
                    entity.func_70099_a(itemstack, 0.0f);
                    chest.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
            if (entity instanceof EntityLiving) {
                LinkListenerBasic.dropEquipment((EntityLiving)entity, new Random());
            }
        }
    }

    @SubscribeEvent
    public void onExitWorld(LinkEvent.LinkEventExitWorld event) {
        Entity entity = event.entity;
        ILinkInfo info = event.info;
        LinkListenerBasic.handleMomentum(entity, info);
    }

    @SubscribeEvent
    public void onEnterWorld(LinkEvent.LinkEventEnterWorld event) {
        Entity entity = event.entity;
        World world = event.destination;
        if (world.field_73011_w instanceof WorldProviderMyst && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                if (itemstack.func_190926_b() || !(itemstack.func_77973_b() instanceof ItemLinkbook)) continue;
                return;
            }
            player.func_71064_a((StatBase)ModAchievements.quinn, 1);
        }
    }

    @SubscribeEvent
    public void onLinkEnd(LinkEvent.LinkEventEnd event) {
        Entity entity = event.entity;
        World world = event.destination;
        ILinkInfo info = event.info;
        BlockPos spawn = info.getSpawn();
        if (spawn != null && info.getFlag("Generate Platform") && world.func_175623_d(spawn.func_177977_b()) && world.func_175623_d(spawn.func_177979_c(2))) {
            world.func_175656_a(spawn.func_177977_b(), Blocks.field_150348_b.func_176223_P());
        }
        if (entity instanceof EntityMinecart) {
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
        }
    }

    private static void handleMomentum(Entity entity, ILinkInfo info) {
        if (!info.getFlag("Maintain Momentum")) {
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            entity.field_70143_R = 0.0f;
        } else {
            float yaw = info.getSpawnYaw();
            float rotationYaw = (float)(Math.atan2(entity.field_70159_w, entity.field_70179_y) * 180.0 / Math.PI);
            double cos = Math.cos(Math.toRadians(-rotationYaw));
            double sin = Math.sin(Math.toRadians(-rotationYaw));
            double tempXmotion = cos * entity.field_70159_w - sin * entity.field_70179_y;
            double tempZmotion = sin * entity.field_70159_w + cos * entity.field_70179_y;
            entity.field_70159_w = tempXmotion;
            entity.field_70179_y = tempZmotion;
            cos = Math.cos(Math.toRadians(yaw));
            sin = Math.sin(Math.toRadians(yaw));
            tempXmotion = cos * entity.field_70159_w - sin * entity.field_70179_y;
            tempZmotion = sin * entity.field_70159_w + cos * entity.field_70179_y;
            entity.field_70159_w = tempXmotion;
            entity.field_70179_y = tempZmotion;
        }
        entity.field_70181_x += 0.2;
    }

    private static void ejectInventory(World worldObj, IInventory inventory, double par2, double par3, double par4) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            inventory.func_70299_a(i, ItemStack.field_190927_a);
            if (itemstack.func_190926_b()) continue;
            float f = worldObj.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = worldObj.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = worldObj.field_73012_v.nextFloat() * 0.8f + 0.1f;
            while (itemstack.func_190916_E() > 0) {
                int j = worldObj.field_73012_v.nextInt(21) + 10;
                if (j > itemstack.func_190916_E()) {
                    j = itemstack.func_190916_E();
                }
                ItemStack splitstack = itemstack.func_77979_a(j);
                EntityItem entityitem = new EntityItem(worldObj, par2 + (double)f, par3 + (double)f1, par4 + (double)f2, splitstack);
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)worldObj.field_73012_v.nextGaussian() * f3;
                entityitem.field_70181_x = (float)worldObj.field_73012_v.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)worldObj.field_73012_v.nextGaussian() * f3;
                worldObj.func_72838_d((Entity)entityitem);
            }
        }
    }

    private static void dropEquipment(EntityLiving entity, Random rand) {
        float[] handChances = (float[])ObfuscationReflectionHelper.getPrivateValue(EntityLiving.class, (Object)entity, (String[])new String[]{"inventoryHandsDropChances", "field_82174_bp"});
        float[] armorChances = (float[])ObfuscationReflectionHelper.getPrivateValue(EntityLiving.class, (Object)entity, (String[])new String[]{"inventoryArmorDropChances", "field_184655_bs"});
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = entity.func_184582_a(slot);
            entity.func_184201_a(slot, ItemStack.field_190927_a);
            float chance = 0.0f;
            switch (slot.func_188453_a()) {
                case HAND: {
                    chance = handChances[slot.func_188454_b()];
                    break;
                }
                case ARMOR: {
                    chance = armorChances[slot.func_188454_b()];
                }
            }
            if (stack.func_190926_b() || !(chance > 1.0f) || !(rand.nextFloat() < chance)) continue;
            if (chance <= 1.0f && stack.func_77984_f()) {
                int k = Math.max(stack.func_77958_k() - 25, 1);
                int l = stack.func_77958_k() - rand.nextInt(rand.nextInt(k) + 1);
                if (l > k) {
                    l = k;
                }
                if (l < 1) {
                    l = 1;
                }
                stack.func_77964_b(l);
            }
            entity.func_70099_a(stack, 0.0f);
        }
    }
}

