/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.linking;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.event.LinkEvent;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.linking.LinkListenerManager;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LinkController {
    public static boolean travelEntity(World world, Entity entity, ILinkInfo info) {
        if (world.field_72995_K) {
            return false;
        }
        if (info == null) {
            return false;
        }
        Integer dimension = (info = info.clone()).getDimensionUID();
        if (dimension == null) {
            return false;
        }
        BlockPos spawn = info.getSpawn();
        float yaw = info.getSpawnYaw();
        if (!LinkListenerManager.isLinkPermitted(world, entity, info)) {
            return false;
        }
        MinecraftServer mcServer = Mystcraft.sidedProxy.getMCServer();
        if (mcServer == null || dimension != 0 && !mcServer.func_71255_r()) {
            return false;
        }
        WorldServer newworld = mcServer.func_71218_a(dimension.intValue());
        if (newworld == null) {
            System.err.println("Cannot Link Entity to Dimension: Could not get World for Dimension " + dimension);
            return false;
        }
        if (spawn == null) {
            spawn = newworld.func_175694_M();
            info.setSpawn(spawn);
        }
        LinkEvent.LinkEventAlter event = new LinkEvent.LinkEventAlter(world, (World)newworld, entity, info.clone());
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.spawn != null) {
            spawn = event.spawn;
            info.setSpawn(spawn);
        }
        if (event.rotationYaw != null) {
            yaw = event.rotationYaw.floatValue();
            info.setSpawnYaw(yaw);
        }
        LinkController.teleportEntity((World)newworld, entity, dimension, spawn, yaw, info);
        return true;
    }

    private static Entity teleportEntity(World newworld, Entity entity, int dimension, BlockPos spawn, float yaw, ILinkInfo info) {
        EntityPlayerMP player;
        World origin = entity.func_130014_f_();
        if (!LinkListenerManager.isLinkPermitted(origin, entity, info)) {
            return null;
        }
        if (!ForgeHooks.onTravelToDimension((Entity)entity, (int)dimension)) {
            return null;
        }
        Entity mount = entity.func_184187_bx();
        if (mount != null) {
            entity.func_184210_p();
            mount = LinkController.teleportEntity(newworld, mount, dimension, spawn, yaw, info);
        }
        boolean changingworlds = origin != newworld;
        LinkListenerManager.onLinkStart(origin, entity, info);
        origin.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            player.func_71053_j();
            if (changingworlds) {
                player.field_71093_bK = dimension;
                player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), newworld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                ((WorldServer)origin).func_184164_w().func_72695_c(player);
            }
        }
        if (changingworlds) {
            LinkController.removeEntityFromWorld(origin, entity);
        }
        LinkListenerManager.onExitWorld(entity, info);
        entity.func_70012_b((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5, yaw, entity.field_70125_A);
        ((WorldServer)newworld).func_72863_F().func_186028_c(spawn.func_177958_n() >> 4, spawn.func_177952_p() >> 4);
        while (LinkController.getCollidingWorldGeometry(newworld, entity.func_174813_aQ(), entity).size() != 0) {
            spawn = spawn.func_177984_a();
            entity.func_70107_b((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5);
        }
        if (changingworlds) {
            if (!(entity instanceof EntityPlayer)) {
                origin.func_72900_e(entity);
                entity.field_70128_L = false;
                NBTTagCompound nbttagcompound = entity.func_189511_e(new NBTTagCompound());
                nbttagcompound.func_82580_o("Dimension");
                Entity newEntity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)newworld);
                if (newEntity == null) {
                    LoggerUtils.warn("Failed to reconstruct entity when linking", new Object[0]);
                    return null;
                }
                newEntity.func_70020_e(nbttagcompound);
                newEntity.field_71088_bW = entity.field_71088_bW;
                entity.field_70128_L = true;
                newEntity.field_71093_bK = newworld.field_73011_w.getDimension();
                boolean flag = newEntity.field_98038_p;
                newEntity.field_98038_p = true;
                newworld.func_72838_d(newEntity);
                newEntity.field_98038_p = flag;
                entity = newEntity;
            } else {
                entity.func_70634_a((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5);
                newworld.func_72838_d(entity);
            }
            entity.func_70029_a(newworld);
        }
        entity.func_70012_b((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5, yaw, entity.field_70125_A);
        LinkListenerManager.onEnterWorld(origin, newworld, entity, info);
        newworld.func_72866_a(entity, false);
        entity.func_70012_b((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5, yaw, entity.field_70125_A);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            if (changingworlds) {
                player.func_71121_q().func_184164_w().func_72683_a(player);
                player.func_71121_q().func_72863_F().func_186025_d((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
            }
            player.field_71135_a.func_147364_a((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
        }
        newworld.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP && changingworlds) {
            player = (EntityPlayerMP)entity;
            player.field_71134_c.func_73080_a((WorldServer)newworld);
            player.field_71133_b.func_184103_al().func_72354_b(player, (WorldServer)newworld);
            player.field_71133_b.func_184103_al().func_72385_f(player);
            for (PotionEffect effect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), effect));
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        }
        entity.func_70012_b((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o(), (double)spawn.func_177952_p() + 0.5, yaw, entity.field_70125_A);
        LinkListenerManager.onLinkEnd(origin, newworld, entity, info);
        if (mount != null) {
            if (entity instanceof EntityPlayerMP) {
                newworld.func_72866_a(entity, true);
            }
            entity.func_184220_m(mount);
        }
        return entity;
    }

    private static void removeEntityFromWorld(World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71053_j();
            world.field_73010_i.remove(player);
            world.func_72854_c();
            int i = entity.field_70176_ah;
            int j = entity.field_70164_aj;
            if (entity.field_70175_ag && world.func_72863_F().func_191062_e(i, j)) {
                world.func_72964_e(i, j).func_76622_b(entity);
                world.func_72964_e(i, j).func_177427_f(true);
            }
            world.field_72996_f.remove(entity);
            world.func_72847_b(entity);
        }
    }

    private static List<AxisAlignedBB> getCollidingWorldGeometry(World world, AxisAlignedBB axisalignedbb, Entity entity) {
        ArrayList<AxisAlignedBB> collidingBoundingBoxes = new ArrayList<AxisAlignedBB>();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!world.func_175667_e(new BlockPos(k1, 64, l1))) continue;
                for (int i2 = k - 1; i2 < l; ++i2) {
                    BlockPos pos = new BlockPos(l1, i2, l1);
                    IBlockState state = world.func_180495_p(pos);
                    state.func_185908_a(world, pos, axisalignedbb, collidingBoundingBoxes, entity, true);
                }
            }
        }
        return collidingBoundingBoxes;
    }
}

