/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.tileentity.IOInventory;
import com.xcompwiz.mystcraft.tileentity.InventoryFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class SlotFiltered
extends SlotItemHandler {
    private int slotIndex;
    private InventoryFilter filter;
    private Integer maxstack;

    public SlotFiltered(IItemHandlerModifiable inventory, @Nullable InventoryFilter filter, int slot, int x, int y) {
        super((IItemHandler)inventory, slot, x, y);
        this.filter = filter;
        this.slotIndex = slot;
    }

    @Nonnull
    public ItemStack func_75211_c() {
        return this.getItemHandler().getStackInSlot(this.slotIndex);
    }

    public void func_75215_d(@Nonnull ItemStack stack) {
        ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.slotIndex, stack);
        this.func_75218_e();
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        if (this.getItemHandler() instanceof IOInventory) {
            boolean allowed = ((IOInventory)this.getItemHandler()).allowAnySlots;
            ((IOInventory)this.getItemHandler()).allowAnySlots = true;
            boolean take = !this.getItemHandler().extractItem(this.slotIndex, 1, true).func_190926_b();
            ((IOInventory)this.getItemHandler()).allowAnySlots = allowed;
            return take;
        }
        return !this.getItemHandler().extractItem(this.slotIndex, 1, true).func_190926_b();
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        if (this.getItemHandler() instanceof IOInventory) {
            boolean allowed = ((IOInventory)this.getItemHandler()).allowAnySlots;
            ((IOInventory)this.getItemHandler()).allowAnySlots = true;
            ItemStack take = this.getItemHandler().extractItem(this.slotIndex, amount, false);
            ((IOInventory)this.getItemHandler()).allowAnySlots = allowed;
            return take;
        }
        return this.getItemHandler().extractItem(this.slotIndex, amount, false);
    }

    public int func_178170_b(@Nonnull ItemStack stack) {
        if (this.getItemHandler() instanceof IOInventory) {
            boolean allowed = ((IOInventory)this.getItemHandler()).allowAnySlots;
            ((IOInventory)this.getItemHandler()).allowAnySlots = true;
            int stackLimit = this.ovrGetItemStackLimit(stack);
            ((IOInventory)this.getItemHandler()).allowAnySlots = allowed;
            return stackLimit;
        }
        return this.ovrGetItemStackLimit(stack);
    }

    private int ovrGetItemStackLimit(@Nonnull ItemStack stack) {
        ItemStack maxAdd = stack.func_77946_l();
        int maxInput = stack.func_77976_d();
        maxAdd.func_190920_e(maxInput);
        IItemHandler handler = this.getItemHandler();
        ItemStack currentStack = handler.getStackInSlot(this.slotIndex);
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handlerModifiable = (IItemHandlerModifiable)handler;
            handlerModifiable.setStackInSlot(this.slotIndex, ItemStack.field_190927_a);
            ItemStack remainder = handlerModifiable.insertItem(this.slotIndex, maxAdd, true);
            handlerModifiable.setStackInSlot(this.slotIndex, currentStack);
            return maxInput - remainder.func_190916_E();
        }
        ItemStack remainder = handler.insertItem(this.slotIndex, maxAdd, true);
        int current = currentStack.func_190916_E();
        int added = maxInput - remainder.func_190916_E();
        return current + added;
    }

    public boolean func_75214_a(@Nonnull ItemStack itemstack) {
        return this.filter == null || this.filter.canAcceptItem(this.slotIndex, itemstack);
    }

    public int func_75219_a() {
        if (this.maxstack != null) {
            return this.maxstack;
        }
        return this.getItemHandler().getSlotLimit(this.slotIndex);
    }

    public void setSlotStackLimit(int max) {
        this.maxstack = max;
    }

    public void setSlotIndex(int i) {
        this.slotIndex = i;
    }
}

