/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.api.item.IItemPageProvider;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.entity.EntityLinkbook;
import com.xcompwiz.mystcraft.inventory.ContainerBase;
import com.xcompwiz.mystcraft.inventory.IBookContainer;
import com.xcompwiz.mystcraft.inventory.SlotCollection;
import com.xcompwiz.mystcraft.inventory.SlotFiltered;
import com.xcompwiz.mystcraft.inventory.TargetInventory;
import com.xcompwiz.mystcraft.item.ItemAgebook;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.item.LinkItemUtils;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.linking.LinkListenerManager;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketGuiMessage;
import com.xcompwiz.mystcraft.tileentity.IOInventory;
import com.xcompwiz.mystcraft.tileentity.InventoryFilter;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookRotateable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ContainerBook
extends ContainerBase
implements IGuiMessageHandler,
IBookContainer {
    private EntityLinkbook linkbook;
    private TileEntityBookRotateable bookTile;
    private Integer slot;
    private InventoryPlayer inventoryplayer;
    @Nonnull
    private ItemStack currentpage = ItemStack.field_190927_a;
    private int pagecount = 0;
    private int currentpageIndex = 0;
    private ILinkInfo cached_linkinfo;
    private Boolean cached_permitted;

    public ContainerBook(InventoryPlayer inventoryplayer, EntityLinkbook linkbook) {
        this.linkbook = linkbook;
        this.inventoryplayer = inventoryplayer;
        this.updateSlots();
    }

    public ContainerBook(InventoryPlayer inventoryplayer, TileEntityBookRotateable tile) {
        this.bookTile = tile;
        this.inventoryplayer = inventoryplayer;
        this.updateSlots();
    }

    public ContainerBook(InventoryPlayer inventoryplayer, int slot) {
        this.slot = slot;
        this.inventoryplayer = inventoryplayer;
        this.updateSlots();
    }

    @Override
    @Nonnull
    public ItemStack getBook() {
        ItemStack itemstack;
        if (this.linkbook != null) {
            ItemStack itemstack2 = this.linkbook.getBook();
            if (!itemstack2.func_190926_b() && itemstack2.func_77973_b() instanceof ItemLinking) {
                return itemstack2;
            }
        } else if (this.bookTile != null) {
            ItemStack book = this.bookTile.getBook();
            if (!book.func_190926_b() && book.func_77973_b() instanceof ItemLinking) {
                return book;
            }
        } else if (this.slot != null && !(itemstack = this.inventoryplayer.func_70301_a(this.slot.intValue())).func_190926_b() && itemstack.func_77973_b() instanceof ItemLinking) {
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setCurrentPageIndex(int index) {
        List<ItemStack> pagelist;
        this.currentpage = ItemStack.field_190927_a;
        this.currentpageIndex = 0;
        if (index < 0) {
            index = 0;
        }
        if ((pagelist = this.getPageList()) != null && index >= pagelist.size()) {
            index = pagelist.size();
        }
        if (pagelist != null && index < pagelist.size()) {
            this.pagecount = pagelist.size();
            this.currentpage = pagelist.get(index);
        }
        this.currentpageIndex = index;
    }

    @Override
    @Nonnull
    public ItemStack getCurrentPage() {
        if (this.currentpage.func_190926_b()) {
            this.setCurrentPageIndex(this.currentpageIndex);
        }
        return this.currentpage;
    }

    @Override
    public int getCurrentPageIndex() {
        return this.currentpageIndex;
    }

    @Nullable
    private List<ItemStack> getPageList() {
        ItemStack book = this.getBook();
        if (book.func_190926_b()) {
            return null;
        }
        if (book.func_77973_b() instanceof IItemPageProvider) {
            return ((IItemPageProvider)book.func_77973_b()).getPageList(this.inventoryplayer.field_70458_d, book);
        }
        return null;
    }

    @Override
    public int getPageCount() {
        return this.pagecount;
    }

    @Override
    public boolean isTargetWorldVisited() {
        return DimensionUtils.isDimensionVisited(LinkItemUtils.getTargetDimension(this.getBook()));
    }

    @Override
    public boolean hasBookSlot() {
        return this.field_75151_b.size() > 0;
    }

    public int getInventorySize() {
        if (this.linkbook != null && !this.linkbook.field_70128_L) {
            return 1;
        }
        if (this.bookTile != null) {
            return 1;
        }
        return 0;
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= this.field_75151_b.size()) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void updateSlots() {
        if (this.linkbook != null || this.bookTile != null) {
            ItemStack book = this.getBook();
            if (this.currentpageIndex > 0) {
                this.field_75151_b.clear();
                this.field_75153_a.clear();
            } else if (!book.func_190926_b() && this.field_75151_b.size() != 1) {
                this.field_75151_b.clear();
                this.field_75153_a.clear();
                IItemHandlerModifiable other = this.getCurrentOtherInventory();
                this.func_75146_a((Slot)new SlotFiltered(other, other instanceof InventoryFilter ? (InventoryFilter)other : null, 0, 41, 21));
            } else if (book.func_190926_b() && this.getCurrentOtherInventorySize() == 1 && this.field_75151_b.size() != 37) {
                this.field_75151_b.clear();
                this.field_75153_a.clear();
                this.addInventorySlots();
                IItemHandlerModifiable other = this.getCurrentOtherInventory();
                this.func_75146_a((Slot)new SlotFiltered(other, other instanceof InventoryFilter ? (InventoryFilter)other : this.bookTile, 0, 80, 35));
            } else if (book.func_190926_b() && this.getCurrentOtherInventorySize() == 0 && this.field_75151_b.size() != 36) {
                this.field_75151_b.clear();
                this.field_75153_a.clear();
                this.addInventorySlots();
            }
        }
    }

    private void addInventorySlots() {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.inventoryplayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryplayer, i, 8 + i * 18, 142));
        }
    }

    public void func_75142_b() {
        ArrayList<MPacketGuiMessage> packets = new ArrayList<MPacketGuiMessage>();
        for (int slotId = 0; slotId < this.field_75151_b.size(); ++slotId) {
            ItemStack actual = ((Slot)this.field_75151_b.get(slotId)).func_75211_c();
            ItemStack stored = (ItemStack)this.field_75153_a.get(slotId);
            if (ItemStack.func_77989_b((ItemStack)stored, (ItemStack)actual)) continue;
            if (slotId == 0) {
                this.cached_linkinfo = null;
                this.cached_permitted = null;
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74768_a("SetCurrentPage", this.currentpageIndex);
                packets.add(new MPacketGuiMessage(this.field_75152_c, nBTTagCompound));
            }
            stored = actual.func_190926_b() ? ItemStack.field_190927_a : actual.func_77946_l();
            this.field_75153_a.set(slotId, (Object)stored);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((Container)this, slotId, stored);
            }
        }
        if (this.cached_permitted == null) {
            this.cached_permitted = this.checkLinkPermitted();
            if (this.cached_permitted != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74757_a("LinkPermitted", this.cached_permitted.booleanValue());
                packets.add(new MPacketGuiMessage(this.field_75152_c, nbttagcompound));
            }
        }
        if (packets.size() > 0) {
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                for (IMessage iMessage : packets) {
                    MystcraftPacketHandler.CHANNEL.sendTo(iMessage, (EntityPlayerMP)listener);
                }
            }
        }
    }

    public void func_75137_b(int i, int j) {
    }

    public boolean func_75145_c(@Nonnull EntityPlayer entityplayer) {
        this.updateSlots();
        if (this.linkbook != null && !this.linkbook.field_70128_L) {
            return !this.getBook().func_190926_b();
        }
        return true;
    }

    public Slot func_75147_a(@Nonnull IInventory par1IInventory, int par2) {
        for (Slot slot : this.field_75151_b) {
            if (!slot.func_75217_a(par1IInventory, par2)) continue;
            return slot;
        }
        return new Slot((IInventory)this.inventoryplayer, this.inventoryplayer.field_70461_c, 0, 0);
    }

    public Slot func_75139_a(int par1) {
        if (par1 >= this.field_75151_b.size()) {
            par1 = 0;
        }
        if (par1 < this.field_75151_b.size()) {
            return (Slot)this.field_75151_b.get(par1);
        }
        return new Slot((IInventory)this.inventoryplayer, this.inventoryplayer.field_70461_c, 0, 0);
    }

    @Override
    public void processMessage(@Nonnull EntityPlayer player, @Nonnull NBTTagCompound data) {
        if (data.func_74764_b("LinkPermitted")) {
            this.cached_permitted = data.func_74767_n("LinkPermitted");
        }
        if (data.func_74764_b("SetCurrentPage")) {
            this.setCurrentPageIndex(data.func_74762_e("SetCurrentPage"));
        }
        if (data.func_74764_b("Link")) {
            ItemStack itemstack;
            if (this.bookTile != null) {
                this.bookTile.link((Entity)player);
            } else if (this.linkbook != null) {
                this.linkbook.linkEntity((Entity)player);
            } else if (this.slot != null && (itemstack = this.inventoryplayer.func_70301_a(this.slot.intValue())).func_77973_b() instanceof ItemLinking) {
                ((ItemLinking)itemstack.func_77973_b()).activate(itemstack, player.field_70170_p, (Entity)player);
            }
        }
    }

    @Override
    public ILinkInfo getLinkInfo() {
        ItemStack book = this.getBook();
        if (book.func_190926_b() || !(book.func_77973_b() instanceof ItemLinking)) {
            this.cached_linkinfo = null;
            return null;
        }
        if (this.cached_linkinfo == null) {
            this.cached_linkinfo = ((ItemLinking)book.func_77973_b()).getLinkInfo(book);
        }
        return this.cached_linkinfo;
    }

    @Override
    public boolean isLinkPermitted() {
        ILinkInfo linkinfo = this.getLinkInfo();
        if (linkinfo == null) {
            this.cached_permitted = null;
        }
        if (this.cached_permitted == null) {
            return false;
        }
        return this.cached_permitted;
    }

    private boolean checkLinkPermitted() {
        ILinkInfo linkinfo = this.getLinkInfo();
        if (linkinfo == null) {
            return false;
        }
        if (ItemAgebook.isNewAgebook(this.getBook())) {
            return true;
        }
        return LinkListenerManager.isLinkPermitted(this.inventoryplayer.field_70458_d.field_70170_p, (Entity)this.inventoryplayer.field_70458_d, linkinfo);
    }

    @Nullable
    private IItemHandlerModifiable getCurrentOtherInventory() {
        if (this.linkbook != null && !this.linkbook.field_70128_L) {
            return this.linkbook.createBookWrapper();
        }
        if (this.bookTile != null) {
            return (IItemHandlerModifiable)this.bookTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        }
        return null;
    }

    private int getCurrentOtherInventorySize() {
        IOInventory inv;
        if (this.linkbook != null && !this.linkbook.field_70128_L) {
            return 1;
        }
        if (this.bookTile != null && (inv = (IOInventory)this.bookTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null && inv.getSlots() > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int i) {
        ItemStack clone = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack original = slot.func_75211_c();
            clone = original.func_77946_l();
            ArrayList<SlotCollection> collections = new ArrayList<SlotCollection>();
            SlotCollection internal = null;
            ItemStack book = this.getBook();
            if (!book.func_190926_b()) {
                IOInventory inv;
                if (this.linkbook != null && !this.linkbook.field_70128_L) {
                    internal = new SlotCollection(this, 0, 1);
                    internal.pushTargetFront(new TargetInventory(this.inventoryplayer));
                    collections.add(internal);
                } else if (this.bookTile != null && (inv = (IOInventory)this.bookTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null && inv.getSlots() > 0) {
                    internal = new SlotCollection(this, inv.getSlots() - 1, inv.getSlots());
                    internal.pushTargetFront(new TargetInventory(this.inventoryplayer));
                    collections.add(internal);
                }
            }
            if (book.func_190926_b()) {
                SlotCollection maininv = new SlotCollection(this, 0, 27);
                SlotCollection hotbar = new SlotCollection(this, 27, 36);
                maininv.pushTargetFront(hotbar);
                hotbar.pushTargetFront(maininv);
                if (internal != null) {
                    internal.pushTargetFront(maininv);
                    internal.pushTargetFront(hotbar);
                    maininv.pushTargetFront(internal);
                    hotbar.pushTargetFront(internal);
                }
                collections.add(maininv);
                collections.add(hotbar);
            }
            for (SlotCollection collection : collections) {
                if (!collection.contains(i)) continue;
                collection.onShiftClick(original);
                break;
            }
            if (original.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (original.func_190916_E() != clone.func_190916_E()) {
                slot.func_190901_a(player, original);
            } else {
                return ItemStack.field_190927_a;
            }
        }
        return clone;
    }

    @Override
    public String getBookTitle() {
        ItemStack book = this.getBook();
        if (book.func_190926_b() || !(book.func_77973_b() instanceof ItemLinking)) {
            return "";
        }
        return ((ItemLinking)book.func_77973_b()).getTitle(book);
    }

    @Override
    public Collection<String> getBookAuthors() {
        ItemStack book = this.getBook();
        if (book.func_190926_b() || !(book.func_77973_b() instanceof ItemLinking)) {
            return Collections.emptySet();
        }
        return ((ItemLinking)book.func_77973_b()).getAuthors(book);
    }

    public static class Messages {
        public static final String LinkPermitted = "LinkPermitted";
        public static final String SetCurrentPage = "SetCurrentPage";
        public static final String Link = "Link";
    }
}

