/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability.bonus;

import com.google.common.collect.ObjectArrays;
import com.xcompwiz.mystcraft.instability.bonus.InstabilityBonusManager;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import java.lang.reflect.Constructor;
import net.minecraft.world.World;

public class BonusProvider
implements InstabilityBonusManager.IInstabilityBonusProvider {
    private Class<? extends InstabilityBonusManager.IInstabilityBonus> bonusclass;
    private Object[] itemCtorArgs;
    private Constructor<? extends InstabilityBonusManager.IInstabilityBonus> itemCtor;

    public BonusProvider(Class<? extends InstabilityBonusManager.IInstabilityBonus> bonusclass, Object ... itemCtorArgs) {
        this.bonusclass = bonusclass;
        this.itemCtorArgs = itemCtorArgs;
        Class[] ctorArgClasses = new Class[itemCtorArgs.length + 2];
        ctorArgClasses[0] = InstabilityBonusManager.class;
        ctorArgClasses[1] = World.class;
        for (int idx = 0; idx < itemCtorArgs.length; ++idx) {
            ctorArgClasses[idx + 2] = itemCtorArgs[idx].getClass();
        }
        try {
            this.itemCtor = bonusclass.getConstructor(ctorArgClasses);
        }
        catch (Exception e) {
            LoggerUtils.error("Caught an exception during instability bonus registration", new Object[0]);
            LoggerUtils.error(e.toString(), new Object[0]);
            throw new RuntimeException("Error when getting constructor for generic instability bonus class " + bonusclass.getCanonicalName(), e);
        }
    }

    @Override
    public void register(InstabilityBonusManager bonusmanager, Integer dimId) {
        try {
            Object[] args = this.itemCtorArgs;
            args = ObjectArrays.concat((Object)dimId, (Object[])args);
            args = ObjectArrays.concat((Object)bonusmanager, (Object[])args);
            InstabilityBonusManager.IInstabilityBonus bonus = this.itemCtor.newInstance(args);
            bonusmanager.register(bonus);
        }
        catch (Exception e) {
            LoggerUtils.error("Caught an exception during instability bonus construction usage", new Object[0]);
            throw new RuntimeException("Error when building generic instability bonus handler from class " + this.bonusclass.getCanonicalName() + " with args " + this.itemCtorArgs, e);
        }
    }
}

