/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.imc;

import com.xcompwiz.mystcraft.api.hook.SymbolFactory;
import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.imc.IMCHandler;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCBlockModifier
implements IMCHandler.IMCProcessor {
    @Override
    public void process(FMLInterModComms.IMCMessage message) {
        String thirdword;
        if (!message.isNBTMessage()) {
            return;
        }
        NBTTagCompound nbt = message.getNBTValue();
        Block block = null;
        int metadata = 0;
        if (nbt.func_74764_b("ItemStack")) {
            ItemStack itemstack = new ItemStack(nbt.func_74775_l("ItemStack"));
            if (!(itemstack.func_77973_b() instanceof ItemBlock)) {
                throw new RuntimeException("Itemstacks references used for setting instability factors must extend ItemBlock");
            }
            block = ((ItemBlock)itemstack.func_77973_b()).field_150939_a;
            metadata = itemstack.func_77960_j();
        }
        if (nbt.func_74764_b("BlockName")) {
            String blockname = nbt.func_74779_i("BlockName");
            block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(message.getSender(), blockname));
            if (block == null || block == Blocks.field_150350_a) {
                LoggerUtils.error("Could not find block by name %s belonging to mod [%s] when creating block modifier symbol via IMC message.", blockname, message.getSender());
                return;
            }
        }
        if (block == null) {
            LoggerUtils.error("No block specified when creating block modifier symbol via IMC message from mod [%s].", message.getSender());
            return;
        }
        if (nbt.func_74764_b("Metadata")) {
            metadata = NBTUtils.readNumber(nbt.func_74781_a("Metadata")).intValue();
        }
        if ((thirdword = nbt.func_74779_i("PoemWord")).isEmpty()) {
            LoggerUtils.warn("Poem word not specified for %s:%d belonging to mod [%s] when creating block modifier symbol via IMC message.", block.func_149739_a(), metadata, message.getSender());
        }
        int rank = 1;
        if (nbt.func_74764_b("Rank")) {
            rank = NBTUtils.readNumber(nbt.func_74781_a("Rank")).intValue();
        } else {
            LoggerUtils.warn("Item Ranking not specified for %s:%d belonging to mod [%s] when creating block modifier symbol via IMC message.", block.func_149739_a(), metadata, message.getSender());
        }
        ArrayList<SymbolFactory.CategoryPair> objects = null;
        if (nbt.func_74764_b("Categories")) {
            ArrayList<NBTTagCompound> list = NBTUtils.readTagCompoundCollection(nbt.func_150295_c("Categories", 10), new ArrayList());
            objects = new ArrayList<SymbolFactory.CategoryPair>();
            for (NBTTagCompound cat : list) {
                String catname = cat.func_74779_i("Category");
                int catrank = 1;
                if (cat.func_74764_b("Rank")) {
                    catrank = NBTUtils.readNumber(cat.func_74781_a("Rank")).intValue();
                }
                objects.add(new SymbolFactory.CategoryPair(catname, catrank));
            }
        }
        if (objects == null) {
            LoggerUtils.warn("Block categories not specified for %s:%d belonging to mod [%s] when creating block modifier symbol via IMC message.", block.func_149739_a(), metadata, message.getSender());
        }
        SymbolFactory.CategoryPair[] args = objects != null ? objects.toArray(new SymbolFactory.CategoryPair[0]) : null;
        IAgeSymbol symbol2 = InternalAPI.symbolFact.createSymbol(block.func_176203_a(metadata), thirdword, rank, args);
        if (symbol2 == null) {
            LoggerUtils.warn("[%s] is attempting to create a block modifier symbol for an already registered block.", message.getSender());
        } else {
            InternalAPI.symbol.registerSymbol(symbol2, message.getSender());
        }
    }
}

