/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.entity;

import com.xcompwiz.mystcraft.nbt.NBTUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFallingBlock
extends Entity
implements IEntityAdditionalSpawnData {
    protected static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(net.minecraft.entity.item.EntityFallingBlock.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final String NBT_Drops = "Drops";
    private static final String NBT_TE = "TE";
    public IBlockState falltile;
    public int fallTime = 0;
    private NBTTagCompound data;
    private ArrayList collidingBoundingBoxes = new ArrayList();

    public EntityFallingBlock(World world) {
        super(world);
    }

    private EntityFallingBlock(World world, double d, double d1, double d2, IBlockState state, NBTTagCompound data) {
        super(world);
        this.falltile = state;
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.func_70107_b(d, d1, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
        this.data = data;
        this.setOrigin(new BlockPos((Entity)this));
    }

    public void setOrigin(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public static void cascade(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos)) {
            EntityFallingBlock.drop(world, pos);
        }
    }

    public double func_70033_W() {
        return (double)this.field_70131_O / 2.0;
    }

    public static void drop(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        boolean flag = false;
        IBlockState posState = world.func_180495_p(pos);
        Material material = posState.func_185904_a();
        if (material == Material.field_151587_i || material == Material.field_151586_h) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            return;
        }
        if (flag) {
            return;
        }
        if (world.func_175623_d(pos)) {
            return;
        }
        if (!world.func_175623_d(pos.func_177977_b())) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        List drops = posState.func_177230_c().getDrops((IBlockAccess)world, pos, posState, 0);
        data.func_74782_a(NBT_Drops, (NBTBase)NBTUtils.writeItemStackCollection(new NBTTagList(), drops));
        if (world.func_175625_s(pos) != null) {
            NBTTagCompound tedata = new NBTTagCompound();
            world.func_175625_s(pos).func_189515_b(tedata);
            world.func_175713_t(pos);
            data.func_74782_a(NBT_TE, (NBTBase)tedata);
        }
        EntityFallingBlock entityfalling = new EntityFallingBlock(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, posState, data);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        world.func_72838_d((Entity)entityfalling);
    }

    public boolean func_70026_G() {
        return this.func_70090_H();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        if (this.falltile == null) {
            this.func_70106_y();
            return;
        }
        ++this.fallTime;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.field_70122_E) {
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            this.func_70106_y();
            this.place(new BlockPos(x, y, z));
            return;
        }
        if (this.field_70163_u < -10.0 && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            return;
        }
        if (this.fallTime == 1 && !this.field_70170_p.field_72995_K) {
            for (EnumFacing face : EnumFacing.field_176754_o) {
                EntityFallingBlock.cascade(this.field_70170_p, this.func_180425_c().func_177972_a(face));
            }
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (face == EnumFacing.DOWN) continue;
            }
        }
    }

    private void place(BlockPos pos) {
        if (!this.field_70170_p.func_180501_a(pos, this.falltile, 2)) {
            this.handleDrops();
        } else if (this.data != null && this.data.func_74764_b(NBT_TE)) {
            NBTTagCompound tileentity = this.data.func_74775_l(NBT_TE);
            tileentity.func_74768_a("x", pos.func_177958_n());
            tileentity.func_74768_a("y", pos.func_177956_o());
            tileentity.func_74768_a("z", pos.func_177952_p());
            if (this.field_70170_p.func_175625_s(pos) != null) {
                this.field_70170_p.func_175625_s(pos).func_145839_a(tileentity);
            } else {
                this.field_70170_p.func_175690_a(pos, TileEntity.func_190200_a((World)this.field_70170_p, (NBTTagCompound)tileentity));
            }
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_72317_d(x, y, z));
            this.func_174829_m();
        } else {
            BlockPos blockpos1;
            IBlockState iblockstate1;
            Block block1;
            this.field_70170_p.field_72984_F.func_76320_a("move");
            double d10 = this.field_70165_t;
            double d11 = this.field_70163_u;
            double d1 = this.field_70161_v;
            if (this.field_70134_J) {
                this.field_70134_J = false;
                x *= 0.25;
                y *= (double)0.05f;
                z *= 0.25;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            double d2 = x;
            double d3 = y;
            double d4 = z;
            List list1 = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(x, y, z));
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            if (y != 0.0) {
                int l = list1.size();
                for (int k = 0; k < l; ++k) {
                    y = ((AxisAlignedBB)list1.get(k)).func_72323_b(this.func_174813_aQ(), y);
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
            }
            if (x != 0.0) {
                int l5 = list1.size();
                for (int j5 = 0; j5 < l5; ++j5) {
                    x = ((AxisAlignedBB)list1.get(j5)).func_72316_a(this.func_174813_aQ(), x);
                }
                if (x != 0.0) {
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
                }
            }
            if (z != 0.0) {
                int i6 = list1.size();
                for (int k5 = 0; k5 < i6; ++k5) {
                    z = ((AxisAlignedBB)list1.get(k5)).func_72322_c(this.func_174813_aQ(), z);
                }
                if (z != 0.0) {
                    this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, z));
                }
            }
            boolean flag = this.field_70122_E || d3 != y && d3 < 0.0;
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70170_p.field_72984_F.func_76320_a("rest");
            this.func_174829_m();
            this.field_70123_F = d2 != x || d4 != z;
            this.field_70124_G = d3 != y;
            this.field_70122_E = this.field_70124_G && d3 < 0.0;
            this.field_70132_H = this.field_70123_F || this.field_70124_G;
            int j6 = MathHelper.func_76128_c((double)this.field_70165_t);
            int i1 = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int k6 = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockpos = new BlockPos(j6, i1, k6);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() == Material.field_151579_a && ((block1 = (iblockstate1 = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_177230_c()) instanceof BlockFence || block1 instanceof BlockWall || block1 instanceof BlockFenceGate)) {
                iblockstate = iblockstate1;
                blockpos = blockpos1;
            }
            this.func_184231_a(y, this.field_70122_E, iblockstate, blockpos);
            if (d2 != x) {
                this.field_70159_w = 0.0;
            }
            if (d4 != z) {
                this.field_70179_y = 0.0;
            }
            Block block = iblockstate.func_177230_c();
            if (d3 != y) {
                block.func_176216_a(this.field_70170_p, (Entity)this);
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    private void handleDrops() {
        NBTTagList drops = this.data.func_150295_c(NBT_Drops, 10);
        ArrayList<ItemStack> items = NBTUtils.readItemStackCollection(drops, new ArrayList());
        for (ItemStack itemstack : items) {
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        Block block = this.falltile != null ? this.falltile.func_177230_c() : Blocks.field_150350_a;
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        compound.func_74778_a("Block", resourcelocation == null ? "" : resourcelocation.toString());
        compound.func_74774_a("Data", (byte)block.func_176201_c(this.falltile));
        compound.func_74768_a("Time", this.fallTime);
        if (this.data != null) {
            compound.func_74782_a("TileEntityData", (NBTBase)this.data);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        Block b;
        int i = compound.func_74771_c("Data") & 0xFF;
        this.falltile = null;
        if (compound.func_150297_b("Block", 8) && (b = Block.func_149684_b((String)compound.func_74779_i("Block"))) != null) {
            this.falltile = b.func_176203_a(i);
        }
        this.fallTime = compound.func_74762_e("Time");
        if (compound.func_150297_b("TileEntityData", 10)) {
            this.data = compound.func_74775_l("TileEntityData");
        }
        if (this.falltile == null || this.falltile.func_185904_a() == Material.field_151579_a) {
            this.falltile = Blocks.field_150354_m.func_176223_P();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    @Nullable
    public IBlockState getBlock() {
        return this.falltile;
    }

    public boolean func_184213_bq() {
        return true;
    }

    public World getWorld() {
        return this.field_70170_p;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(Block.func_176210_f((IBlockState)this.falltile));
    }

    public void readSpawnData(ByteBuf data) {
        this.falltile = Block.func_176220_d((int)data.readInt());
    }
}

