/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.render;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class RenderRainbow {
    public static int[] hsvToRGB(float hue, float sat, float val) {
        float subProg;
        float progress = hue / 360.0f;
        int r = 0;
        int g = 0;
        int b = 0;
        if (progress >= 0.0f && progress < 0.16666667f) {
            subProg = progress / 0.16666667f;
            r = 255;
            g = (int)(subProg * 255.0f);
            b = 0;
        } else if (progress >= 0.16666667f && progress < 0.33333334f) {
            subProg = (progress - 0.16666667f) / 0.16666667f;
            r = 255 - (int)(subProg * 255.0f);
            g = 255;
            b = 0;
        } else if (progress >= 0.33333334f && progress < 0.5f) {
            subProg = (progress - 0.33333334f) / 0.16666667f;
            r = 0;
            g = 255;
            b = (int)(subProg * 255.0f);
        } else if (progress >= 0.5f && progress < 0.6666667f) {
            subProg = (progress - 0.5f) / 0.16666667f;
            r = 0;
            g = 255 - (int)(subProg * 255.0f);
            b = 255;
        } else if (progress >= 0.6666667f && progress < 0.8333333f) {
            subProg = (progress - 0.6666667f) / 0.16666667f;
            r = (int)(subProg * 255.0f);
            g = 0;
            b = 255;
        } else if (progress >= 0.8333333f && progress <= 1.0f) {
            subProg = (progress - 0.8333333f) / 0.16666667f;
            r = 255;
            g = 0;
            b = 255 - (int)(subProg * 255.0f);
        }
        int finalMin = (int)(val - sat);
        int finalMax = (int)val;
        if (finalMax < finalMin) {
            finalMax = finalMin;
        }
        if (finalMin < 0) {
            finalMin = 0;
        }
        if (finalMax > 255) {
            finalMax = 255;
        }
        r = RenderRainbow.normalize(r, 0, 255, finalMin, finalMax);
        g = RenderRainbow.normalize(g, 0, 255, finalMin, finalMax);
        b = RenderRainbow.normalize(b, 0, 255, finalMin, finalMax);
        return new int[]{r, g, b};
    }

    public static int normalize(int value, int initMin, int initMax, int finalMin, int finalMax) {
        float val = (float)(value - initMin) / (float)(initMax - initMin);
        val *= (float)(finalMax - finalMin);
        if ((val += (float)finalMin) < (float)finalMin) {
            val = finalMin;
        }
        if (val > (float)finalMax) {
            val = finalMax;
        }
        return (int)val;
    }

    public static float quadratic(float x) {
        return (float)Math.sqrt(1.0f - x * x);
    }

    public static void renderRainbow(float skyAngle, float width) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)skyAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        RenderRainbow.doRenderRainbow(width);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderRainbow.doRenderRainbow(width);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    public static void doRenderRainbow(float width) {
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        float numStrips = 50.0f;
        float stripWidth = width / numStrips;
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (float line = 0.0f; line < numStrips; line += 1.0f) {
            float hueProg = line / numStrips;
            float hue = hueProg * 240.0f;
            int[] color = RenderRainbow.hsvToRGB(hue, 255.0f, 200.0f);
            float resolution = 100.0f;
            float patchHeight = 0.5f;
            float rainbowWidth = stripWidth * numStrips;
            for (float zPos = -resolution; zPos <= resolution; zPos += patchHeight) {
                float yHeight = RenderRainbow.quadratic(zPos / resolution) * resolution;
                float yHeight2 = RenderRainbow.quadratic((zPos - patchHeight) / resolution) * resolution;
                vb.func_181662_b((double)(line * stripWidth - stripWidth - rainbowWidth / 2.0f), (double)yHeight2, (double)zPos).func_181666_a((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, 0.2f).func_181675_d();
                vb.func_181662_b((double)(line * stripWidth + stripWidth - rainbowWidth / 2.0f), (double)yHeight2, (double)zPos).func_181666_a((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, 0.2f).func_181675_d();
                vb.func_181662_b((double)(line * stripWidth + stripWidth - rainbowWidth / 2.0f), (double)yHeight, (double)(zPos + patchHeight)).func_181666_a((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, 0.2f).func_181675_d();
                vb.func_181662_b((double)(line * stripWidth - stripWidth - rainbowWidth / 2.0f), (double)yHeight, (double)(zPos + patchHeight)).func_181666_a((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, 0.2f).func_181675_d();
            }
        }
        tes.func_78381_a();
        GlStateManager.func_179119_h();
        GlStateManager.func_179121_F();
    }
}

