/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.render;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.word.DrawableWord;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.words.DrawableWordManager;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PageBuilder {
    private static final TransformWrapper HELD_ITEM_TRANSFORMS;
    private static BufferedImage pageImage;
    private static Map<ResourceLocation, BufferedImage> customSymbolSources;

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        TextureMap tm = event.getMap();
        if (Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            pageImage = PageBuilder.buildBackground();
            PageBuilder.buildSymbolImage(DrawableWord.word_components);
            for (IAgeSymbol symbol2 : SymbolManager.getAgeSymbols()) {
                ModelResourceLocation mrl = ModItems.PageMeshDefinition.instance.getModelLocationForSymbol(symbol2);
                ResourceLocation unwrapped = new ResourceLocation(mrl.func_110624_b(), mrl.func_110623_a());
                tm.setTextureEntry((TextureAtlasSprite)new PageSprite(unwrapped, symbol2));
            }
            ModelResourceLocation mrl = ModItems.PageMeshDefinition.instance.getModelLocationForSymbol(null);
            ResourceLocation unwrapped = new ResourceLocation(mrl.func_110624_b(), mrl.func_110623_a());
            tm.setTextureEntry((TextureAtlasSprite)new LinkingPageSprite(unwrapped));
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        if (Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            for (IAgeSymbol symbol2 : SymbolManager.getAgeSymbols()) {
                ModelResourceLocation mrl = ModItems.PageMeshDefinition.instance.getModelLocationForSymbol(symbol2);
                ResourceLocation unwrapped = new ResourceLocation(mrl.func_110624_b(), mrl.func_110623_a());
                IBakedModel model = new ItemLayerModel(ImmutableList.of((Object)unwrapped)).bake((IModelState)HELD_ITEM_TRANSFORMS, DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().getTextureExtry(unwrapped.toString()));
                event.getModelRegistry().func_82595_a((Object)mrl, (Object)model);
            }
            ModelResourceLocation mrl = ModItems.PageMeshDefinition.instance.getModelLocationForSymbol(null);
            ResourceLocation unwrapped = new ResourceLocation(mrl.func_110624_b(), mrl.func_110623_a());
            IBakedModel emptyModel = new ItemLayerModel(ImmutableList.of((Object)unwrapped)).bake((IModelState)HELD_ITEM_TRANSFORMS, DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().getTextureExtry(unwrapped.toString()));
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)emptyModel);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BufferedImage buildSymbolImage(ResourceLocation src) {
        if (customSymbolSources.containsKey(src)) {
            return customSymbolSources.get(src);
        }
        try (InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(src).func_110527_b();){
            BufferedImage in = ImageIO.read(is);
            ColorModel cm = in.getColorModel();
            in = new BufferedImage(cm, in.copyData(null), cm.isAlphaPremultiplied(), null);
            customSymbolSources.put(src, in);
            BufferedImage bufferedImage = in;
            return bufferedImage;
        }
        catch (IOException exc) {
            throw new RuntimeException("Couldn't find or open the symbol-containing image.", exc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BufferedImage buildBackground() {
        ResourceLocation originalBackground = new ResourceLocation("mystcraft", "textures/items/page_background.png");
        try (InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(originalBackground).func_110527_b();){
            BufferedImage image = ImageIO.read(is);
            BufferedImage bufferedImage = PageBuilder.scale(image, 5.0, 1);
            return bufferedImage;
        }
        catch (IOException exc) {
            throw new RuntimeException("Couldn't find or open the page background image.", exc);
        }
    }

    private static BufferedImage scale(BufferedImage in, double scale, int scaleOperation) {
        int w = in.getWidth();
        int h = in.getHeight();
        BufferedImage after = new BufferedImage((int)((double)w * scale), (int)((double)h * scale), 2);
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(at, scaleOperation);
        return scaleOp.filter(in, after);
    }

    @SubscribeEvent
    public void onTextureStitchPost(TextureStitchEvent.Post event) {
        if (pageImage != null) {
            pageImage = null;
        }
        customSymbolSources.clear();
    }

    private static TRSRTransformation getTransform(float tx, float ty, float tz, float rx, float ry, float rz, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(rx, ry, rz)), new Vector3f(s, s, s), null));
    }

    static {
        pageImage = null;
        customSymbolSources = new HashMap<ResourceLocation, BufferedImage>();
        TRSRTransformation leftHandFlipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
        TRSRTransformation thirdPerson = PageBuilder.getTransform(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TRSRTransformation firstPerson = PageBuilder.getTransform(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        TRSRTransformation leftThird = TRSRTransformation.blockCenterToCorner((TRSRTransformation)leftHandFlipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)thirdPerson)).compose(leftHandFlipX));
        TRSRTransformation leftFirst = TRSRTransformation.blockCenterToCorner((TRSRTransformation)leftHandFlipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)firstPerson)).compose(leftHandFlipX));
        HashMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformationMap = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>();
        transformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, leftThird);
        transformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        transformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, leftFirst);
        transformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, firstPerson);
        transformationMap.put(ItemCameraTransforms.TransformType.HEAD, PageBuilder.getTransform(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        transformationMap.put(ItemCameraTransforms.TransformType.GUI, TRSRTransformation.identity());
        transformationMap.put(ItemCameraTransforms.TransformType.GROUND, PageBuilder.getTransform(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        transformationMap.put(ItemCameraTransforms.TransformType.FIXED, TRSRTransformation.identity());
        HELD_ITEM_TRANSFORMS = new TransformWrapper(Collections.unmodifiableMap(transformationMap));
    }

    private static class TransformWrapper
    implements IModelState {
        private final Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

        public TransformWrapper(Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            this.transforms = transforms;
        }

        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            if (!(part.isPresent() && part.get() instanceof ItemCameraTransforms.TransformType && this.transforms.containsKey(part.get()))) {
                return Optional.absent();
            }
            return Optional.of((Object)this.transforms.get(part.get()));
        }
    }

    public static class PageSprite
    extends TextureAtlasSprite {
        @Nullable
        private final IAgeSymbol symbol;

        private PageSprite(ResourceLocation res, @Nullable IAgeSymbol symbol2) {
            super(res.toString());
            this.symbol = symbol2;
            this.field_130223_c = 128;
            this.field_130224_d = 128;
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        public boolean load(IResourceManager manager, ResourceLocation location) {
            if (pageImage == null) {
                throw new IllegalStateException("Called texture loading outside of TextureManager's loading cycle!");
            }
            ColorModel cm = pageImage.getColorModel();
            BufferedImage copy = new BufferedImage(cm, pageImage.copyData(null), cm.isAlphaPremultiplied(), null);
            if (this.symbol != null) {
                String[] words = this.symbol.getPoem();
                if (words == null) {
                    this.stitchWord(copy, null, -1, PageBuilder.buildSymbolImage(DrawableWord.word_components));
                } else {
                    DrawableWord word;
                    BufferedImage source = PageBuilder.buildSymbolImage(DrawableWord.word_components);
                    if (words.length > 0) {
                        word = DrawableWordManager.getDrawableWord(words[0]);
                        this.stitchWord(copy, word, 0, source);
                    }
                    if (words.length > 1) {
                        word = DrawableWordManager.getDrawableWord(words[1]);
                        this.stitchWord(copy, word, 1, source);
                    }
                    if (words.length > 2) {
                        word = DrawableWordManager.getDrawableWord(words[2]);
                        this.stitchWord(copy, word, 2, source);
                    }
                    if (words.length > 3) {
                        word = DrawableWordManager.getDrawableWord(words[3]);
                        this.stitchWord(copy, word, 3, source);
                    }
                }
            }
            BufferedImage down = PageBuilder.scale(copy, 0.8, 2);
            int[][] pixels = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
            pixels[0] = new int[down.getWidth() * down.getHeight()];
            down.getRGB(0, 0, down.getWidth(), down.getHeight(), pixels[0], 0, down.getWidth());
            this.func_130103_l();
            this.field_110976_a.add(pixels);
            return false;
        }

        private void stitchWord(BufferedImage targetImage, DrawableWord word, int index, BufferedImage source) {
            AbstractList components = null;
            AbstractList colors = null;
            if (word != null) {
                ResourceLocation src = word.imageSource();
                if (src != null) {
                    source = PageBuilder.buildSymbolImage(src);
                }
                components = word.components();
                colors = word.colors();
            }
            if (components == null || components.isEmpty()) {
                components = new LinkedList<Integer>();
                components.add(0);
                colors = new LinkedList();
            }
            for (int i = 0; i < components.size(); ++i) {
                int color = 0;
                if (i < colors.size()) {
                    color = (Integer)colors.get(i);
                } else if (colors.size() > 0) {
                    color = (Integer)colors.get(0);
                }
                Integer component = (Integer)components.get(i);
                int iconX = component % 8 * 64;
                int iconY = component / 8 * 64;
                Rectangle targetRct = this.getPageTarget(index);
                for (int x = 0; x < 64; ++x) {
                    for (int y = 0; y < 64; ++y) {
                        int argb = source.getRGB(iconX + x, iconY + y);
                        Color c = new Color(argb, true);
                        if (c.getAlpha() <= 0) continue;
                        int currentArgb = targetImage.getRGB(targetRct.x + x, targetRct.y + y);
                        int targetColor = this.blend(color, argb, currentArgb);
                        targetImage.setRGB(targetRct.x + x, targetRct.y + y, targetColor);
                    }
                }
            }
        }

        private int blend(int targetInitialColor, int currentColor, int targetColor) {
            float srcAlpha = (float)(currentColor >> 24 & 0xFF) / 255.0f;
            float fRed = (float)(targetInitialColor >> 16 & 0xFF) / 255.0f;
            float fGreen = (float)(targetInitialColor >> 8 & 0xFF) / 255.0f;
            float fBlue = (float)(targetInitialColor & 0xFF) / 255.0f;
            float targetRed = (float)(targetColor >> 16 & 0xFF) / 255.0f;
            float targetGreen = (float)(targetColor >> 8 & 0xFF) / 255.0f;
            float targetBlue = (float)(targetColor & 0xFF) / 255.0f;
            float resRed = fRed * srcAlpha + targetRed * (1.0f - srcAlpha);
            float resGreen = fGreen * srcAlpha + targetGreen * (1.0f - srcAlpha);
            float resBlue = fBlue * srcAlpha + targetBlue * (1.0f - srcAlpha);
            resRed = MathHelper.func_76131_a((float)resRed, (float)0.0f, (float)1.0f);
            resGreen = MathHelper.func_76131_a((float)resGreen, (float)0.0f, (float)1.0f);
            resBlue = MathHelper.func_76131_a((float)resBlue, (float)0.0f, (float)1.0f);
            return new Color(MathHelper.func_76125_a((int)((int)resRed * 255), (int)0, (int)255), MathHelper.func_76125_a((int)((int)resGreen * 255), (int)0, (int)255), MathHelper.func_76125_a((int)((int)resBlue * 255), (int)0, (int)255), 255).getRGB();
        }

        private Rectangle getPageTarget(int index) {
            switch (index) {
                case 3: {
                    return new Rectangle(0, 48, 64, 64);
                }
                case 2: {
                    return new Rectangle(48, 96, 64, 64);
                }
                case 1: {
                    return new Rectangle(96, 48, 64, 64);
                }
                case 0: {
                    return new Rectangle(48, 0, 64, 64);
                }
            }
            return new Rectangle(48, 48, 64, 64);
        }
    }

    public static class LinkingPageSprite
    extends TextureAtlasSprite {
        private LinkingPageSprite(ResourceLocation res) {
            super(res.toString());
            this.field_130223_c = 128;
            this.field_130224_d = 128;
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        public boolean load(IResourceManager manager, ResourceLocation location) {
            if (pageImage == null) {
                throw new IllegalStateException("Called texture loading outside of TextureManager's loading cycle!");
            }
            ColorModel cm = pageImage.getColorModel();
            BufferedImage copy = new BufferedImage(cm, pageImage.copyData(null), cm.isAlphaPremultiplied(), null);
            int width = 110;
            int height = 45;
            int startX = 25;
            int startZ = 30;
            for (int xx = startX; xx <= startX + width; ++xx) {
                for (int zz = startZ; zz <= startZ + height; ++zz) {
                    copy.setRGB(xx, zz, -16777216);
                }
            }
            BufferedImage down = PageBuilder.scale(copy, 0.8, 2);
            int[][] pixels = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
            pixels[0] = new int[down.getWidth() * down.getHeight()];
            down.getRGB(0, 0, down.getWidth(), down.getHeight(), pixels[0], 0, down.getWidth());
            this.func_130103_l();
            this.field_110976_a.add(pixels);
            return false;
        }
    }
}

