/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.render;

import com.xcompwiz.mystcraft.client.render.IMaskRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRendererMask
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            return true;
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            return true;
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            return true;
        }
        return type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            return false;
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            return true;
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            return false;
        }
        return type != IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        GL11.glEnable((int)3008);
        if (type.equals((Object)IItemRenderer.ItemRenderType.ENTITY)) {
            GL11.glRotated((double)90.0, (double)0.0, (double)-1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)0.0);
        } else if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GL11.glScaled((double)-16.0, (double)-16.0, (double)1.0);
            GL11.glTranslated((double)-1.0, (double)-1.0, (double)0.0);
        }
        GL11.glPushMatrix();
        int passes = stack.func_77973_b().getRenderPasses(stack.func_77952_i());
        for (int i = 0; i < passes; ++i) {
            this.renderIcon(stack.getItemSpriteNumber() == 0 ? TextureMap.locationBlocksTexture : TextureMap.locationItemsTexture, stack.func_77973_b().getIcon(stack, 0));
        }
        GL11.glPopMatrix();
        if (stack.func_77973_b() instanceof IMaskRender) {
            IMaskRender mask = (IMaskRender)stack.func_77973_b();
            ItemRendererMask.renderMask(mask.getMaskResource(stack), mask.getMaskIcon(stack), mask.getSubbedResource(stack), mask.getSubbedIcon(stack), mask.getColor(stack), type);
        }
    }

    public void renderIcon(ResourceLocation resloc, IIcon icon) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resloc);
        ItemRendererMask.renderItemIcon(icon);
        GL11.glPopMatrix();
    }

    public static void renderItemIcon(IIcon icon) {
        ItemRendererMask.renderItemIcon(icon, 0.0625f);
    }

    public static void renderItemIcon(IIcon icon, float z) {
        if (icon == null) {
            return;
        }
        ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)z);
    }

    public static void renderMask(ResourceLocation maskResource, IIcon maskIcon, ResourceLocation maskedResource, IIcon maskedIcon, int maskColor, IItemRenderer.ItemRenderType type) {
        if (maskIcon == null || maskedIcon == null) {
            return;
        }
        GL11.glPushMatrix();
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GL11.glScaled((double)1.0, (double)1.0, (double)0.995);
        } else {
            double d = 1.05;
            GL11.glScaled((double)0.996, (double)0.996, (double)d);
            GL11.glTranslated((double)0.0, (double)0.0, (double)((0.0625 * d - 0.0625) / 2.0));
        }
        GL11.glColor4ub((byte)((byte)(maskColor >> 24 & 0xFF)), (byte)((byte)(maskColor >> 16 & 0xFF)), (byte)((byte)(maskColor >> 8 & 0xFF)), (byte)((byte)(maskColor & 0xFF)));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(maskResource);
        ItemRendererMask.renderItemIcon(maskIcon);
        GL11.glDepthFunc((int)514);
        GL11.glMatrixMode((int)5890);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(maskedResource);
        ItemRendererMask.renderItemIcon(maskedIcon);
        GL11.glMatrixMode((int)5888);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

