/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.model;

import com.xcompwiz.mystcraft.client.model.ModelElement;
import com.xcompwiz.mystcraft.client.model.ModelRendererAdvanced;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelBox
extends ModelElement {
    private PositionTextureVertex[] vertexPositions;
    private TexturedQuad[] quadList;
    public final float posX1;
    public final float posY1;
    public final float posZ1;
    public final float posX2;
    public final float posY2;
    public final float posZ2;
    public String name;

    public ModelBox(ModelRendererAdvanced modelRenderer, int textureX, int textureY, float x, float y, float z, int width, int height, int depth, float scalar) {
        this.posX1 = x;
        this.posY1 = y;
        this.posZ1 = z;
        this.posX2 = x + (float)width;
        this.posY2 = y + (float)height;
        this.posZ2 = z + (float)depth;
        this.vertexPositions = new PositionTextureVertex[8];
        this.quadList = new TexturedQuad[6];
        float x2 = x + (float)width;
        float y2 = y + (float)height;
        float z2 = z + (float)depth;
        x -= scalar;
        y -= scalar;
        z -= scalar;
        x2 += scalar;
        y2 += scalar;
        z2 += scalar;
        if (modelRenderer.mirror) {
            float swap = x2;
            x2 = x;
            x = swap;
        }
        PositionTextureVertex origin = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
        PositionTextureVertex point2 = new PositionTextureVertex(x2, y, z, 0.0f, 8.0f);
        PositionTextureVertex point3 = new PositionTextureVertex(x2, y2, z, 8.0f, 8.0f);
        PositionTextureVertex point4 = new PositionTextureVertex(x, y2, z, 8.0f, 0.0f);
        PositionTextureVertex point5 = new PositionTextureVertex(x, y, z2, 0.0f, 0.0f);
        PositionTextureVertex point6 = new PositionTextureVertex(x2, y, z2, 0.0f, 8.0f);
        PositionTextureVertex point7 = new PositionTextureVertex(x2, y2, z2, 8.0f, 8.0f);
        PositionTextureVertex point8 = new PositionTextureVertex(x, y2, z2, 8.0f, 0.0f);
        this.vertexPositions[0] = origin;
        this.vertexPositions[1] = point2;
        this.vertexPositions[2] = point3;
        this.vertexPositions[3] = point4;
        this.vertexPositions[4] = point5;
        this.vertexPositions[5] = point6;
        this.vertexPositions[6] = point7;
        this.vertexPositions[7] = point8;
        this.quadList[0] = new TexturedQuad(new PositionTextureVertex[]{point6, point2, point3, point7}, textureX + depth + width, textureY + depth, textureX + depth + width + depth, textureY + depth + height, modelRenderer.textureWidth, modelRenderer.textureHeight);
        this.quadList[1] = new TexturedQuad(new PositionTextureVertex[]{origin, point5, point8, point4}, textureX, textureY + depth, textureX + depth, textureY + depth + height, modelRenderer.textureWidth, modelRenderer.textureHeight);
        this.quadList[2] = new TexturedQuad(new PositionTextureVertex[]{point6, point5, origin, point2}, textureX + depth, textureY, textureX + depth + width, textureY + depth, modelRenderer.textureWidth, modelRenderer.textureHeight);
        this.quadList[3] = new TexturedQuad(new PositionTextureVertex[]{point3, point4, point8, point7}, textureX + depth + width, textureY + depth, textureX + depth + width + width, textureY, modelRenderer.textureWidth, modelRenderer.textureHeight);
        this.quadList[4] = new TexturedQuad(new PositionTextureVertex[]{point2, origin, point4, point3}, textureX + depth, textureY + depth, textureX + depth + width, textureY + depth + height, modelRenderer.textureWidth, modelRenderer.textureHeight);
        this.quadList[5] = new TexturedQuad(new PositionTextureVertex[]{point5, point6, point7, point8}, textureX + depth + width + depth, textureY + depth, textureX + depth + width + depth + width, textureY + depth + height, modelRenderer.textureWidth, modelRenderer.textureHeight);
        if (modelRenderer.mirror) {
            for (TexturedQuad quad : this.quadList) {
                quad.func_78235_a();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(VertexBuffer vb, float par2) {
        for (TexturedQuad quad : this.quadList) {
            quad.func_178765_a(vb, par2);
        }
    }

    public ModelBox setName(String par1Str) {
        this.name = par1Str;
        return this;
    }
}

