/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.word.DrawableWord;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.seasonal.SeasonalManager;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.words.DrawableWordManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public final class GuiUtils {
    private static List<int[]> scissors = new LinkedList<int[]>();

    @SideOnly(value=Side.CLIENT)
    public static void drawPage(TextureManager renderEngine, float zLevel, @Nonnull ItemStack page, float xSize, float ySize, float x, float y) {
        GuiUtils.drawPageBackground(renderEngine, zLevel, page, xSize, ySize, x, y);
        if (Page.getSymbol(page) != null) {
            IAgeSymbol symbol2 = SymbolManager.getAgeSymbol(Page.getSymbol(page));
            GuiUtils.drawSymbol(renderEngine, zLevel, symbol2, xSize - 1.0f, x + 0.5f, y + (ySize + 1.0f - xSize) / 2.0f);
        } else if (Page.isLinkPanel(page)) {
            GuiUtils.drawGradientRect(x + xSize * 0.15f, y + ySize * 0.15f, x + xSize * 0.85f, y + ySize * 0.5f, -16777216, -16777216, zLevel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawPageBackground(TextureManager renderEngine, float zLevel, @Nonnull ItemStack page, float xSize, float ySize, float x, float y) {
        GlStateManager.func_179084_k();
        renderEngine.func_110577_a(Assets.GUIs.book_page_left);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (page.func_190926_b()) {
            GlStateManager.func_179131_c((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
        }
        GuiUtils.drawTexturedModalRect(x, y, 156.0f, 0.0f, 30.0f, 40.0f, zLevel, xSize, ySize);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSymbol(TextureManager renderEngine, float zLevel, IAgeSymbol symbol2, float scale, float x, float y) {
        if (SeasonalManager.drawSymbol(renderEngine, zLevel, symbol2, scale, x, y)) {
            return;
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (symbol2 == null) {
            GuiUtils.drawWord(renderEngine, zLevel, null, scale, x, y);
            return;
        }
        float s = (scale /= 2.0f) / 2.4142137f;
        float o = s * 1.4142135f;
        String[] words = symbol2.getPoem();
        if (words == null) {
            GuiUtils.drawWord(renderEngine, zLevel, DrawableWordManager.getDrawableWord(null), s * 2.0f, x + o, y + o);
            return;
        }
        if (words.length > 0) {
            GuiUtils.drawWord(renderEngine, zLevel, DrawableWordManager.getDrawableWord(words[0]), 2.0f * s, x + o, y);
        }
        if (words.length > 1) {
            GuiUtils.drawWord(renderEngine, zLevel, DrawableWordManager.getDrawableWord(words[1]), 2.0f * s, x + o * 2.0f, y + o);
        }
        if (words.length > 2) {
            GuiUtils.drawWord(renderEngine, zLevel, DrawableWordManager.getDrawableWord(words[2]), 2.0f * s, x + o, y + o * 2.0f);
        }
        if (words.length > 3) {
            GuiUtils.drawWord(renderEngine, zLevel, DrawableWordManager.getDrawableWord(words[3]), 2.0f * s, x, y + o);
        }
        GlStateManager.func_179084_k();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawWord(TextureManager renderEngine, float zLevel, DrawableWord word, float scale, float x, float y) {
        ArrayList<Integer> components = null;
        ArrayList<Integer> colors = null;
        ResourceLocation imagesource = null;
        if (word != null) {
            components = word.components();
            colors = word.colors();
            imagesource = word.imageSource();
        }
        if (imagesource == null) {
            imagesource = DrawableWord.word_components;
        }
        renderEngine.func_110577_a(imagesource);
        if (components == null || components.size() == 0) {
            components = new ArrayList();
            components.add(0);
            colors = new ArrayList();
        }
        for (int c = 0; c < components.size(); ++c) {
            int color = 0;
            if (c < colors.size()) {
                color = colors.get(c);
            } else if (colors.size() > 0) {
                color = colors.get(0);
            }
            GuiUtils.drawComponent(scale, zLevel, components.get(c), color, x, y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawComponent(float drawscale, float zLevel, int iconIndex, int color, float x, float y) {
        int iconSize = 64;
        int imgSize = 512;
        float transform = 0.001953125f;
        int iconX = iconIndex % 8 * 64;
        int iconY = iconIndex / 8 * 64;
        float fRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float fGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float fBlue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)fRed, (float)fGreen, (float)fBlue, (float)1.0f);
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(x + 0.0f), (double)(y + drawscale), (double)zLevel).func_187315_a((double)((float)(iconX + 0) * 0.001953125f), (double)((float)(iconY + 64) * 0.001953125f)).func_181675_d();
        vb.func_181662_b((double)(x + drawscale), (double)(y + drawscale), (double)zLevel).func_187315_a((double)((float)(iconX + 64) * 0.001953125f), (double)((float)(iconY + 64) * 0.001953125f)).func_181675_d();
        vb.func_181662_b((double)(x + drawscale), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((float)(iconX + 64) * 0.001953125f), (double)((float)(iconY + 0) * 0.001953125f)).func_181675_d();
        vb.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((float)(iconX + 0) * 0.001953125f), (double)((float)(iconY + 0) * 0.001953125f)).func_181675_d();
        tes.func_78381_a();
    }

    public static String getHoverText(IAgeSymbol symbol2) {
        if (symbol2 != null) {
            return symbol2.getLocalizedName();
        }
        return "?";
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexturedModalRect(float x, float y, float u, float v, float width, float height, float zLevel, float xSize, float ySize) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(x + 0.0f), (double)(y + ySize), (double)zLevel).func_187315_a((double)((u + 0.0f) * var7), (double)((v + height) * var8)).func_181675_d();
        vb.func_181662_b((double)(x + xSize), (double)(y + ySize), (double)zLevel).func_187315_a((double)((u + width) * var7), (double)((v + height) * var8)).func_181675_d();
        vb.func_181662_b((double)(x + xSize), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((u + width) * var7), (double)((v + 0.0f) * var8)).func_181675_d();
        vb.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((u + 0.0f) * var7), (double)((v + 0.0f) * var8)).func_181675_d();
        tes.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getIconSafe(TextureAtlasSprite tas) {
        if (tas == null) {
            tas = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        return tas;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawIcon(int x, int y, TextureAtlasSprite tas, int xSize, int ySize, double zLevel) {
        if (tas == null) {
            LoggerUtils.warn("Error attepting to render icon: null icon object.", new Object[0]);
            return;
        }
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(x + 0), (double)(y + ySize), zLevel).func_187315_a((double)tas.func_94209_e(), (double)tas.func_94210_h()).func_181675_d();
        vb.func_181662_b((double)(x + xSize), (double)(y + ySize), zLevel).func_187315_a((double)tas.func_94212_f(), (double)tas.func_94210_h()).func_181675_d();
        vb.func_181662_b((double)(x + xSize), (double)(y + 0), zLevel).func_187315_a((double)tas.func_94212_f(), (double)tas.func_94206_g()).func_181675_d();
        vb.func_181662_b((double)(x + 0), (double)(y + 0), zLevel).func_187315_a((double)tas.func_94209_e(), (double)tas.func_94206_g()).func_181675_d();
        tes.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawIconRepeating(TextureManager render, TextureAtlasSprite tas, int color, int left, int top, int width, int height, float zLevel) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int x = 0;
        int y = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
        for (x = 0; x < width; x += 16) {
            for (y = 0; y < height; y += 16) {
                drawWidth = Math.min(width - x, 16);
                drawHeight = Math.min(height - y, 16);
                GuiUtils.drawIcon(left + x, top + y, tas, drawWidth, drawHeight, zLevel);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawFluid(TextureManager render, Fluid fluid, int left, int top, int width, int height, float zLevel) {
        TextureAtlasSprite tas = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getStill().toString());
        if (tas == null) {
            LoggerUtils.warn("Error attepting to render fluid (%s): null icon object.", fluid.getName());
            return;
        }
        int color = fluid.getColor();
        render.func_110577_a(TextureMap.field_110575_b);
        GuiUtils.drawIconRepeating(render, tas, color, left, top, width, height, zLevel);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawFluid(TextureManager render, FluidStack fluidstack, int left, int top, int width, int height, float zLevel) {
        Fluid fluid = fluidstack.getFluid();
        TextureAtlasSprite tas = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getStill(fluidstack).toString());
        if (tas == null) {
            LoggerUtils.warn("Error attepting to render fluid (%s): null icon object.", fluid.getName());
            return;
        }
        int color = fluid.getColor(fluidstack);
        render.func_110577_a(TextureMap.field_110575_b);
        GuiUtils.drawIconRepeating(render, tas, color, left, top, width, height, zLevel);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTooltip(FontRenderer fontRenderer, int xcoord, int ycoord, float zLevel, List<String> list, int maxwidth, int maxheight) {
        if (list.size() > 0) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int width = 0;
            for (String aList : list) {
                int strLength = fontRenderer.func_78256_a(aList);
                if (strLength <= width) continue;
                width = strLength;
            }
            int height = 8;
            if (list.size() > 1) {
                height += (list.size() - 1) * 10;
            }
            if (xcoord + width + 28 >= maxwidth) {
                xcoord -= width + 28;
            }
            if (ycoord + height + 6 >= maxheight) {
                ycoord -= height + 6;
            }
            zLevel = 300.0f;
            int color = -267386864;
            GuiUtils.drawGradientRect(xcoord - 3, ycoord - 4, xcoord + width + 3, ycoord - 3, color, color, zLevel);
            GuiUtils.drawGradientRect(xcoord - 3, ycoord + height + 3, xcoord + width + 3, ycoord + height + 4, color, color, zLevel);
            GuiUtils.drawGradientRect(xcoord - 3, ycoord - 3, xcoord + width + 3, ycoord + height + 3, color, color, zLevel);
            GuiUtils.drawGradientRect(xcoord - 4, ycoord - 3, xcoord - 3, ycoord + height + 3, color, color, zLevel);
            GuiUtils.drawGradientRect(xcoord + width + 3, ycoord - 3, xcoord + width + 4, ycoord + height + 3, color, color, zLevel);
            int color1 = 0x505000FF;
            int color2 = (color1 & 0xFEFEFE) >> 1 | color1 & 0xFF000000;
            GuiUtils.drawGradientRect(xcoord - 3, ycoord - 3 + 1, xcoord - 3 + 1, ycoord + height + 3 - 1, color1, color2, zLevel);
            GuiUtils.drawGradientRect(xcoord + width + 2, ycoord - 3 + 1, xcoord + width + 3, ycoord + height + 3 - 1, color1, color2, zLevel);
            GuiUtils.drawGradientRect(xcoord - 3, ycoord - 3, xcoord + width + 3, ycoord - 3 + 1, color1, color1, zLevel);
            GuiUtils.drawGradientRect(xcoord - 3, ycoord + height + 2, xcoord + width + 3, ycoord + height + 3, color2, color2, zLevel);
            for (String str : list) {
                str = "\u00a7F" + str;
                fontRenderer.func_175063_a(str, (float)xcoord, (float)ycoord, -1);
                ycoord += 10;
            }
            zLevel = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74520_c();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGradientRect(float par1, float par2, float par3, float par4, int color1, int color2, float zLevel) {
        float alpha1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float green1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float blue1 = (float)(color1 & 0xFF) / 255.0f;
        float alpha2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(color2 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vb.func_181662_b((double)par3, (double)par2, (double)zLevel).func_181666_a(red1, green1, blue1, alpha1).func_181675_d();
        vb.func_181662_b((double)par1, (double)par2, (double)zLevel).func_181666_a(red1, green1, blue1, alpha1).func_181675_d();
        vb.func_181662_b((double)par1, (double)par4, (double)zLevel).func_181666_a(red2, green2, blue2, alpha2).func_181675_d();
        vb.func_181662_b((double)par3, (double)par4, (double)zLevel).func_181666_a(red2, green2, blue2, alpha2).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static boolean contains(int mouseX, int mouseY, int guiLeft, int guiTop, int width, int height) {
        if (mouseX < guiLeft) {
            return false;
        }
        if (mouseX >= guiLeft + width) {
            return false;
        }
        if (mouseY < guiTop) {
            return false;
        }
        return mouseY < guiTop + height;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSprite(int x, int y, int xOffset, int yOffset, float zLevel) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Assets.Vanilla.slot_tex);
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(x + 0), (double)(y + 18), (double)zLevel).func_187315_a((double)((float)(xOffset + 0) * 0.0078125f), (double)((float)(yOffset + 18) * 0.0078125f)).func_181675_d();
        vb.func_181662_b((double)(x + 18), (double)(y + 18), (double)zLevel).func_187315_a((double)((float)(xOffset + 18) * 0.0078125f), (double)((float)(yOffset + 18) * 0.0078125f)).func_181675_d();
        vb.func_181662_b((double)(x + 18), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(xOffset + 18) * 0.0078125f), (double)((float)(yOffset + 0) * 0.0078125f)).func_181675_d();
        vb.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(xOffset + 0) * 0.0078125f), (double)((float)(yOffset + 0) * 0.0078125f)).func_181675_d();
        tes.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSprite(int x, int y, int xSize, int ySize, int xOffset, int yOffset, float zLevel) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Assets.Vanilla.slot_tex);
        Tessellator tes = Tessellator.func_178181_a();
        VertexBuffer vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(x + 0), (double)(y + ySize), (double)zLevel).func_187315_a((double)((float)(xOffset + 0) * 0.0078125f), (double)((float)(yOffset + 18) * 0.0078125f)).func_181675_d();
        vb.func_181662_b((double)(x + xSize), (double)(y + ySize), (double)zLevel).func_187315_a((double)((float)(xOffset + 18) * 0.0078125f), (double)((float)(yOffset + 18) * 0.0078125f)).func_181675_d();
        vb.func_181662_b((double)(x + xSize), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(xOffset + 18) * 0.0078125f), (double)((float)(yOffset + 0) * 0.0078125f)).func_181675_d();
        vb.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(xOffset + 0) * 0.0078125f), (double)((float)(yOffset + 0) * 0.0078125f)).func_181675_d();
        tes.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawScaledText(String text, int x, int y, int width, int height, int textcolor) {
        GlStateManager.func_179094_E();
        float scale = 1.0f;
        int xPad = 0;
        int yPad = 0;
        int textWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        if (textWidth > width) {
            scale = (float)width / (float)textWidth;
        }
        GlStateManager.func_179109_b((float)(x + xPad), (float)(y + yPad), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(text, 0, 0, textcolor);
        GlStateManager.func_179121_F();
    }

    public static void startGlScissor(int guiLeft, int guiTop, int xSize, int ySize) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso = new ScaledResolution(mc);
        double scaleW = (double)mc.field_71443_c / reso.func_78327_c();
        double scaleH = (double)mc.field_71440_d / reso.func_78324_d();
        GL11.glEnable((int)3089);
        int x = (int)Math.floor((double)guiLeft * scaleW);
        int y = (int)Math.floor((double)mc.field_71440_d - (double)(guiTop + ySize) * scaleH);
        int width = (int)Math.floor((double)(guiLeft + xSize) * scaleW) - (int)Math.floor((double)guiLeft * scaleW);
        int height = (int)Math.floor((double)mc.field_71440_d - (double)guiTop * scaleH) - (int)Math.floor((double)mc.field_71440_d - (double)(guiTop + ySize) * scaleH);
        if (scissors.size() > 0) {
            int[] c = scissors.get(0);
            width = Math.min(width + x, c[2] + c[0]);
            height = Math.min(height + y, c[3] + c[1]);
            x = Math.max(x, c[0]);
            y = Math.max(y, c[1]);
            width -= x;
            height -= y;
        }
        scissors.add(0, new int[]{x, y, width, height});
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public static void endGlScissor() {
        scissors.remove(0);
        if (scissors.size() == 0) {
            GL11.glDisable((int)3089);
        } else {
            int[] c = scissors.get(0);
            GL11.glScissor((int)c[0], (int)c[1], (int)c[2], (int)c[3]);
        }
    }
}

