/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.block;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.data.ModGUIs;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.tileentity.TileEntityDesk;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockWritingDesk
extends Block {
    public static final PropertyEnum<EnumFacing> ROTATION = PropertyEnum.func_177706_a((String)"facing", EnumFacing.class, (Enum[])EnumFacing.field_176754_o);
    public static final PropertyBool IS_TOP = PropertyBool.func_177716_a((String)"istop");
    public static final PropertyBool IS_FOOT = PropertyBool.func_177716_a((String)"isfoot");
    private static final int[][] headFootMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};

    public BlockWritingDesk() {
        super(Material.field_151575_d);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("myst.writing_desk");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ROTATION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)IS_TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)IS_FOOT, (Comparable)Boolean.valueOf(false)));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public int func_176201_c(IBlockState state) {
        int t = BlockWritingDesk.isBlockTop(state) ? 1 : 0;
        int f = BlockWritingDesk.isBlockFoot(state) ? 1 : 0;
        int horizontal = BlockWritingDesk.getDirectionFromMetadata(state).func_176736_b();
        return t << 3 | f << 2 | horizontal & 3;
    }

    public IBlockState func_176203_a(int meta) {
        boolean t = (meta >> 3 & 1) != 0;
        boolean f = (meta >> 2 & 1) != 0;
        int horizontalIndex = meta & 3;
        return this.func_176223_P().func_177226_a((IProperty)IS_TOP, (Comparable)Boolean.valueOf(t)).func_177226_a((IProperty)IS_FOOT, (Comparable)Boolean.valueOf(f)).func_177226_a(ROTATION, (Comparable)EnumFacing.field_176754_o[horizontalIndex]);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, IS_TOP, IS_FOOT});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float xmin = 0.0f;
        float xmax = 1.0f;
        float ymin = 0.0f;
        float ymax = 1.0f;
        float zmin = 0.0f;
        float zmax = 1.0f;
        if (BlockWritingDesk.isBlockTop(state)) {
            ymax = 0.75f;
            int dirInt = BlockWritingDesk.getDirectionFromMetadata(state).func_176736_b();
            if (dirInt == 0) {
                xmin = 0.5f;
            }
            if (dirInt == 1) {
                zmin = 0.5f;
            }
            if (dirInt == 2) {
                xmax = 0.5f;
            }
            if (dirInt == 3) {
                zmax = 0.5f;
            }
        }
        return new AxisAlignedBB((double)xmin, (double)ymin, (double)zmin, (double)xmax, (double)ymax, (double)zmax);
    }

    public boolean func_149686_d(IBlockState state) {
        return !BlockWritingDesk.isBlockTop(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (BlockWritingDesk.isBlockTop(state) && !BlockWritingDesk.isBlockFoot(state) && !worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().equals((Object)this)) {
            if (!worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_175698_g(pos);
        }
        EnumFacing face = BlockWritingDesk.getDirectionFromMetadata(state);
        int dirInt = face.func_176736_b();
        if (BlockWritingDesk.isBlockFoot(state)) {
            if (!worldIn.func_180495_p(pos.func_177982_a(-headFootMap[dirInt][0], 0, -headFootMap[dirInt][1])).func_177230_c().equals((Object)this)) {
                worldIn.func_175698_g(pos);
            }
        } else if (!worldIn.func_180495_p(pos.func_177982_a(headFootMap[dirInt][0], 0, headFootMap[dirInt][1])).func_177230_c().equals((Object)this)) {
            worldIn.func_175698_g(pos);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && !BlockWritingDesk.isBlockTop(state) && world.func_180495_p(pos.func_177984_a()).func_177230_c().equals((Object)this) && BlockWritingDesk.isBlockTop(world.func_180495_p(pos.func_177984_a()))) {
            world.func_175698_g(pos.func_177984_a());
            EnumFacing direction = BlockWritingDesk.getDirectionFromMetadata(state);
            int dirInt = direction.func_176736_b();
            if (BlockWritingDesk.isBlockFoot(state)) {
                BlockPos offset = pos.func_177982_a(-headFootMap[dirInt][0], 1, -headFootMap[dirInt][1]);
                world.func_175698_g(offset);
            } else {
                BlockPos offset = pos.func_177982_a(headFootMap[dirInt][0], 1, headFootMap[dirInt][1]);
                world.func_175698_g(offset);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        playerIn.openGui((Object)Mystcraft.instance, ModGUIs.WRITING_DESK.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null && tileentity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler handle = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int l = 0; l < handle.getSlots(); ++l) {
                ItemStack itemstack = handle.getStackInSlot(l);
                if (itemstack.func_190926_b()) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), itemstack);
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (BlockWritingDesk.isBlockTop(state)) {
            ret.add(new ItemStack(ModItems.desk, 1, 1));
        } else {
            ret.add(new ItemStack(ModItems.desk));
        }
        return ret;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (BlockWritingDesk.isBlockTop(state)) {
            return new ItemStack(ModItems.desk, 1, 1);
        }
        return new ItemStack(ModItems.desk);
    }

    public static EnumFacing getMetadataFromDirection(int i, int j) {
        return EnumFacing.func_176731_b((int)BlockWritingDesk.getMetadataFromDirectionInternal(i, j));
    }

    private static int getMetadataFromDirectionInternal(int i, int j) {
        if (j == 1) {
            return 0;
        }
        if (i == -1) {
            return 1;
        }
        if (j == -1) {
            return 2;
        }
        if (i == 1) {
            return 3;
        }
        return 0;
    }

    public static EnumFacing getDirectionFromMetadata(IBlockState state) {
        if (!state.func_177230_c().equals(ModBlocks.writingdesk)) {
            return EnumFacing.NORTH;
        }
        return (EnumFacing)state.func_177229_b(ROTATION);
    }

    public static boolean isBlockFoot(IBlockState state) {
        return state.func_177230_c().equals(ModBlocks.writingdesk) && (Boolean)state.func_177229_b((IProperty)IS_FOOT) != false;
    }

    public static boolean isBlockTop(IBlockState state) {
        return state.func_177230_c().equals(ModBlocks.writingdesk) && (Boolean)state.func_177229_b((IProperty)IS_TOP) != false;
    }

    public static TileEntityDesk getTileEntity(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (BlockWritingDesk.isBlockTop(state)) {
            return BlockWritingDesk.getTileEntity(world, pos.func_177977_b());
        }
        if (BlockWritingDesk.isBlockFoot(state)) {
            EnumFacing direction = BlockWritingDesk.getDirectionFromMetadata(state);
            int dirInt = direction.func_176736_b();
            BlockPos at = pos.func_177982_a(-headFootMap[dirInt][0], 0, -headFootMap[dirInt][1]);
            return (TileEntityDesk)world.func_175625_s(at);
        }
        return (TileEntityDesk)world.func_175625_s(pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return !BlockWritingDesk.isBlockFoot(state) && !BlockWritingDesk.isBlockTop(state);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityDesk();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (this.hasTileEntity(state)) {
            worldIn.func_175690_a(pos, this.createTileEntity(worldIn, state));
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockPos offset;
        if (!worldIn.func_180495_p(pos).func_177230_c().equals((Object)this)) {
            return;
        }
        EnumFacing face = placer.func_174811_aO();
        int facing = face.func_176736_b();
        int xOffset = 0;
        int zOffset = 0;
        if (facing == 0) {
            zOffset = 1;
        }
        if (facing == 1) {
            xOffset = -1;
        }
        if (facing == 2) {
            zOffset = -1;
        }
        if (facing == 3) {
            xOffset = 1;
        }
        if (worldIn.func_175623_d(offset = pos.func_177982_a(xOffset, 0, zOffset))) {
            worldIn.func_175656_a(offset, this.func_176223_P().func_177226_a(ROTATION, (Comparable)face).func_177226_a((IProperty)IS_FOOT, (Comparable)Boolean.valueOf(true)));
        } else {
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null) {
            te.func_145842_c(id, param);
        }
        return false;
    }
}

