/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.api.util;

public final class Color {
    public final float r;
    public final float g;
    public final float b;

    public Color(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public Color(int color) {
        this.r = (float)(color >> 16 & 0xFF) / 255.0f;
        this.g = (float)(color >> 8 & 0xFF) / 255.0f;
        this.b = (float)(color & 0xFF) / 255.0f;
    }

    public Color(java.awt.Color color) {
        this.r = color.getRed();
        this.g = color.getGreen();
        this.b = color.getBlue();
    }

    public Color average(Color other) {
        Color color = new Color((this.r + other.r) / 2.0f, (this.g + other.g) / 2.0f, (this.b + other.b) / 2.0f);
        return color;
    }

    public Color average(float red, float green, float blue) {
        Color color = new Color((this.r + red) / 2.0f, (this.g + green) / 2.0f, (this.b + blue) / 2.0f);
        return color;
    }

    public int asInt() {
        int iColor = (int)(this.r * 255.0f) << 16;
        iColor += (int)(this.g * 255.0f) << 8;
        return iColor += (int)(this.b * 255.0f);
    }

    public java.awt.Color toAWT() {
        return new java.awt.Color(this.r, this.g, this.b);
    }

    public String toString() {
        return String.format("Color component: (%.2f, %.2f, %.2f)", Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
    }
}

