/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base.target;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import mekanism.common.base.SplitInfo;
import net.minecraft.util.EnumFacing;

public abstract class Target<HANDLER, TYPE extends Number, EXTRA> {
    protected final Map<EnumFacing, HANDLER> handlers = new EnumMap<EnumFacing, HANDLER>(EnumFacing.class);
    protected final Map<EnumFacing, TYPE> needed = new EnumMap<EnumFacing, TYPE>(EnumFacing.class);
    protected EXTRA extra;

    public void addHandler(EnumFacing side, HANDLER handler) {
        this.handlers.put(side, handler);
    }

    public Map<EnumFacing, HANDLER> getHandlers() {
        return this.handlers;
    }

    public void sendRemainingSplit(SplitInfo<TYPE> splitInfo) {
        for (EnumFacing side : this.needed.keySet()) {
            this.acceptAmount(side, splitInfo, splitInfo.getAmountPerTarget());
        }
    }

    protected abstract void acceptAmount(EnumFacing var1, SplitInfo<TYPE> var2, TYPE var3);

    protected abstract TYPE simulate(HANDLER var1, EnumFacing var2, EXTRA var3);

    public void sendPossible(EXTRA toSend, SplitInfo<TYPE> splitInfo) {
        for (Map.Entry<EnumFacing, HANDLER> entry : this.handlers.entrySet()) {
            TYPE amountNeeded = this.simulate(entry.getValue(), entry.getKey(), toSend);
            if (((Comparable)amountNeeded).compareTo(splitInfo.getAmountPerTarget()) <= 0) {
                this.acceptAmount(entry.getKey(), splitInfo, amountNeeded);
                continue;
            }
            this.needed.put(entry.getKey(), amountNeeded);
        }
    }

    public void shiftNeeded(SplitInfo<TYPE> splitInfo) {
        Iterator<Map.Entry<EnumFacing, TYPE>> iterator = this.needed.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EnumFacing, TYPE> needInfo = iterator.next();
            Number amountNeeded = (Number)needInfo.getValue();
            if (((Comparable)((Object)amountNeeded)).compareTo(splitInfo.getAmountPerTarget()) > 0) continue;
            this.acceptAmount(needInfo.getKey(), splitInfo, amountNeeded);
            iterator.remove();
        }
    }
}

