/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.filter.GuiTypeFilter;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public abstract class GuiMaterialFilter<FILTER extends IMaterialFilter, TILE extends TileEntityContainerBlock>
extends GuiTypeFilter<FILTER, TILE> {
    protected GuiMaterialFilter(EntityPlayer player, TILE tile) {
        super(player, tile);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.saveButton.field_146127_k) {
            if (!((IMaterialFilter)this.filter).getMaterialItem().func_190926_b()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(0);
            } else {
                this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.itemFilter.noItem");
                this.ticker = 20;
            }
        } else if (guibutton.field_146127_k == this.deleteButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), true, this.origFilter, null));
            this.sendPacketToServer(0);
        } else if (this.tileEntity instanceof TileEntityDigitalMiner && this.filter instanceof MinerFilter) {
            this.actionPerformedMinerCommon(guibutton, (MinerFilter)this.filter);
        } else if (this.tileEntity instanceof TileEntityLogisticalSorter && this.filter instanceof TransporterFilter) {
            this.actionPerformedTransporter(guibutton, (TransporterFilter)this.filter);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.ticker > 0) {
            --this.ticker;
        } else {
            this.status = (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.allOK");
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b((this.isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.materialFilter"), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.status") + ": " + this.status, 35, 20, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.materialFilter.details") + ":", 35, 32, 52480);
        this.drawForegroundLayer(mouseX, mouseY);
        super.func_146979_b(mouseX, mouseY);
    }

    protected void materialMouseClicked() {
        ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!stack.func_190926_b() && !Keyboard.isKeyDown((int)42)) {
            if (stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150357_h) {
                ((IMaterialFilter)this.filter).setMaterialItem(stack.func_77946_l());
                ((IMaterialFilter)this.filter).getMaterialItem().func_190920_e(1);
            }
        } else if (stack.func_190926_b() && Keyboard.isKeyDown((int)42)) {
            ((IMaterialFilter)this.filter).setMaterialItem(ItemStack.field_190927_a);
        }
        SoundHandler.playSound(SoundEvents.field_187909_gi);
    }
}

