package mekanism.tools.item;

import java.util.List;
import java.util.Set;

import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.util.LangUtils;
import mekanism.common.util.StackUtils;
import mekanism.tools.common.MekanismTools;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;

import net.minecraft.item.Item.ToolMaterial;

public class ItemMekanismTool extends ItemTool
{
	public ItemMekanismTool(float attack, float speed, ToolMaterial toolMaterial, Set<Block> effectiveBlocksIn)
	{
		super(attack, speed, toolMaterial, effectiveBlocksIn);
		func_77637_a(Mekanism.tabMekanism);
	}

	@Override
	public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag)
	{
		list.add(LangUtils.localize("tooltip.hp") + ": " + (itemstack.func_77958_k() - itemstack.func_77952_i()));
	}
	
	@Override
    public boolean func_82789_a(ItemStack stack1, ItemStack stack2)
    {
        return StackUtils.equalsWildcard(getRepairStack(), stack2) ? true : super.func_82789_a(stack1, stack2);
    }
    
    private ItemStack getRepairStack()
    {
    	return getRepairStack(field_77862_b);
    }
    
    public static ItemStack getRepairStack(ToolMaterial material)
    {
    	if(material == MekanismTools.toolOBSIDIAN || material == MekanismTools.toolOBSIDIAN2)
    	{
    		return new ItemStack(MekanismItems.Ingot, 1, 0);
    	}
    	else if(material == MekanismTools.toolLAZULI || material == MekanismTools.toolLAZULI2)
    	{
    		return new ItemStack(Items.field_151100_aR, 1, 4);
    	}
    	else if(material == MekanismTools.toolOSMIUM || material == MekanismTools.toolOSMIUM2)
    	{
    		return new ItemStack(MekanismItems.Ingot, 1, 1);
    	}
    	else if(material == MekanismTools.toolBRONZE || material == MekanismTools.toolBRONZE2)
    	{
    		return new ItemStack(MekanismItems.Ingot, 1, 2);
    	}
    	else if(material == MekanismTools.toolGLOWSTONE || material == MekanismTools.toolGLOWSTONE2)
    	{
    		return new ItemStack(MekanismItems.Ingot, 1, 3);
    	}
    	else if(material == MekanismTools.toolSTEEL || material == MekanismTools.toolSTEEL2)
    	{
    		return new ItemStack(MekanismItems.Ingot, 1, 4);
    	}
    	
    	return material.getRepairItemStack();
    }
}
