package mekanism.tools.item;

import java.util.Set;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import com.google.common.collect.Sets;

import net.minecraft.item.Item.ToolMaterial;

public class ItemMekanismShovel extends ItemMekanismTool
{
	private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet(new Block[] {Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150425_aM, Blocks.field_185774_da});

	public ItemMekanismShovel(ToolMaterial enumtoolmaterial)
	{
		super(1.5F, -3, enumtoolmaterial, EFFECTIVE_ON);
	}

	@Override
	public boolean canHarvestBlock(IBlockState state, ItemStack stack)
	{
        Block block = state.func_177230_c();
        return block == Blocks.field_150431_aC || block == Blocks.field_150433_aE;
	}
	
	@Override
	public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ)
    {
		ItemStack stack = playerIn.func_184586_b(hand);
		
        if(!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack))
        {
            return EnumActionResult.FAIL;
        }
        else {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();

            if(facing != EnumFacing.DOWN && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && block == Blocks.field_150349_c)
            {
                IBlockState iblockstate1 = Blocks.field_185774_da.func_176223_P();
                worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0F, 1.0F);

                if(!worldIn.field_72995_K)
                {
                    worldIn.func_180501_a(pos, iblockstate1, 11);
                    stack.func_77972_a(1, playerIn);
                }

                return EnumActionResult.SUCCESS;
            }
            else {
                return EnumActionResult.PASS;
            }
        }
    }
}
