package mekanism.tools.item;

import java.util.Set;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

import com.google.common.collect.Sets;

import net.minecraft.item.Item.ToolMaterial;

public class ItemMekanismPickaxe extends ItemMekanismTool
{
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet(new Block[] {Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au});

	public ItemMekanismPickaxe(ToolMaterial toolMaterial)
	{
		super(1, -2.8F, toolMaterial, EFFECTIVE_ON);
	}

	@Override
	public boolean canHarvestBlock(IBlockState state, ItemStack stack)
	{
		Block block = state.func_177230_c();
		
		if(block == Blocks.field_150343_Z)
		{
			return field_77862_b.func_77996_d() == 3;
		}

		if(block == Blocks.field_150484_ah || block == Blocks.field_150482_ag)
		{
			return field_77862_b.func_77996_d() >= 2;
		}

		if(block == Blocks.field_150340_R || block == Blocks.field_150352_o)
		{
			return field_77862_b.func_77996_d() >= 2;
		}

		if(block == Blocks.field_150339_S || block == Blocks.field_150366_p)
		{
			return field_77862_b.func_77996_d() >= 1;
		}

		if(block == Blocks.field_150368_y || block == Blocks.field_150369_x)
		{
			return field_77862_b.func_77996_d() >= 1;
		}

		if(block == Blocks.field_150450_ax || block == Blocks.field_150439_ay)
		{
			return field_77862_b.func_77996_d() >= 2;
		}

		if(block == Blocks.field_150467_bQ)
		{
			return field_77862_b.func_77996_d() >= 0;
		}

		if(state.func_185904_a() == Material.field_151576_e)
		{
			return true;
		}

		return state.func_185904_a() == Material.field_151573_f;
	}

	@Override
	public float func_150893_a(ItemStack itemstack, IBlockState blockState)
	{
		if(blockState != null && blockState.func_177230_c() != null && (blockState.func_185904_a() == Material.field_151573_f || blockState.func_185904_a() == Material.field_151574_g || blockState.func_185904_a() == Material.field_151576_e))
		{
			return field_77864_a;
		}
		else {
			return super.func_150893_a(itemstack, blockState);
		}
	}
}
