package mekanism.tools.item;

import java.util.List;

import mekanism.common.item.ItemMekanism;
import mekanism.common.util.LangUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import com.google.common.collect.Multimap;

import net.minecraft.item.Item.ToolMaterial;

public class ItemMekanismHoe extends ItemMekanism
{
	protected ToolMaterial toolMaterial;
	
	private final float speed;

	public ItemMekanismHoe(ToolMaterial enumtoolmaterial)
	{
		super();
		toolMaterial = enumtoolmaterial;
		func_77625_d(1);
		func_77656_e(enumtoolmaterial.func_77997_a());
		func_77637_a(CreativeTabs.field_78040_i);
		speed = enumtoolmaterial.func_78000_c() + 1.0F;
	}
	
	@Override
    public boolean func_82789_a(ItemStack stack1, ItemStack stack2)
    {
        return StackUtils.equalsWildcard(ItemMekanismTool.getRepairStack(toolMaterial), stack2) ? true : super.func_82789_a(stack1, stack2);
    }

	@Override
	@SuppressWarnings("incomplete-switch")
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ)
    {
		ItemStack stack = playerIn.func_184586_b(hand);
		
        if(!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack))
        {
            return EnumActionResult.FAIL;
        }
        else {
            int hook = net.minecraftforge.event.ForgeEventFactory.onHoeUse(stack, playerIn, worldIn, pos);
            if(hook != 0) return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;

            IBlockState iblockstate = worldIn.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();

            if(facing != EnumFacing.DOWN && worldIn.func_175623_d(pos.func_177984_a()))
            {
                if(block == Blocks.field_150349_c || block == Blocks.field_185774_da)
                {
                    setBlock(stack, playerIn, worldIn, pos, Blocks.field_150458_ak.func_176223_P());
                    return EnumActionResult.SUCCESS;
                }

                if(block == Blocks.field_150346_d)
                {
                    switch((BlockDirt.DirtType)iblockstate.func_177229_b(BlockDirt.field_176386_a))
                    {
                        case DIRT:
                            setBlock(stack, playerIn, worldIn, pos, Blocks.field_150458_ak.func_176223_P());
                            return EnumActionResult.SUCCESS;
                        case COARSE_DIRT:
                            setBlock(stack, playerIn, worldIn, pos, Blocks.field_150346_d.func_176223_P().func_177226_a(BlockDirt.field_176386_a, BlockDirt.DirtType.DIRT));
                            return EnumActionResult.SUCCESS;
                    }
                }
            }

            return EnumActionResult.PASS;
        }
    }
	
	protected void setBlock(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state)
    {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0F, 1.0F);

        if(!worldIn.field_72995_K)
        {
            worldIn.func_180501_a(pos, state, 11);
            stack.func_77972_a(1, player);
        }
    }
	
	@Override
	public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack)
    {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(equipmentSlot, stack);

        if(equipmentSlot == EntityEquipmentSlot.MAINHAND)
        {
            multimap.put(SharedMonsterAttributes.field_111264_e.func_111108_a(), new AttributeModifier(field_111210_e, "Weapon modifier", 0.0D, 0));
            multimap.put(SharedMonsterAttributes.field_188790_f.func_111108_a(), new AttributeModifier(field_185050_h, "Weapon modifier", (double)(this.speed - 4.0F), 0));
        }

        return multimap;
    }
	
	@Override
	public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker)
    {
        stack.func_77972_a(1, attacker);
        
        return true;
    }

	@Override
	public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag)
	{
		list.add(LangUtils.localize("tooltip.hp") + ": " + (itemstack.func_77958_k() - itemstack.func_77952_i()));
	}

	@Override
	@SideOnly(Side.CLIENT)
	public boolean func_77662_d()
	{
		return true;
	}
}
