package mekanism.tools.item;

import java.util.List;

import mekanism.common.Mekanism;
import mekanism.common.util.LangUtils;
import mekanism.common.util.StackUtils;
import mekanism.tools.common.MekanismTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;

import net.minecraft.item.Item.ToolMaterial;

public class ItemMekanismAxe extends ItemAxe
{
	public ItemMekanismAxe(ToolMaterial tool)
	{
		super(tool, MekanismTools.AXE_DAMAGE.get(tool), MekanismTools.AXE_SPEED.get(tool));
		func_77637_a(Mekanism.tabMekanism);
	}

	@Override
	public void func_77624_a(ItemStack itemstack, EntityPlayer playerIn, List<String> list, boolean advanced)
	{
		list.add(LangUtils.localize("tooltip.hp") + ": " + (itemstack.func_77958_k() - itemstack.func_77952_i()));
	}

	@Override
	public boolean func_82789_a(ItemStack toRepair, ItemStack repair)
	{
		return StackUtils.equalsWildcard(ItemMekanismTool.getRepairStack(field_77862_b), repair) || super.func_82789_a(toRepair, repair);
	}
}
