package mekanism.tools.item;

import java.util.List;

import mekanism.client.render.ModelCustomArmor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.util.LangUtils;
import mekanism.common.util.StackUtils;
import mekanism.tools.common.MekanismTools;
import mekanism.tools.common.ToolsItems;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import net.minecraft.item.ItemArmor.ArmorMaterial;

public class ItemMekanismArmor extends ItemArmor
{
	public ItemMekanismArmor(ArmorMaterial enumarmormaterial, int renderIndex, EntityEquipmentSlot slot)
	{
		super(enumarmormaterial, renderIndex, slot);
		func_77637_a(Mekanism.tabMekanism);
	}

	@Override
	public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag)
	{
		list.add(LangUtils.localize("tooltip.hp") + ": " + (itemstack.func_77958_k() - itemstack.func_77952_i()));
	}

	@Override
	public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type)
	{
		int layer = (slot == EntityEquipmentSlot.LEGS) ? 2 : 1;
		return "mekanism:armor/" + func_82812_d().name().toLowerCase() + "_" + layer + ".png";
	}
	
	@Override
    public boolean func_82789_a(ItemStack stack1, ItemStack stack2)
    {
        return StackUtils.equalsWildcard(getRepairStack(), stack2) ? true : super.func_82789_a(stack1, stack2);
    }
	
    private ItemStack getRepairStack()
    {
    	if(func_82812_d() == MekanismTools.armorOBSIDIAN)
    	{
    		return new ItemStack(MekanismItems.Ingot, 1, 0);
    	}
    	else if(func_82812_d() == MekanismTools.armorLAZULI)
    	{
    		return new ItemStack(Items.field_151100_aR, 1, 4);
    	}
    	else if(func_82812_d() == MekanismTools.armorOSMIUM)
    	{
    		return new ItemStack(MekanismItems.Ingot, 1, 1);
    	}
    	else if(func_82812_d() == MekanismTools.armorBRONZE)
    	{
    		return new ItemStack(MekanismItems.Ingot, 1, 2);
    	}
    	else if(func_82812_d() == MekanismTools.armorGLOWSTONE)
    	{
    		return new ItemStack(MekanismItems.Ingot, 1, 3);
    	}
    	else if(func_82812_d() == MekanismTools.armorSTEEL)
    	{
    		return new ItemStack(MekanismItems.Ingot, 1, 4);
    	}
    	
    	return new ItemStack(func_82812_d().func_151685_b());
    }

	@Override
	@SideOnly(Side.CLIENT)
	public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default)
	{
		if(itemStack.func_77973_b() == ToolsItems.GlowstoneHelmet || itemStack.func_77973_b() == ToolsItems.GlowstoneChestplate ||
				itemStack.func_77973_b() == ToolsItems.GlowstoneLeggings || itemStack.func_77973_b() == ToolsItems.GlowstoneBoots)
		{
			return ModelCustomArmor.getGlow(armorSlot);
		}

		return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
	}
}
