package mekanism.tools.common;

import mekanism.tools.item.ItemMekanismArmor;
import mekanism.tools.item.ItemMekanismAxe;
import mekanism.tools.item.ItemMekanismHoe;
import mekanism.tools.item.ItemMekanismPaxel;
import mekanism.tools.item.ItemMekanismPickaxe;
import mekanism.tools.item.ItemMekanismShovel;
import mekanism.tools.item.ItemMekanismSword;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.Item.ToolMaterial;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry.ObjectHolder;

@ObjectHolder("mekanismtools")
public class ToolsItems
{
	//Vanilla Material Paxels
	public static Item WoodPaxel;
	public static Item StonePaxel;
	public static Item IronPaxel;
	public static Item DiamondPaxel;
	public static Item GoldPaxel;

	//Glowstone Items
	public static Item GlowstonePaxel;
	public static Item GlowstonePickaxe;
	public static Item GlowstoneAxe;
	public static Item GlowstoneShovel;
	public static Item GlowstoneHoe;
	public static Item GlowstoneSword;
	public static Item GlowstoneHelmet;
	public static Item GlowstoneChestplate;
	public static Item GlowstoneLeggings;
	public static Item GlowstoneBoots;

	//Bronze Items
	public static Item BronzePaxel;
	public static Item BronzePickaxe;
	public static Item BronzeAxe;
	public static Item BronzeShovel;
	public static Item BronzeHoe;
	public static Item BronzeSword;
	public static Item BronzeHelmet;
	public static Item BronzeChestplate;
	public static Item BronzeLeggings;
	public static Item BronzeBoots;

	//Osmium Items
	public static Item OsmiumPaxel;
	public static Item OsmiumPickaxe;
	public static Item OsmiumAxe;
	public static Item OsmiumShovel;
	public static Item OsmiumHoe;
	public static Item OsmiumSword;
	public static Item OsmiumHelmet;
	public static Item OsmiumChestplate;
	public static Item OsmiumLeggings;
	public static Item OsmiumBoots;

	//Obsidian Items
	public static Item ObsidianPaxel;
	public static Item ObsidianPickaxe;
	public static Item ObsidianAxe;
	public static Item ObsidianShovel;
	public static Item ObsidianHoe;
	public static Item ObsidianSword;
	public static Item ObsidianHelmet;
	public static Item ObsidianChestplate;
	public static Item ObsidianLeggings;
	public static Item ObsidianBoots;

	//Lazuli Items
	public static Item LazuliPaxel;
	public static Item LazuliPickaxe;
	public static Item LazuliAxe;
	public static Item LazuliShovel;
	public static Item LazuliHoe;
	public static Item LazuliSword;
	public static Item LazuliHelmet;
	public static Item LazuliChestplate;
	public static Item LazuliLeggings;
	public static Item LazuliBoots;

	//Steel Items
	public static Item SteelPaxel;
	public static Item SteelPickaxe;
	public static Item SteelAxe;
	public static Item SteelShovel;
	public static Item SteelHoe;
	public static Item SteelSword;
	public static Item SteelHelmet;
	public static Item SteelChestplate;
	public static Item SteelLeggings;
	public static Item SteelBoots;

	public static void initializeItems()
	{
		WoodPaxel = init(new ItemMekanismPaxel(ToolMaterial.WOOD), "WoodPaxel");
		StonePaxel = init(new ItemMekanismPaxel(ToolMaterial.STONE), "StonePaxel");
		IronPaxel = init(new ItemMekanismPaxel(ToolMaterial.IRON), "IronPaxel");
		DiamondPaxel = init(new ItemMekanismPaxel(ToolMaterial.DIAMOND), "DiamondPaxel");
		GoldPaxel = init(new ItemMekanismPaxel(ToolMaterial.GOLD), "GoldPaxel");
		GlowstonePaxel = init(new ItemMekanismPaxel(MekanismTools.toolGLOWSTONE2), "GlowstonePaxel");
		GlowstonePickaxe = init(new ItemMekanismPickaxe(MekanismTools.toolGLOWSTONE), "GlowstonePickaxe");
		GlowstoneAxe = init(new ItemMekanismAxe(MekanismTools.toolGLOWSTONE), "GlowstoneAxe");
		GlowstoneShovel = init(new ItemMekanismShovel(MekanismTools.toolGLOWSTONE), "GlowstoneShovel");
		GlowstoneHoe = init(new ItemMekanismHoe(MekanismTools.toolGLOWSTONE), "GlowstoneHoe");
		GlowstoneSword = init(new ItemMekanismSword(MekanismTools.toolGLOWSTONE), "GlowstoneSword");
		GlowstoneHelmet = init(new ItemMekanismArmor(MekanismTools.armorGLOWSTONE, 0, EntityEquipmentSlot.HEAD), "GlowstoneHelmet");
		GlowstoneChestplate = init(new ItemMekanismArmor(MekanismTools.armorGLOWSTONE, 1, EntityEquipmentSlot.CHEST), "GlowstoneChestplate");
		GlowstoneLeggings = init(new ItemMekanismArmor(MekanismTools.armorGLOWSTONE, 2, EntityEquipmentSlot.LEGS), "GlowstoneLeggings");
		GlowstoneBoots = init(new ItemMekanismArmor(MekanismTools.armorGLOWSTONE, 3, EntityEquipmentSlot.FEET), "GlowstoneBoots");
		BronzePaxel = init(new ItemMekanismPaxel(MekanismTools.toolBRONZE2), "BronzePaxel");
		BronzePickaxe = init(new ItemMekanismPickaxe(MekanismTools.toolBRONZE), "BronzePickaxe");
		BronzeAxe = init(new ItemMekanismAxe(MekanismTools.toolBRONZE), "BronzeAxe");
		BronzeShovel = init(new ItemMekanismShovel(MekanismTools.toolBRONZE), "BronzeShovel");
		BronzeHoe = init(new ItemMekanismHoe(MekanismTools.toolBRONZE), "BronzeHoe");
		BronzeSword = init(new ItemMekanismSword(MekanismTools.toolBRONZE), "BronzeSword");
		BronzeHelmet = init(new ItemMekanismArmor(MekanismTools.armorBRONZE, 0, EntityEquipmentSlot.HEAD), "BronzeHelmet");
		BronzeChestplate = init(new ItemMekanismArmor(MekanismTools.armorBRONZE, 1, EntityEquipmentSlot.CHEST), "BronzeChestplate");
		BronzeLeggings = init(new ItemMekanismArmor(MekanismTools.armorBRONZE, 2, EntityEquipmentSlot.LEGS), "BronzeLeggings");
		BronzeBoots = init(new ItemMekanismArmor(MekanismTools.armorBRONZE, 3, EntityEquipmentSlot.FEET), "BronzeBoots");
		OsmiumPaxel = init(new ItemMekanismPaxel(MekanismTools.toolOSMIUM2), "OsmiumPaxel");
		OsmiumPickaxe = init(new ItemMekanismPickaxe(MekanismTools.toolOSMIUM), "OsmiumPickaxe");
		OsmiumAxe = init(new ItemMekanismAxe(MekanismTools.toolOSMIUM), "OsmiumAxe");
		OsmiumShovel = init(new ItemMekanismShovel(MekanismTools.toolOSMIUM), "OsmiumShovel");
		OsmiumHoe = init(new ItemMekanismHoe(MekanismTools.toolOSMIUM), "OsmiumHoe");
		OsmiumSword = init(new ItemMekanismSword(MekanismTools.toolOSMIUM), "OsmiumSword");
		OsmiumHelmet = init(new ItemMekanismArmor(MekanismTools.armorOSMIUM, 0, EntityEquipmentSlot.HEAD), "OsmiumHelmet");
		OsmiumChestplate = init(new ItemMekanismArmor(MekanismTools.armorOSMIUM, 1, EntityEquipmentSlot.CHEST), "OsmiumChestplate");
		OsmiumLeggings = init(new ItemMekanismArmor(MekanismTools.armorOSMIUM, 2, EntityEquipmentSlot.LEGS), "OsmiumLeggings");
		OsmiumBoots = init(new ItemMekanismArmor(MekanismTools.armorOSMIUM, 3, EntityEquipmentSlot.FEET), "OsmiumBoots");
		ObsidianPaxel = init(new ItemMekanismPaxel(MekanismTools.toolOBSIDIAN2), "ObsidianPaxel");
		ObsidianPickaxe = init(new ItemMekanismPickaxe(MekanismTools.toolOBSIDIAN), "ObsidianPickaxe");
		ObsidianAxe = init(new ItemMekanismAxe(MekanismTools.toolOBSIDIAN), "ObsidianAxe");
		ObsidianShovel = init(new ItemMekanismShovel(MekanismTools.toolOBSIDIAN), "ObsidianShovel");
		ObsidianHoe = init(new ItemMekanismHoe(MekanismTools.toolOBSIDIAN), "ObsidianHoe");
		ObsidianSword = init(new ItemMekanismSword(MekanismTools.toolOBSIDIAN), "ObsidianSword");
		ObsidianHelmet = init(new ItemMekanismArmor(MekanismTools.armorOBSIDIAN, 0, EntityEquipmentSlot.HEAD), "ObsidianHelmet");
		ObsidianChestplate = init(new ItemMekanismArmor(MekanismTools.armorOBSIDIAN, 1, EntityEquipmentSlot.CHEST), "ObsidianChestplate");
		ObsidianLeggings = init(new ItemMekanismArmor(MekanismTools.armorOBSIDIAN, 2, EntityEquipmentSlot.LEGS), "ObsidianLeggings");
		ObsidianBoots = init(new ItemMekanismArmor(MekanismTools.armorOBSIDIAN, 3, EntityEquipmentSlot.FEET), "ObsidianBoots");
		LazuliPaxel = init(new ItemMekanismPaxel(MekanismTools.toolLAZULI2), "LapisLazuliPaxel");
		LazuliPickaxe = init(new ItemMekanismPickaxe(MekanismTools.toolLAZULI), "LapisLazuliPickaxe");
		LazuliAxe = init(new ItemMekanismAxe(MekanismTools.toolLAZULI), "LapisLazuliAxe");
		LazuliShovel = init(new ItemMekanismShovel(MekanismTools.toolLAZULI), "LapisLazuliShovel");
		LazuliHoe = init(new ItemMekanismHoe(MekanismTools.toolLAZULI), "LapisLazuliHoe");
		LazuliSword = init(new ItemMekanismSword(MekanismTools.toolLAZULI), "LapisLazuliSword");
		LazuliHelmet = init(new ItemMekanismArmor(MekanismTools.armorLAZULI, 0, EntityEquipmentSlot.HEAD), "LapisLazuliHelmet");
		LazuliChestplate = init(new ItemMekanismArmor(MekanismTools.armorLAZULI, 1, EntityEquipmentSlot.CHEST), "LapisLazuliChestplate");
		LazuliLeggings = init(new ItemMekanismArmor(MekanismTools.armorLAZULI, 2, EntityEquipmentSlot.LEGS), "LapisLazuliLeggings");
		LazuliBoots = init(new ItemMekanismArmor(MekanismTools.armorLAZULI, 3, EntityEquipmentSlot.FEET), "LapisLazuliBoots");
		SteelPaxel = init(new ItemMekanismPaxel(MekanismTools.toolSTEEL2), "SteelPaxel");
		SteelPickaxe = init(new ItemMekanismPickaxe(MekanismTools.toolSTEEL), "SteelPickaxe");
		SteelAxe = init(new ItemMekanismAxe(MekanismTools.toolSTEEL), "SteelAxe");
		SteelShovel = init(new ItemMekanismShovel(MekanismTools.toolSTEEL), "SteelShovel");
		SteelHoe = init(new ItemMekanismHoe(MekanismTools.toolSTEEL), "SteelHoe");
		SteelSword = init(new ItemMekanismSword(MekanismTools.toolSTEEL), "SteelSword");
		SteelHelmet = init(new ItemMekanismArmor(MekanismTools.armorSTEEL, 0, EntityEquipmentSlot.HEAD), "SteelHelmet");
		SteelChestplate = init(new ItemMekanismArmor(MekanismTools.armorSTEEL, 1, EntityEquipmentSlot.CHEST), "SteelChestplate");
		SteelLeggings = init(new ItemMekanismArmor(MekanismTools.armorSTEEL, 2, EntityEquipmentSlot.LEGS), "SteelLeggings");
		SteelBoots = init(new ItemMekanismArmor(MekanismTools.armorSTEEL, 3, EntityEquipmentSlot.FEET), "SteelBoots");
	}

	public static void setHarvestLevels()
	{
		setPaxelHarvest(BronzePaxel, MekanismTools.toolBRONZE2);
		BronzePickaxe.setHarvestLevel("pickaxe", MekanismTools.toolBRONZE.func_77996_d());
		BronzeAxe.setHarvestLevel("axe", MekanismTools.toolBRONZE.func_77996_d());
		BronzeShovel.setHarvestLevel("shovel", MekanismTools.toolBRONZE.func_77996_d());

		setPaxelHarvest(OsmiumPaxel, MekanismTools.toolOSMIUM2);
		OsmiumPickaxe.setHarvestLevel("pickaxe", MekanismTools.toolOSMIUM.func_77996_d());
		OsmiumAxe.setHarvestLevel("axe", MekanismTools.toolOSMIUM.func_77996_d());
		OsmiumShovel.setHarvestLevel("shovel", MekanismTools.toolOSMIUM.func_77996_d());

		setPaxelHarvest(ObsidianPaxel, MekanismTools.toolOBSIDIAN2);
		ObsidianPickaxe.setHarvestLevel("pickaxe", MekanismTools.toolOBSIDIAN.func_77996_d());
		ObsidianAxe.setHarvestLevel("axe", MekanismTools.toolOBSIDIAN.func_77996_d());
		ObsidianShovel.setHarvestLevel("shovel", MekanismTools.toolOBSIDIAN.func_77996_d());

		setPaxelHarvest(LazuliPaxel, MekanismTools.toolLAZULI2);
		LazuliPickaxe.setHarvestLevel("pickaxe", MekanismTools.toolLAZULI.func_77996_d());
		LazuliAxe.setHarvestLevel("axe", MekanismTools.toolLAZULI.func_77996_d());
		LazuliShovel.setHarvestLevel("shovel", MekanismTools.toolLAZULI.func_77996_d());

		setPaxelHarvest(GlowstonePaxel, MekanismTools.toolGLOWSTONE2);
		GlowstonePickaxe.setHarvestLevel("pickaxe", MekanismTools.toolGLOWSTONE.func_77996_d());
		GlowstoneAxe.setHarvestLevel("axe", MekanismTools.toolGLOWSTONE.func_77996_d());
		GlowstoneShovel.setHarvestLevel("shovel", MekanismTools.toolGLOWSTONE.func_77996_d());

		setPaxelHarvest(SteelPaxel, MekanismTools.toolSTEEL2);
		SteelPickaxe.setHarvestLevel("pickaxe", MekanismTools.toolSTEEL.func_77996_d());
		SteelAxe.setHarvestLevel("axe", MekanismTools.toolSTEEL.func_77996_d());
		SteelShovel.setHarvestLevel("shovel", MekanismTools.toolSTEEL.func_77996_d());

		setPaxelHarvest(WoodPaxel, ToolMaterial.WOOD);
		setPaxelHarvest(StonePaxel, ToolMaterial.STONE);
		setPaxelHarvest(IronPaxel, ToolMaterial.IRON);
		setPaxelHarvest(DiamondPaxel, ToolMaterial.DIAMOND);
		setPaxelHarvest(GoldPaxel, ToolMaterial.GOLD);
	}
	
	private static void setPaxelHarvest(Item item, ToolMaterial material)
	{
		item.setHarvestLevel("pickaxe", material.func_77996_d());
		item.setHarvestLevel("axe", material.func_77996_d());
		item.setHarvestLevel("shovel", material.func_77996_d());
	}

	public static void register()
	{
		//Base
		GameRegistry.register(WoodPaxel);
		GameRegistry.register(StonePaxel);
		GameRegistry.register(IronPaxel);
		GameRegistry.register(DiamondPaxel);
		GameRegistry.register(GoldPaxel);

		//Obsidian
		GameRegistry.register(ObsidianHelmet);
		GameRegistry.register(ObsidianChestplate);
		GameRegistry.register(ObsidianLeggings);
		GameRegistry.register(ObsidianBoots);
		GameRegistry.register(ObsidianPaxel);
		GameRegistry.register(ObsidianPickaxe);
		GameRegistry.register(ObsidianAxe);
		GameRegistry.register(ObsidianShovel);
		GameRegistry.register(ObsidianHoe);
		GameRegistry.register(ObsidianSword);

		//Lazuli
		GameRegistry.register(LazuliHelmet);
		GameRegistry.register(LazuliChestplate);
		GameRegistry.register(LazuliLeggings);
		GameRegistry.register(LazuliBoots);
		GameRegistry.register(LazuliPaxel);
		GameRegistry.register(LazuliPickaxe);
		GameRegistry.register(LazuliAxe);
		GameRegistry.register(LazuliShovel);
		GameRegistry.register(LazuliHoe);
		GameRegistry.register(LazuliSword);

		//Osmium
		GameRegistry.register(OsmiumHelmet);
		GameRegistry.register(OsmiumChestplate);
		GameRegistry.register(OsmiumLeggings);
		GameRegistry.register(OsmiumBoots);
		GameRegistry.register(OsmiumPaxel);
		GameRegistry.register(OsmiumPickaxe);
		GameRegistry.register(OsmiumAxe);
		GameRegistry.register(OsmiumShovel);
		GameRegistry.register(OsmiumHoe);
		GameRegistry.register(OsmiumSword);

		//Bronze
		GameRegistry.register(BronzeHelmet);
		GameRegistry.register(BronzeChestplate);
		GameRegistry.register(BronzeLeggings);
		GameRegistry.register(BronzeBoots);
		GameRegistry.register(BronzePaxel);
		GameRegistry.register(BronzePickaxe);
		GameRegistry.register(BronzeAxe);
		GameRegistry.register(BronzeShovel);
		GameRegistry.register(BronzeHoe);
		GameRegistry.register(BronzeSword);

		//Glowstone
		GameRegistry.register(GlowstonePaxel);
		GameRegistry.register(GlowstonePickaxe);
		GameRegistry.register(GlowstoneAxe);
		GameRegistry.register(GlowstoneShovel);
		GameRegistry.register(GlowstoneHoe);
		GameRegistry.register(GlowstoneSword);
		GameRegistry.register(GlowstoneHelmet);
		GameRegistry.register(GlowstoneChestplate);
		GameRegistry.register(GlowstoneLeggings);
		GameRegistry.register(GlowstoneBoots);

		//Steel
		GameRegistry.register(SteelPaxel);
		GameRegistry.register(SteelPickaxe);
		GameRegistry.register(SteelAxe);
		GameRegistry.register(SteelShovel);
		GameRegistry.register(SteelHoe);
		GameRegistry.register(SteelSword);
		GameRegistry.register(SteelHelmet);
		GameRegistry.register(SteelChestplate);
		GameRegistry.register(SteelLeggings);
		GameRegistry.register(SteelBoots);
		
		MekanismTools.proxy.registerItemRenders();
	}
	
	public static Item init(Item item, String name)
	{
		return item.func_77655_b(name).setRegistryName("mekanismtools:" + name);
	}
}
