package mekanism.generators.common.tile.reactor;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

import mekanism.api.Coord4D;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.generators.common.FusionReactor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public abstract class TileEntityReactorBlock extends TileEntityElectricBlock
{
	public FusionReactor fusionReactor;
	
	public boolean attempted;
	
	public boolean changed;

	public TileEntityReactorBlock()
	{
		super("ReactorBlock", 0);
		inventory = NonNullList.func_191197_a(0, ItemStack.field_190927_a);
	}
	
	public abstract boolean isFrame();

	public TileEntityReactorBlock(String name, double maxEnergy)
	{
		super(name, maxEnergy);
	}

	public void setReactor(FusionReactor reactor)
	{
		if(reactor != fusionReactor)
		{
			changed = true;
		}
		
		fusionReactor = reactor;
	}

	public FusionReactor getReactor()
	{
		return fusionReactor;
	}

	@Override
	public void func_145843_s()
	{
		super.func_145843_s();
		
		if(getReactor() != null)
		{
			getReactor().formMultiblock(false);
		}
	}

	@Override
	public void onUpdate()
	{
		super.onUpdate();
		
		if(changed)
		{
			changed = false;
		}
		
		if(!field_145850_b.field_72995_K && ticker == 5 && !attempted && (getReactor() == null || !getReactor().isFormed()))
		{
			updateController();
		}
		
		attempted = false;
	}

	@Override
	public boolean sideIsOutput(EnumFacing side)
	{
		return false;
	}

	@Override
	public boolean sideIsConsumer(EnumFacing side) 
	{
		return false;
	}

	@Override
	public void onChunkUnload()
	{
		super.onChunkUnload();

		if(!(this instanceof TileEntityReactorController) && getReactor() != null)
		{
			getReactor().formMultiblock(true);
		}
	}
	
	@Override
	public void onAdded()
	{
		super.onAdded();

		if(!field_145850_b.field_72995_K)
		{
			if(getReactor() != null)
			{
				getReactor().formMultiblock(false);
			}
			else {
				updateController();
			}
		}
	}
	
	public void updateController()
	{
		if(!(this instanceof TileEntityReactorController))
		{
			TileEntityReactorController found = new ControllerFinder().find();
			
			if(found != null && (found.getReactor() == null || !found.getReactor().isFormed()))
			{
				found.formMultiblock(false);
			}
		}
	}
	
	public class ControllerFinder
	{
		public TileEntityReactorController found;
		
		public Set<Coord4D> iterated = new HashSet<Coord4D>();
		
		public void loop(Coord4D pos)
		{
			if(iterated.size() > 512 || found != null)
			{
				return;
			}
			
			iterated.add(pos);
			
			for(EnumFacing side : EnumFacing.field_82609_l)
			{
				Coord4D coord = pos.offset(side);
				
				if(!iterated.contains(coord) && coord.getTileEntity(field_145850_b) instanceof TileEntityReactorBlock)
				{
					((TileEntityReactorBlock)coord.getTileEntity(field_145850_b)).attempted = true;
					
					if(coord.getTileEntity(field_145850_b) instanceof TileEntityReactorController)
					{
						found = (TileEntityReactorController)coord.getTileEntity(field_145850_b);
						return;
					}
					
					loop(coord);
				}
			}
		}
		
		public TileEntityReactorController find()
		{
			loop(Coord4D.get(TileEntityReactorBlock.this));
			
			return found;
		}
	}
}
